/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Database.implementations;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.CDatabaseConfiguration;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntConnectException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDriverException;
import com.google.security.zynamics.binnavi.Gui.Database.implementations.CDatabaseCreator;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import java.awt.Window;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public final class CDatabaseConnector {
    private static String POSTGRES_DEFAULT_DB = "postgres";
    private static String POSTGRES_DRIVER = "jdbc:postgresql:";

    private CDatabaseConnector() {
    }

    private static void checkDriver(CDatabaseConfiguration configuration) throws CouldntLoadDriverException {
        try {
            Class.forName(configuration.getDriver()).newInstance();
        }
        catch (Exception e2) {
            CUtilityFunctions.logException(e2);
            throw new CouldntLoadDriverException(String.format("Could not load database driver '%s'.", configuration.getDriver()));
        }
    }

    public static CConnection connect(CDatabaseConfiguration configuration) throws CouldntLoadDriverException, CouldntConnectException {
        CDatabaseConnector.checkDriver(configuration);
        try {
            return new CConnection(configuration);
        }
        catch (SQLException e2) {
            CUtilityFunctions.logException(e2);
            throw new CouldntConnectException(e2, e2.getErrorCode(), e2.getSQLState());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(CDatabaseConfiguration configuration) throws CouldntLoadDriverException, CouldntConnectException, SQLException {
        CDatabaseConnector.checkDriver(configuration);
        String string2 = POSTGRES_DRIVER;
        String string3 = configuration.getHost();
        String string4 = POSTGRES_DEFAULT_DB;
        String url = new StringBuilder(3 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append(string2).append("//").append(string3).append("/").append(string4).toString();
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(url, configuration.getUser(), configuration.getPassword());
        }
        catch (SQLException exception) {
            CUtilityFunctions.logException(exception);
            throw new CouldntConnectException(exception, exception.getErrorCode(), exception.getSQLState());
        }
        string4 = configuration.getName();
        String statement = new StringBuilder(18 + String.valueOf(string4).length()).append("CREATE DATABASE \"").append(string4).append("\"").toString();
        PreparedStatement preparedStatement = connection.prepareStatement(statement);
        try {
            preparedStatement.execute();
        }
        finally {
            preparedStatement.close();
            connection.close();
        }
    }

    public static void testConnection(Window parent, CDatabaseConfiguration configuration) {
        try {
            CDatabaseConnector.connect(configuration).closeConnection();
            CMessageBox.showInformation(parent, "Successfully connected to the database.");
        }
        catch (CouldntLoadDriverException exception) {
            String message2 = "E00021: Database driver could not be loaded";
            String description = CUtilityFunctions.createDescription(String.format("BinNavi could not create a database connection because the database driver '%s' could not be loaded", configuration.getDriver()), new String[]{"The database driver string is wrong.", "The database driver file could not be found."}, new String[]{"BinNavi can not load data from the given database until the problem is resolved."});
            NaviErrorDialog.show(parent, "E00021: Database driver could not be loaded", description, exception);
        }
        catch (CouldntConnectException exception) {
            if (exception.getSqlState().equalsIgnoreCase("28P01")) {
                CMessageBox.showInformation(parent, String.format("The password for user '%s' on database '%s' is invalid", configuration.getUser(), configuration.getUrl()));
                return;
            }
            if (exception.getSqlState().equalsIgnoreCase("3D000")) {
                if (0 == CMessageBox.showYesNoCancelQuestion(parent, String.format("The database '%s' does not exist. Do you want to create it now?", configuration.getUrl()))) {
                    CDatabaseCreator.createDatabase(parent, configuration);
                }
            }
            String message3 = "E00022: Database connection could not be established";
            String description = CUtilityFunctions.createDescription(String.format("BinNavi could not connect to the database '%s'", configuration.getUrl()), new String[]{exception.getMessage()}, new String[]{"BinNavi can not load data from the given database until the problem is resolved."});
            NaviErrorDialog.show(parent, "E00022: Database connection could not be established", description, exception);
        }
    }
}

