/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionTree;

import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.CConditionCriterium;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.ICriterium;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.ICriteriumCreator;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.ICriteriumListener;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionModel.CCriteriumTree;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionModel.ICriteriumTreeListener;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionModel.ICriteriumTreeNode;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionTree.JCriteriumTreeNode;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public final class JCriteriumTreeModel
extends DefaultTreeModel {
    private static final long serialVersionUID = 2472212228826158436L;
    private final JTree m_jtree;
    private final CCriteriumTree m_criteriumTree;
    private final List<ICriteriumCreator> m_criteria;
    private final ICriteriumTreeListener m_internalTreeListener = new CriteriumTreeListener();
    private final InternalCriteriumListener m_internalCriteriumListener = new InternalCriteriumListener();

    public JCriteriumTreeModel(JTree jtree, CCriteriumTree criteriumTree, List<ICriteriumCreator> criteria) {
        super(new JCriteriumTreeNode(criteriumTree, criteriumTree.getRoot().getCriterium(), criteria));
        this.m_jtree = jtree;
        this.m_criteriumTree = criteriumTree;
        this.m_criteria = criteria;
        this.m_criteriumTree.addListener(this.m_internalTreeListener);
    }

    private JCriteriumTreeNode findParentNode(JCriteriumTreeNode node, ICriterium criterium) {
        if (node.getCriterium() == criterium) {
            return node;
        }
        for (int i2 = 0; i2 < node.getChildCount(); ++i2) {
            JCriteriumTreeNode child = (JCriteriumTreeNode)node.getChildAt(i2);
            JCriteriumTreeNode parent = this.findParentNode(child, criterium);
            if (parent == null) continue;
            return parent;
        }
        return null;
    }

    private void sortChildren(JCriteriumTreeNode parentNode) {
        ArrayList<JCriteriumTreeNode> operators = new ArrayList<JCriteriumTreeNode>();
        ArrayList<JCriteriumTreeNode> conditions = new ArrayList<JCriteriumTreeNode>();
        ArrayList minus = new ArrayList();
        Enumeration<TreeNode> children = parentNode.children();
        while (children.hasMoreElements()) {
            JCriteriumTreeNode child = (JCriteriumTreeNode)children.nextElement();
            ICriterium type = child.getCriterium();
            if (type instanceof CConditionCriterium) {
                conditions.add(child);
                continue;
            }
            operators.add(child);
        }
        parentNode.removeAllChildren();
        for (JCriteriumTreeNode child : operators) {
            parentNode.add(child);
            child.setParent(parentNode);
        }
        for (JCriteriumTreeNode child : conditions) {
            parentNode.add(child);
            child.setParent(parentNode);
        }
        for (JCriteriumTreeNode child : minus) {
            parentNode.add(child);
            child.setParent(parentNode);
        }
    }

    public void dispose() {
        this.m_criteriumTree.removeListener(this.m_internalTreeListener);
    }

    @Override
    public void nodeStructureChanged(TreeNode node) {
        HashSet<ICriterium> criteriumSet = new HashSet<ICriterium>();
        Enumeration<TreePath> expandedPaths = this.m_jtree.getExpandedDescendants(new TreePath(this.getRoot()));
        if (expandedPaths != null) {
            while (expandedPaths.hasMoreElements()) {
                TreePath path = expandedPaths.nextElement();
                JCriteriumTreeNode expandedNode = (JCriteriumTreeNode)path.getLastPathComponent();
                criteriumSet.add(expandedNode.getCriterium());
            }
        }
        super.nodeStructureChanged(node);
        Enumeration<TreeNode> nodes = ((JCriteriumTreeNode)this.getRoot()).breadthFirstEnumeration();
        while (nodes.hasMoreElements()) {
            JCriteriumTreeNode nextNode = (JCriteriumTreeNode)nodes.nextElement();
            if (!criteriumSet.contains(nextNode.getCriterium())) continue;
            this.m_jtree.expandPath(new TreePath(nextNode.getPath()));
        }
    }

    private class InternalCriteriumListener
    implements ICriteriumListener {
        private InternalCriteriumListener() {
        }

        @Override
        public void criteriumChanged() {
            JCriteriumTreeModel.this.reload();
        }
    }

    private class CriteriumTreeListener
    implements ICriteriumTreeListener {
        private CriteriumTreeListener() {
        }

        @Override
        public void appendedNode(CCriteriumTree criteriumTree, ICriteriumTreeNode parent, ICriteriumTreeNode child) {
            JCriteriumTreeNode parentNode = JCriteriumTreeModel.this.findParentNode((JCriteriumTreeNode)JCriteriumTreeModel.this.getRoot(), parent.getCriterium());
            JCriteriumTreeNode childNode = new JCriteriumTreeNode(criteriumTree, child.getCriterium(), JCriteriumTreeModel.this.m_criteria);
            parentNode.add(childNode);
            childNode.setParent(parentNode);
            JCriteriumTreeModel.this.sortChildren(parentNode);
            JCriteriumTreeModel.this.nodeStructureChanged(parentNode);
            JCriteriumTreeModel.this.m_jtree.setSelectionPath(new TreePath(childNode.getPath()));
            child.getCriterium().addListener(JCriteriumTreeModel.this.m_internalCriteriumListener);
        }

        @Override
        public void insertedNode(CCriteriumTree criteriumTree, ICriteriumTreeNode parent, ICriteriumTreeNode child) {
            JCriteriumTreeNode parentNode = JCriteriumTreeModel.this.findParentNode((JCriteriumTreeNode)JCriteriumTreeModel.this.getRoot(), parent.getCriterium());
            JCriteriumTreeNode newNode = new JCriteriumTreeNode(criteriumTree, child.getCriterium(), JCriteriumTreeModel.this.m_criteria);
            ArrayList<JCriteriumTreeNode> grandChildren = new ArrayList<JCriteriumTreeNode>();
            Enumeration<TreeNode> enumeration = parentNode.children();
            while (enumeration.hasMoreElements()) {
                grandChildren.add((JCriteriumTreeNode)enumeration.nextElement());
            }
            for (JCriteriumTreeNode grandChild : grandChildren) {
                newNode.add(grandChild);
                grandChild.setParent(newNode);
            }
            parentNode.removeAllChildren();
            parentNode.add(newNode);
            newNode.setParent(parentNode);
            JCriteriumTreeModel.this.nodeStructureChanged(parentNode);
            JCriteriumTreeModel.this.m_jtree.setSelectionPath(new TreePath(newNode.getPath()));
            child.getCriterium().addListener(JCriteriumTreeModel.this.m_internalCriteriumListener);
        }

        @Override
        public void removedAll(CCriteriumTree criteriumTree) {
            JCriteriumTreeNode rootNode = (JCriteriumTreeNode)JCriteriumTreeModel.this.getRoot();
            rootNode.removeAllChildren();
            JCriteriumTreeModel.this.nodeStructureChanged(rootNode);
            JCriteriumTreeModel.this.m_jtree.setSelectionPath(new TreePath(rootNode.getPath()));
        }

        @Override
        public void removedNode(CCriteriumTree criteriumTree, ICriteriumTreeNode criteriumNode) {
            JCriteriumTreeNode treeNode = JCriteriumTreeModel.this.findParentNode((JCriteriumTreeNode)JCriteriumTreeModel.this.getRoot(), criteriumNode.getCriterium());
            treeNode.removeAllChildren();
            JCriteriumTreeNode parent = (JCriteriumTreeNode)treeNode.getParent();
            parent.remove(treeNode);
            JCriteriumTreeModel.this.nodeStructureChanged(treeNode);
            JCriteriumTreeModel.this.m_jtree.setSelectionPath(new TreePath(parent.getPath()));
            criteriumNode.getCriterium().removeListener(JCriteriumTreeModel.this.m_internalCriteriumListener);
        }
    }
}

