/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionModel;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.Root.CRootCriterium;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionModel.CCachedExpressionTree;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionModel.CCachedExpressionTreeNode;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionModel.CCriteriumTreeNode;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionModel.IAbstractCriteriumTree;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionModel.ICriteriumTreeListener;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionModel.ICriteriumTreeNode;
import com.google.security.zynamics.zylib.general.ListenerProvider;

public final class CCriteriumTree
implements IAbstractCriteriumTree {
    private final ListenerProvider<ICriteriumTreeListener> m_listeners = new ListenerProvider();
    private final CCriteriumTreeNode m_rootNode = new CCriteriumTreeNode(new CRootCriterium());

    private void createCachedTree(CCriteriumTreeNode originalParent, CCachedExpressionTreeNode cachedExpressionTreeNode) {
        for (CCriteriumTreeNode originalChild : originalParent.getChildren()) {
            CCachedExpressionTreeNode clonedChild = originalChild.createCachedNode();
            CCachedExpressionTreeNode.append(cachedExpressionTreeNode, clonedChild);
            this.createCachedTree(originalChild, clonedChild);
        }
    }

    public void addListener(ICriteriumTreeListener listener) {
        this.m_listeners.addListener(listener);
    }

    public void appendNode(CCriteriumTreeNode parent, CCriteriumTreeNode child) {
        CCriteriumTreeNode.append(parent, child);
        for (ICriteriumTreeListener listener : this.m_listeners) {
            try {
                listener.appendedNode(this, parent, child);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void clear() {
        if (this.m_rootNode.getChildren().size() == 1) {
            this.remove(this.m_rootNode.getChildren().get(0));
        }
        for (ICriteriumTreeListener listener : this.m_listeners) {
            try {
                listener.removedAll(this);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public CCachedExpressionTree createCachedTree() {
        CCachedExpressionTree newTree = new CCachedExpressionTree();
        this.createCachedTree(this.m_rootNode, newTree.getRoot());
        return newTree;
    }

    @Override
    public CCriteriumTreeNode getRoot() {
        return this.m_rootNode;
    }

    public void insertNode(CCriteriumTreeNode parent, CCriteriumTreeNode child) {
        CCriteriumTreeNode.insert(parent, child);
        for (ICriteriumTreeListener listener : this.m_listeners) {
            try {
                listener.insertedNode(this, parent, child);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void remove(ICriteriumTreeNode node) {
        CCriteriumTreeNode.remove(node);
        ICriteriumTreeNode parent = node.getParent();
        parent.getChildren().remove(node);
        for (ICriteriumTreeListener listener : this.m_listeners) {
            try {
                listener.removedNode(this, node);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void removeListener(ICriteriumTreeListener listener) {
        this.m_listeners.removeListener(listener);
    }
}

