/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.Text;

import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.ICachedCriterium;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.Text.CTextEvaluator;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionModel.CCachedExpressionTreeNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import java.util.List;

public final class CCachedTextCriterium
implements ICachedCriterium {
    private final String m_text;
    private final boolean m_regularExpression;
    private final boolean m_caseSensitive;

    public CCachedTextCriterium(String text2, boolean regularExpression, boolean caseSensitive) {
        this.m_text = text2;
        this.m_regularExpression = regularExpression;
        this.m_caseSensitive = caseSensitive;
    }

    @Override
    public String getFormulaString(List<CCachedExpressionTreeNode> children) {
        boolean additionalInformation = this.m_regularExpression || this.m_caseSensitive;
        String string2 = String.valueOf("CONTAINS=");
        String string3 = String.valueOf(this.m_text);
        StringBuilder formula = new StringBuilder(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        if (additionalInformation) {
            formula.append('(');
            if (this.m_regularExpression) {
                formula.append("REGEX");
            }
            if (this.m_caseSensitive) {
                if (this.m_regularExpression) {
                    formula.append(", ");
                }
                formula.append("CASE SENSITIVE");
            }
            formula.append('(');
        }
        return formula.toString();
    }

    @Override
    public boolean matches(NaviNode node) {
        return CTextEvaluator.evaluate(node, this.m_text, this.m_regularExpression, this.m_caseSensitive);
    }
}

