/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.Tag;

import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.Tag.CTagCriterium;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.Tag.CTagTreeNode;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.Tagging.CTagManager;
import com.google.security.zynamics.binnavi.Tagging.ITagManager;
import com.google.security.zynamics.binnavi.Tagging.ITagManagerListener;
import com.google.security.zynamics.zylib.gui.jtree.IconNodeRenderer;
import com.google.security.zynamics.zylib.types.trees.ITreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public final class CTagCriteriumPanel
extends JPanel {
    private static final long serialVersionUID = -2231647585848005777L;
    private final CTagCriterium m_criterium;
    private final ITagManager m_tagManager;
    private final JTree m_tagTree = new JTree();
    private final JCheckBox m_anyTagBox = new JCheckBox("Any Tag");
    private final InternalTreeSelectionListener m_selectionListener = new InternalTreeSelectionListener();
    private final InternalCheckboxChangeListener m_checkboxListener = new InternalCheckboxChangeListener();
    private final ITagManagerListener m_listener = new InternalTagManagerListener();

    public CTagCriteriumPanel(CTagCriterium tagCriterium, ITagManager tagManager) {
        super(new BorderLayout());
        this.m_criterium = tagCriterium;
        this.m_tagManager = tagManager;
        this.m_tagTree.addTreeSelectionListener(this.m_selectionListener);
        this.m_anyTagBox.addChangeListener(this.m_checkboxListener);
        this.initPanel(tagManager.getRootTag());
        tagManager.addListener(this.m_listener);
    }

    private void createTree(ITreeNode<CTag> root) {
        this.m_tagTree.setRootVisible(false);
        DefaultTreeModel tagTreeModel = new DefaultTreeModel(new CTagTreeNode(root));
        this.m_tagTree.setModel(tagTreeModel);
        this.m_tagTree.setCellRenderer(new IconNodeRenderer());
    }

    private void initPanel(ITreeNode<CTag> rootTag) {
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(new TitledBorder("Edit Tag Condition"));
        this.createTree(rootTag);
        JScrollPane pane = new JScrollPane(this.m_tagTree);
        pane.setVerticalScrollBarPolicy(20);
        pane.setHorizontalScrollBarPolicy(30);
        JPanel anyTagPanel = new JPanel();
        anyTagPanel.add(this.m_anyTagBox);
        mainPanel.add((Component)pane, "Center");
        mainPanel.add((Component)this.m_anyTagBox, "South");
        this.add((Component)mainPanel, "Center");
    }

    public void dispose() {
        this.m_tagTree.removeTreeSelectionListener(this.m_selectionListener);
        this.m_anyTagBox.removeChangeListener(this.m_checkboxListener);
        this.m_tagManager.removeListener(this.m_listener);
    }

    public CTag getTag() {
        TreePath path = this.m_tagTree.getSelectionPath();
        return path == null ? null : ((CTagTreeNode)path.getLastPathComponent()).getTag();
    }

    public boolean isAny() {
        return this.m_anyTagBox.isSelected();
    }

    private class InternalTreeSelectionListener
    implements TreeSelectionListener {
        private InternalTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent event) {
            CTagCriteriumPanel.this.m_criterium.notifyListeners();
        }
    }

    private class InternalTagManagerListener
    implements ITagManagerListener {
        private InternalTagManagerListener() {
        }

        @Override
        public void addedTag(CTagManager manager, ITreeNode<CTag> tag) {
            CTagCriteriumPanel.this.createTree(manager.getRootTag());
        }

        @Override
        public void deletedTag(CTagManager manager, ITreeNode<CTag> parent, ITreeNode<CTag> tag) {
            CTagCriteriumPanel.this.createTree(manager.getRootTag());
        }

        @Override
        public void deletedTagSubtree(CTagManager manager, ITreeNode<CTag> parent, ITreeNode<CTag> tag) {
            CTagCriteriumPanel.this.createTree(manager.getRootTag());
        }

        @Override
        public void insertedTag(CTagManager manager, ITreeNode<CTag> parent, ITreeNode<CTag> tag) {
            CTagCriteriumPanel.this.createTree(manager.getRootTag());
        }
    }

    private class InternalCheckboxChangeListener
    implements ChangeListener {
        private InternalCheckboxChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent arg0) {
            CTagCriteriumPanel.this.m_criterium.notifyListeners();
        }
    }
}

