/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Cache;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Cache.ICriteriumCacheListener;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionModel.CCachedExpressionTree;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.types.lists.FilledList;
import com.google.security.zynamics.zylib.types.lists.IFilledList;
import java.util.Collection;

public final class CCriteriumCache {
    private static final int MAXIMUM_CACHE_SIZE = 10;
    private final IFilledList<CCachedExpressionTree> m_trees = new FilledList<CCachedExpressionTree>();
    private final ListenerProvider<ICriteriumCacheListener> m_listeners = new ListenerProvider();

    public void add(CCachedExpressionTree tree) {
        for (CCachedExpressionTree cachedTree : this.m_trees) {
            if (!cachedTree.getFormulaString().equals(tree.getFormulaString())) continue;
            return;
        }
        this.m_trees.add(tree);
        while (this.m_trees.size() > 10) {
            this.m_trees.remove(0);
        }
        for (ICriteriumCacheListener listener : this.m_listeners) {
            try {
                listener.changedCriteria(this);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void addListener(ICriteriumCacheListener listener) {
        this.m_listeners.addListener(listener);
    }

    public IFilledList<CCachedExpressionTree> getTrees() {
        return new FilledList<CCachedExpressionTree>((Collection<CCachedExpressionTree>)this.m_trees);
    }

    public void removeListener(ICriteriumCacheListener listener) {
        this.m_listeners.removeListener(listener);
    }
}

