/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.CodeBookmarks;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.models.Bookmarks.code.CCodeBookmark;
import com.google.security.zynamics.binnavi.models.Bookmarks.code.CCodeBookmarkManager;
import com.google.security.zynamics.binnavi.models.Bookmarks.code.ICodeBookmarkListener;
import com.google.security.zynamics.binnavi.models.Bookmarks.code.ICodeBookmarkManagerListener;
import javax.swing.table.AbstractTableModel;

public final class CCodeBookmarkTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1397090388866442638L;
    private static final int MODULE_COLUMN = 0;
    private static final int ADDRESS_COLUMN = 1;
    private static final int DESCRIPTION_COLUMN = 2;
    private static final String[] COLUMN_NAMES = new String[]{"Module", "Address", "Description"};
    private final InternalBookmarkListener m_listener = new InternalBookmarkListener();
    private final CCodeBookmarkManager m_bookmarkManager;

    public CCodeBookmarkTableModel(CCodeBookmarkManager bookmarkManager) {
        this.m_bookmarkManager = Preconditions.checkNotNull(bookmarkManager, "IE01311: Bookmarks manager can't be null");
        this.initializeListeners();
    }

    private void initializeListeners() {
        this.m_bookmarkManager.addListener(this.m_listener);
        for (CCodeBookmark bookmark : this.m_bookmarkManager) {
            bookmark.addListener(this.m_listener);
        }
    }

    private void removeListeners() {
        this.m_bookmarkManager.removeListener(this.m_listener);
        for (CCodeBookmark bookmark : this.m_bookmarkManager) {
            bookmark.removeListener(this.m_listener);
        }
    }

    public void dispose() {
        this.removeListeners();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int col) {
        return COLUMN_NAMES[col];
    }

    @Override
    public int getRowCount() {
        return this.m_bookmarkManager.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.m_bookmarkManager.get(row).getModule().getConfiguration().getName();
            }
            case 1: {
                return this.m_bookmarkManager.get(row).getAddress().toHexString();
            }
            case 2: {
                return this.m_bookmarkManager.get(row).getDescription();
            }
        }
        throw new IllegalArgumentException("IE01312: Unknown column");
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 2;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Preconditions.checkArgument(col == 2, "IE01313: Only the description column can be modified");
        this.m_bookmarkManager.get(row).setDescription(value.toString());
    }

    private class InternalBookmarkListener
    implements ICodeBookmarkManagerListener,
    ICodeBookmarkListener {
        private InternalBookmarkListener() {
        }

        @Override
        public void addedBookmark(CCodeBookmarkManager manager, CCodeBookmark bookmark) {
            bookmark.addListener(CCodeBookmarkTableModel.this.m_listener);
            CCodeBookmarkTableModel.this.fireTableDataChanged();
        }

        @Override
        public void changedDescription(CCodeBookmark bookmark) {
            CCodeBookmarkTableModel.this.fireTableDataChanged();
        }

        @Override
        public void removedBookmark(CCodeBookmarkManager manager, CCodeBookmark bookmark) {
            bookmark.removeListener(CCodeBookmarkTableModel.this.m_listener);
            CCodeBookmarkTableModel.this.fireTableDataChanged();
        }
    }
}

