/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.ZyGraph.ZyGraphViewSettings;
import com.google.security.zynamics.zylib.gui.CDialogEscaper;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class CProximitySettingsDialog
extends JDialog {
    private final ZyGraphViewSettings m_settings;
    private static final long serialVersionUID = -7599777976161689962L;
    private final JSlider m_parentDepthSlider = new JSlider(0, 10, 2);
    private final JSlider m_childDepthSlider = new JSlider(0, 10, 2);
    private final JLabel m_parentLabel = new JLabel();
    private final JLabel m_childLabel = new JLabel();
    private final JButton m_buttonOk = new JButton("OK");
    private final JButton m_buttonCancel = new JButton("Cancel");
    private final JCheckBox m_checkBoxParentDepth = new JCheckBox("Visible Parents:");
    private final JCheckBox m_checkBoxChildDepth = new JCheckBox("Visible Children:");
    private final InternalActionListener m_actionListener = new InternalActionListener();
    private final InternalItemListener m_itemListener = new InternalItemListener();

    private CProximitySettingsDialog(JFrame parent, ZyGraphViewSettings settings) {
        super(parent, "Proximity Browsing Settings", true);
        Preconditions.checkNotNull(settings, "IE01154: Settings argument can not be null");
        this.m_settings = settings;
        new CDialogEscaper(this);
        this.m_parentDepthSlider.setMinorTickSpacing(1);
        this.m_parentDepthSlider.setPaintTicks(true);
        this.m_parentDepthSlider.setSnapToTicks(true);
        this.m_parentDepthSlider.setPaintTrack(true);
        this.m_parentDepthSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                CProximitySettingsDialog.this.m_parentLabel.setText(Integer.valueOf(CProximitySettingsDialog.this.m_parentDepthSlider.getValue()).toString());
            }
        });
        this.m_childDepthSlider.setMinorTickSpacing(1);
        this.m_childDepthSlider.setPaintTicks(true);
        this.m_childDepthSlider.setSnapToTicks(true);
        this.m_childDepthSlider.setPaintTrack(true);
        this.m_childDepthSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                CProximitySettingsDialog.this.m_childLabel.setText(Integer.valueOf(CProximitySettingsDialog.this.m_childDepthSlider.getValue()).toString());
            }
        });
        this.m_buttonOk.addActionListener(this.m_actionListener);
        this.m_buttonCancel.addActionListener(this.m_actionListener);
        this.m_checkBoxChildDepth.addItemListener(this.m_itemListener);
        this.m_checkBoxParentDepth.addItemListener(this.m_itemListener);
        this.setDefaultCloseOperation(2);
        this.synchronizeGUIFromSettings();
        this.createPanels();
        this.pack();
        GuiHelper.centerChildToParent(parent, this, true);
    }

    public static void showDialog(JFrame parent, ZyGraphViewSettings settings) {
        CProximitySettingsDialog dialog = new CProximitySettingsDialog(parent, settings);
        dialog.setVisible(true);
    }

    private void createPanels() {
        this.setLayout(new BorderLayout(5, 5));
        JPanel p_1 = new JPanel();
        p_1.setLayout(new BorderLayout(5, 5));
        p_1.setBorder(new TitledBorder("View Depth"));
        JPanel p_1_1 = new JPanel();
        p_1_1.setLayout(new BorderLayout(5, 5));
        p_1_1.add((Component)this.m_checkBoxParentDepth, "West");
        p_1_1.add((Component)this.m_parentLabel, "Center");
        p_1_1.add((Component)this.m_parentDepthSlider, "East");
        JPanel p_1_2 = new JPanel();
        p_1_2.setLayout(new BorderLayout(5, 5));
        p_1_2.add((Component)this.m_checkBoxChildDepth, "West");
        p_1_2.add((Component)this.m_childLabel, "Center");
        p_1_2.add((Component)this.m_childDepthSlider, "East");
        p_1.add((Component)p_1_1, "North");
        p_1.add((Component)p_1_2, "South");
        JPanel p_2 = new JPanel();
        p_2.setLayout(new BorderLayout(5, 0));
        JPanel p_2_1 = new JPanel();
        JPanel p_2_1_1 = new JPanel();
        p_2_1_1.setLayout(new GridLayout(1, 2, 5, 5));
        p_2_1_1.add(this.m_buttonOk);
        p_2_1_1.add(this.m_buttonCancel);
        p_2_1.add(p_2_1_1);
        p_2.add((Component)p_2_1, "East");
        this.add((Component)p_1, "North");
        this.add((Component)p_2, "South");
    }

    private void synchronizeGUIFromSettings() {
        int parentDepth = this.m_settings.getProximitySettings().getProximityBrowsingParents();
        int childDepth = this.m_settings.getProximitySettings().getProximityBrowsingChildren();
        if (parentDepth == -1) {
            this.m_parentDepthSlider.setValue(0);
            this.m_checkBoxParentDepth.setSelected(false);
        } else {
            this.m_parentDepthSlider.setValue(parentDepth);
            this.m_checkBoxParentDepth.setSelected(true);
        }
        this.m_parentLabel.setText(parentDepth == -1 ? "all   " : String.valueOf(Integer.valueOf(this.m_parentDepthSlider.getValue()).toString()).concat("   "));
        this.m_parentDepthSlider.setEnabled(parentDepth != -1);
        if (childDepth == -1) {
            this.m_childDepthSlider.setValue(0);
            this.m_checkBoxChildDepth.setSelected(false);
        } else {
            this.m_childDepthSlider.setValue(childDepth);
            this.m_checkBoxChildDepth.setSelected(true);
        }
        this.m_childLabel.setText(childDepth == -1 ? "all   " : String.valueOf(Integer.valueOf(this.m_childDepthSlider.getValue()).toString()).concat("   "));
        this.m_childDepthSlider.setEnabled(childDepth != -1);
    }

    private class InternalItemListener
    implements ItemListener {
        private InternalItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            if (event.getSource() == CProximitySettingsDialog.this.m_checkBoxParentDepth) {
                CProximitySettingsDialog.this.m_parentLabel.setText(CProximitySettingsDialog.this.m_checkBoxParentDepth.isSelected() ? Integer.valueOf(CProximitySettingsDialog.this.m_parentDepthSlider.getValue()).toString() : "all");
                CProximitySettingsDialog.this.m_parentDepthSlider.setEnabled(CProximitySettingsDialog.this.m_checkBoxParentDepth.isSelected());
            } else if (event.getSource() == CProximitySettingsDialog.this.m_checkBoxChildDepth) {
                CProximitySettingsDialog.this.m_childLabel.setText(CProximitySettingsDialog.this.m_checkBoxChildDepth.isSelected() ? Integer.valueOf(CProximitySettingsDialog.this.m_childDepthSlider.getValue()).toString() : "all");
                CProximitySettingsDialog.this.m_childDepthSlider.setEnabled(CProximitySettingsDialog.this.m_checkBoxChildDepth.isSelected());
            }
        }
    }

    private class InternalActionListener
    implements ActionListener {
        private InternalActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == CProximitySettingsDialog.this.m_buttonOk) {
                int childDepth = CProximitySettingsDialog.this.m_checkBoxChildDepth.isSelected() ? CProximitySettingsDialog.this.m_childDepthSlider.getValue() : -1;
                int parentDepth = CProximitySettingsDialog.this.m_checkBoxParentDepth.isSelected() ? CProximitySettingsDialog.this.m_parentDepthSlider.getValue() : -1;
                CProximitySettingsDialog.this.m_settings.getProximitySettings().setProximityBrowsingParents(parentDepth);
                CProximitySettingsDialog.this.m_settings.getProximitySettings().setProximityBrowsingChildren(childDepth);
            }
            CProximitySettingsDialog.this.dispose();
        }
    }
}

