/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.cache;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProviderListener;
import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NodeCache {
    private static Map<SQLProvider, NodeCache> caches = new HashMap<SQLProvider, NodeCache>();
    Cache<Integer, INaviViewNode> nodeByIdCache = CacheBuilder.newBuilder().weakValues().build();
    Cache<NodeIdentifier, List<Integer>> addressModuleIdNodeIdsCache = CacheBuilder.newBuilder().build();
    private final SQLProvider provider;
    private final SQLProviderListener providerListener = new InternalSQLProviderListener();

    private NodeCache(SQLProvider provider) {
        this.provider = provider;
        this.provider.addListener(this.providerListener);
    }

    public static synchronized NodeCache get(SQLProvider provider) {
        Preconditions.checkNotNull(provider, "IE01239: Provider argument can not be null");
        if (!caches.containsKey(provider)) {
            caches.put(provider, new NodeCache(provider));
        }
        return caches.get(provider);
    }

    private void close() {
        caches.remove(this.provider);
        this.provider.removeListener(this.providerListener);
    }

    public ImmutableCollection<INaviViewNode> getNodeByAddress(IAddress nodeAddress, Integer moduleId) {
        List<Integer> nodeIds = this.addressModuleIdNodeIdsCache.getIfPresent(new NodeIdentifier(nodeAddress, moduleId));
        return this.nodeByIdCache.getAllPresent(nodeIds).values();
    }

    public void addNodes(List<INaviViewNode> nodes) {
        this.nodeByIdCache.putAll(Maps.uniqueIndex(nodes, new Function<INaviViewNode, Integer>(){

            @Override
            public Integer apply(INaviViewNode node) {
                return node.getId();
            }
        }));
        for (INaviViewNode node : nodes) {
            if (!(node instanceof INaviCodeNode)) continue;
            IAddress nodeAddress = ((INaviCodeNode)node).getAddress();
            Integer moduleId = null;
            try {
                moduleId = ((INaviCodeNode)node).getParentFunction().getModule().getConfiguration().getId();
            }
            catch (MaybeNullException e2) {
                continue;
            }
            if (moduleId == null) continue;
            this.UpdateAddressModuleIdCache(nodeAddress, moduleId, node);
        }
    }

    private void UpdateAddressModuleIdCache(IAddress nodeAddress, Integer moduleId, INaviViewNode node) {
        NodeIdentifier nodeAddressModuleId = new NodeIdentifier(nodeAddress, moduleId);
        List<Integer> nodeIds = this.addressModuleIdNodeIdsCache.getIfPresent(nodeAddressModuleId);
        if (nodeIds != null) {
            nodeIds.add(node.getId());
        } else {
            nodeIds = Lists.newArrayList(node.getId());
        }
        this.addressModuleIdNodeIdsCache.put(nodeAddressModuleId, nodeIds);
    }

    public INaviViewNode getNodeById(Integer nodeId) {
        return this.nodeByIdCache.getIfPresent(nodeId);
    }

    private class InternalSQLProviderListener
    implements SQLProviderListener {
        private InternalSQLProviderListener() {
        }

        @Override
        public void providerClosing(SQLProvider provider) {
            if (NodeCache.this.provider.equals(provider)) {
                NodeCache.this.close();
            }
        }
    }

    private class NodeIdentifier {
        private IAddress address;
        private Integer moduleId;

        public NodeIdentifier(IAddress address, Integer moduleId) {
            this.address = address;
            this.moduleId = moduleId;
        }

        public int hashCode() {
            return Objects.hash(this.address, this.moduleId);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof NodeIdentifier) {
                return Objects.equals(this.address, ((NodeIdentifier)other).address) && Objects.equals(this.moduleId, ((NodeIdentifier)other).moduleId);
            }
            return false;
        }
    }
}

