/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.cache;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProviderListener;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.HashMap;
import java.util.Map;

public class InstructionCache {
    private static Map<SQLProvider, InstructionCache> caches = new HashMap<SQLProvider, InstructionCache>();
    Cache<Pair<IAddress, Integer>, INaviInstruction> instructionByAddressCache = CacheBuilder.newBuilder().weakValues().build();
    private SQLProvider provider;
    private final SQLProviderListener providerListener = new InternalSQLProviderListener();

    private InstructionCache(SQLProvider provider) {
        this.provider = provider;
        this.provider.addListener(this.providerListener);
    }

    public static synchronized InstructionCache get(SQLProvider provider) {
        Preconditions.checkNotNull(provider, "IE01239: Provider argument can not be null");
        if (!caches.containsKey(provider)) {
            caches.put(provider, new InstructionCache(provider));
        }
        return caches.get(provider);
    }

    private void close() {
        caches.remove(this.provider);
        this.provider.removeListener(this.providerListener);
    }

    public void addInstructions(Iterable<INaviInstruction> instructions) {
        this.instructionByAddressCache.putAll(Maps.uniqueIndex(instructions, new Function<INaviInstruction, Pair<IAddress, Integer>>(){

            @Override
            public Pair<IAddress, Integer> apply(INaviInstruction instruction) {
                return new Pair<IAddress, Integer>(instruction.getAddress(), instruction.getModule().getConfiguration().getId());
            }
        }));
    }

    public INaviInstruction getInstructionByAddress(IAddress address, Integer moduleId) {
        return this.instructionByAddressCache.getIfPresent(new Pair<IAddress, Integer>(address, moduleId));
    }

    public void addInstruction(INaviInstruction instruction) {
        this.instructionByAddressCache.put(new Pair<IAddress, Integer>(instruction.getAddress(), instruction.getModule().getConfiguration().getId()), instruction);
    }

    private class InternalSQLProviderListener
    implements SQLProviderListener {
        private InternalSQLProviderListener() {
        }

        @Override
        public void providerClosing(SQLProvider provider) {
            if (InstructionCache.this.provider.equals(provider)) {
                InstructionCache.this.close();
            }
        }
    }
}

