/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.cache;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProviderListener;
import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.disassembly.IAddressNode;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviEdge;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EdgeCache {
    private static Map<SQLProvider, EdgeCache> caches = new HashMap<SQLProvider, EdgeCache>();
    Cache<Integer, INaviEdge> edgesByIdCache = CacheBuilder.newBuilder().weakValues().build();
    Cache<EdgeIdentifier, List<Integer>> edgeAddressToEdgeIdsCache = CacheBuilder.newBuilder().build();
    private SQLProvider provider;
    private final SQLProviderListener providerListener = new InternalSQLProviderListener();

    private EdgeCache(SQLProvider provider) {
        this.provider = provider;
        this.provider.addListener(this.providerListener);
    }

    public static synchronized EdgeCache get(SQLProvider provider) {
        Preconditions.checkNotNull(provider, "IE01239: Provider argument can not be null");
        if (!caches.containsKey(provider)) {
            caches.put(provider, new EdgeCache(provider));
        }
        return caches.get(provider);
    }

    private void close() {
        caches.remove(this.provider);
        this.provider.removeListener(this.providerListener);
    }

    public void addEdges(List<INaviEdge> edges) {
        ImmutableMap<Integer, INaviEdge> edgesMap = Maps.uniqueIndex(edges, new Function<INaviEdge, Integer>(){

            @Override
            public Integer apply(INaviEdge edge) {
                return edge.getId();
            }
        });
        this.edgesByIdCache.putAll(edgesMap);
        for (INaviEdge edge : edges) {
            if (!(edge.getSource() instanceof IAddressNode) || !(edge.getTarget() instanceof IAddressNode)) continue;
            IAddress sourceAddress = ((IAddressNode)edge.getSource()).getAddress();
            IAddress targetAddress = ((IAddressNode)edge.getTarget()).getAddress();
            Integer sourceModuleId = null;
            Integer targetModuleId = null;
            if (edge.getSource() instanceof INaviCodeNode) {
                sourceModuleId = this.getModuleId((INaviCodeNode)edge.getSource());
            } else if (edge.getSource() instanceof INaviFunctionNode) {
                sourceModuleId = this.getModuleId((INaviFunctionNode)edge.getSource());
            }
            if (edge.getTarget() instanceof INaviCodeNode) {
                targetModuleId = this.getModuleId((INaviCodeNode)edge.getTarget());
            } else if (edge.getTarget() instanceof INaviFunctionNode) {
                targetModuleId = this.getModuleId((INaviFunctionNode)edge.getTarget());
            }
            if (targetModuleId == null || sourceModuleId == null) continue;
            this.UpdateAddressModuleIdCache(sourceAddress, sourceModuleId, targetAddress, targetModuleId, edge);
        }
    }

    private void UpdateAddressModuleIdCache(IAddress sourceAddress, Integer sourceModuleId, IAddress targetAddress, Integer targetModuleId, INaviEdge edge) {
        EdgeIdentifier edgeAddressModuleIds = new EdgeIdentifier(sourceAddress, sourceModuleId, targetAddress, targetModuleId);
        List<Integer> edgeIds = this.edgeAddressToEdgeIdsCache.getIfPresent(edgeAddressModuleIds);
        if (edgeIds != null) {
            edgeIds.add(edge.getId());
        } else {
            edgeIds = Lists.newArrayList(edge.getId());
        }
        this.edgeAddressToEdgeIdsCache.put(edgeAddressModuleIds, edgeIds);
    }

    private Integer getModuleId(INaviCodeNode node) {
        try {
            return node.getParentFunction().getModule().getConfiguration().getId();
        }
        catch (MaybeNullException e2) {
            return null;
        }
    }

    private Integer getModuleId(INaviFunctionNode node) {
        return node.getFunction().getModule().getConfiguration().getId();
    }

    public INaviEdge getEdgeById(Integer edgeId) {
        return this.edgesByIdCache.getIfPresent(edgeId);
    }

    public ImmutableCollection<INaviEdge> getEdgeBySourceAndTarget(IAddress sourceAddress, Integer sourceModuleId, IAddress targetAddress, Integer targetModuleId) {
        EdgeIdentifier edgeAddressModuleIds = new EdgeIdentifier(sourceAddress, sourceModuleId, targetAddress, targetModuleId);
        List<Integer> edgeIds = this.edgeAddressToEdgeIdsCache.getIfPresent(edgeAddressModuleIds);
        return this.edgesByIdCache.getAllPresent(edgeIds).values();
    }

    private class InternalSQLProviderListener
    implements SQLProviderListener {
        private InternalSQLProviderListener() {
        }

        @Override
        public void providerClosing(SQLProvider provider) {
            if (EdgeCache.this.provider.equals(provider)) {
                EdgeCache.this.close();
            }
        }
    }

    private class EdgeIdentifier {
        private IAddress sourceAddress;
        private Integer sourceModuleId;
        private IAddress targetAddress;
        private Integer targetModuleId;

        public EdgeIdentifier(IAddress sourceAddress, Integer sourceModuleId, IAddress targetAddress, Integer targetModuleId) {
            this.sourceAddress = sourceAddress;
            this.sourceModuleId = sourceModuleId;
            this.targetAddress = targetAddress;
            this.targetModuleId = targetModuleId;
        }

        public int hashCode() {
            return Objects.hash(this.sourceAddress, this.sourceModuleId, this.targetAddress, this.targetModuleId);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof EdgeIdentifier) {
                return Objects.equals(this.sourceAddress, ((EdgeIdentifier)other).sourceAddress) && Objects.equals(this.sourceModuleId, ((EdgeIdentifier)other).sourceModuleId) && Objects.equals(this.targetAddress, ((EdgeIdentifier)other).targetAddress) && Objects.equals(this.targetModuleId, ((EdgeIdentifier)other).targetModuleId);
            }
            return false;
        }
    }
}

