/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.ContainerFinder;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.disassembly.ViewType;
import com.google.security.zynamics.zylib.types.lists.FilledList;
import com.google.security.zynamics.zylib.types.lists.IFilledList;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;

public class PostgreSQLHelpers {
    private PostgreSQLHelpers() {
    }

    private static void endTransaction(Connection connection) throws SQLException {
        Preconditions.checkNotNull(connection, "IE00598: Connection argument can not be null");
        Preconditions.checkArgument(!connection.getAutoCommit(), "IE00599: Commit can only be performed when auto commit is false");
        connection.commit();
        connection.setAutoCommit(true);
    }

    public static void beginTransaction(CConnection connection) throws SQLException {
        Preconditions.checkNotNull(connection, "IE00443: Connection argument can not be null");
        connection.getConnection().setAutoCommit(false);
    }

    public static void deleteByColumnValue(CConnection connection, String tableName, String columnName, int columnValue) throws CouldntDeleteException {
        Preconditions.checkNotNull(connection, "IE00487: Connection argument can not be null");
        Preconditions.checkNotNull(tableName, "IE00499: Table name argument can not be null");
        Preconditions.checkNotNull(columnName, "IE00593: Column name argument can not be null");
        Preconditions.checkArgument(columnValue >= 0, "IE00594: Column value argument can not be smaller then zero");
        try {
            connection.executeUpdate(String.format("DELETE FROM %s WHERE %s = %d", tableName, columnName, columnValue), true);
        }
        catch (SQLException exception) {
            throw new CouldntDeleteException(exception);
        }
    }

    public static void deleteById(CConnection connection, String tableName, int id) throws CouldntDeleteException {
        Preconditions.checkNotNull(connection, "IE00595: Connection argument can not be null");
        Preconditions.checkNotNull(tableName, "IE00596: Table name argument can not be null");
        Preconditions.checkArgument(id > 0, "IE00597: Id argument can not be less or equal zero");
        try {
            connection.executeUpdate(String.format("DELETE FROM %s WHERE id = %d", tableName, id), true);
        }
        catch (SQLException e2) {
            throw new CouldntDeleteException(e2);
        }
    }

    public static void deleteTable(CConnection connection, String table) throws SQLException {
        connection.executeUpdate(new StringBuilder(29 + String.valueOf(table).length()).append("DROP TABLE IF EXISTS ").append(table).append(" CASCADE").toString(), true);
    }

    public static void endTransaction(CConnection connection) throws SQLException {
        PostgreSQLHelpers.endTransaction(connection.getConnection());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getBackendPID(CConnection connection) {
        Preconditions.checkNotNull(connection, "IE02410: connection argument can not be null");
        String query = "SELECT pg_backend_pid() AS pid";
        try (ResultSet pidResult = connection.executeQuery("SELECT pg_backend_pid() AS pid", true);){
            if (!pidResult.next()) throw new IllegalStateException("IE02411: Could not retrieve backend PID from server");
            int n2 = pidResult.getInt("pid");
            return n2;
        }
        catch (SQLException exception) {
            CUtilityFunctions.logException(exception);
        }
        throw new IllegalStateException("IE02411: Could not retrieve backend PID from server");
    }

    public static String getDatabaseName(CConnection connection) {
        Preconditions.checkNotNull(connection, "IE00600: Connection argument can not be null");
        String url = connection.getURL();
        int index = url.lastIndexOf(47);
        if (index == -1) {
            return url;
        }
        return url.substring(index + 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Date getModificationDate(CConnection connection, String targetTable, int id) throws CouldntLoadDataException {
        Preconditions.checkNotNull(targetTable, "IE00601: Target table argument can not be null");
        Preconditions.checkNotNull(connection, "IE00602: Connection argument can not be null");
        Preconditions.checkArgument(id >= 0, "IE00605: Id argument can not less then zero");
        String query = new StringBuilder(53 + String.valueOf(targetTable).length()).append("SELECT modification_date FROM ").append(targetTable).append(" WHERE id = ").append(id).toString();
        try (ResultSet dateResult = connection.executeQuery(query, true);){
            if (!dateResult.next()) throw new IllegalStateException("IE00606: Could not retrieve modification date");
            Timestamp timestamp = dateResult.getTimestamp("modification_date");
            return timestamp;
        }
        catch (SQLException e2) {
            throw new CouldntLoadDataException(e2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IFilledList<INaviView> getViewsWithAddress(CConnection connection, String query, String columnName, ContainerFinder finder) throws CouldntLoadDataException {
        Preconditions.checkNotNull(finder, "IE00607: Finder argument can not be null");
        Preconditions.checkNotNull(columnName, "IE00608: Column name argument can not be null");
        Preconditions.checkNotNull(query, "IE00627: Query argument can not be null");
        Preconditions.checkNotNull(connection, "IE00628: Connection argument can not be null");
        FilledList<INaviView> views = new FilledList<INaviView>();
        try (ResultSet resultSet = connection.executeQuery(query, true);){
            while (resultSet.next()) {
                int containerId = resultSet.getInt(columnName);
                int viewId = resultSet.getInt("view_id");
                INaviView view = finder.findView(containerId, viewId);
                views.add(view);
            }
            FilledList<INaviView> filledList = views;
            return filledList;
        }
        catch (SQLException exception) {
            throw new CouldntLoadDataException(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasColumn(CConnection connection, String tableName, String columnName) {
        Preconditions.checkNotNull(columnName, "IE02035: Column name argument can not be null");
        Preconditions.checkNotNull(tableName, "IE02036: Table name argument can not be null");
        Preconditions.checkNotNull(connection, "IE02037: Connection argument can not be null");
        String query = String.format("SELECT attname FROM pg_attribute WHERE attrelid =  (SELECT oid FROM pg_class WHERE relname = '%s') AND attname = '%s';", tableName, columnName);
        try (ResultSet result = connection.executeQuery(query, true);){
            boolean bl2 = result.first();
            return bl2;
        }
        catch (SQLException e2) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasTable(CConnection connection, String tableName) throws CouldntLoadDataException {
        Preconditions.checkNotNull(tableName, "IE02038: Table name argument can not be null");
        Preconditions.checkNotNull(connection, "IE02039: Connection argument can not be null");
        String query = new StringBuilder(47 + String.valueOf(tableName).length()).append("SELECT relname FROM pg_class WHERE relname = '").append(tableName).append("'").toString();
        try (ResultSet result = connection.executeQuery(query, true);){
            boolean bl2 = result.first();
            return bl2;
        }
        catch (SQLException e2) {
            throw new CouldntLoadDataException(e2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getTableCount(CConnection connection, List<String> tableNames) throws CouldntLoadDataException {
        Preconditions.checkNotNull(connection, "Error: connection argument can not be null");
        StringBuilder builder = new StringBuilder("SELECT count(*) FROM pg_class WHERE relname in (");
        for (String tableName : tableNames) {
            builder.append(new StringBuilder(3 + String.valueOf(tableName).length()).append("'").append(tableName).append("',").toString());
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(")");
        try (ResultSet result = connection.executeQuery(builder.toString(), true);){
            if (!result.next()) throw new IllegalStateException("Error: Could not retrieve table count from server");
            int n2 = result.getInt("count");
            return n2;
        }
        catch (SQLException e2) {
            throw new CouldntLoadDataException(e2);
        }
    }

    public static IAddress loadAddress(ResultSet resultSet, String columnName) throws SQLException {
        Preconditions.checkNotNull(resultSet, "IE00500: Result set argument can not be null");
        Preconditions.checkNotNull(columnName, "IE00501: Column name argument can not be null");
        String addressString = PostgreSQLHelpers.readString(resultSet, columnName);
        return resultSet.wasNull() ? null : new CAddress(new BigInteger(addressString));
    }

    public static String readString(ResultSet resultSet, String columnName) throws SQLException {
        return resultSet.getString(columnName);
    }

    public static void rollback(CConnection connection) throws SQLException {
        Preconditions.checkNotNull(connection, "IE00629: Connection argument can not be null");
        if (connection.getConnection().getAutoCommit()) {
            throw new IllegalStateException("IE00712: Auto commit status must be false for manual rollback");
        }
        connection.getConnection().rollback();
        connection.getConnection().setAutoCommit(true);
    }

    public static void setDescription(CConnection connection, int id, String description, String table) throws CouldntSaveDataException {
        Preconditions.checkNotNull(table, "IE01226: Table argument can not be null");
        Preconditions.checkNotNull(description, "IE01484: Description argument can not be null");
        Preconditions.checkNotNull(connection, "IE01485: Connection argument can not be null");
        String query = new StringBuilder(67 + String.valueOf(table).length()).append("UPDATE ").append(table).append(" SET description = ?, modification_date = NOW() WHERE id = ?").toString();
        try (PreparedStatement statement = connection.getConnection().prepareStatement(query);){
            statement.setString(1, description);
            statement.setInt(2, id);
            statement.executeUpdate();
        }
        catch (SQLException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public static void setName(CConnection connection, int id, String name, String tableName) throws CouldntSaveDataException {
        Preconditions.checkNotNull(tableName, "IE02210: Table name argument can not be null");
        Preconditions.checkNotNull(name, "IE02243: Name argument can not be null");
        Preconditions.checkNotNull(connection, "IE02252: Connection argument can not be null");
        Preconditions.checkArgument(id >= 0, "Error: Id argument can not less then zero");
        String query = new StringBuilder(60 + String.valueOf(tableName).length()).append("UPDATE ").append(tableName).append(" SET name = ?, modification_date = NOW() WHERE id = ?").toString();
        try (PreparedStatement statement = connection.getConnection().prepareStatement(query);){
            statement.setString(1, name);
            statement.setInt(2, id);
            statement.executeUpdate();
        }
        catch (SQLException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public static void updateModificationDate(CConnection connection, String tableName, int id) throws CouldntSaveDataException {
        Preconditions.checkNotNull(tableName, "IE01486: Table name argument can not be null");
        Preconditions.checkNotNull(connection, "IE01858: Connection argument can not be null");
        String query = new StringBuilder(50 + String.valueOf(tableName).length()).append("UPDATE ").append(tableName).append(" SET modification_date = NOW() WHERE id = ?").toString();
        try (PreparedStatement statement = connection.getConnection().prepareStatement(query);){
            statement.setInt(1, id);
            statement.executeUpdate();
        }
        catch (SQLException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public static String viewTypeToString(ViewType type) {
        return type == ViewType.Native ? "'native'" : "'non-native'";
    }
}

