/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.PostgreSQLHelpers;
import com.google.security.zynamics.binnavi.Gui.Users.CUserManager;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class PostgreSQLDataImporter {
    private PostgreSQLDataImporter() {
    }

    private static String getArchitecture(CConnection connection, int rawModuleId) throws SQLException {
        Preconditions.checkNotNull(connection, "IE00207: provider argument can not be null");
        String query = new StringBuilder(55).append("SELECT architecture FROM modules WHERE id = ").append(rawModuleId).toString();
        Throwable throwable = null;
        try (ResultSet resultSet = connection.executeQuery(query, true);){
            if (resultSet.next()) {
                String string2 = PostgreSQLHelpers.readString(resultSet, "architecture");
                return string2;
            }
            try {
                throw new SQLException("Error: Could not determine architecture of new module");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static void connectExpressionTrees(CConnection connection, int moduleId, int rawModuleId) throws SQLException {
        Preconditions.checkNotNull(connection, "IE00208: provider argument can not be null");
        String string2 = String.valueOf("INSERT INTO bn_expression_tree_mapping (SELECT ");
        String query = new StringBuilder(95 + String.valueOf(string2).length()).append(string2).append(moduleId).append(", expression_tree_id, expression_node_id ").append(" FROM ex_").append(rawModuleId).append("_expression_tree_nodes)").toString();
        connection.executeUpdate(query, true);
    }

    public static void importAddressReferences(CConnection connection, int rawModuleId, int moduleId) throws SQLException {
        Preconditions.checkNotNull(connection, "IE00266: connection argument can not be null");
        Preconditions.checkArgument(rawModuleId >= 0, "Error: raw module id can only be a positive number.");
        Preconditions.checkArgument(moduleId >= 0, "Error: module if can only be a positive number");
        String string2 = String.valueOf("INSERT INTO bn_address_references (module_id, address, position, expression_id, type, target)  SELECT ");
        String query = new StringBuilder(223 + String.valueOf(string2).length()).append(string2).append(moduleId).append(", address, position, expression_node_id, ").append(" (ENUM_RANGE(NULL::address_reference_type))[type + 1], destination  ").append(" FROM ex_").append(rawModuleId).append("_address_references  WHERE position IS NOT NULL AND expression_node_id IS NOT NULL;").toString();
        connection.executeUpdate(query, true);
    }

    public static void importBaseTypes(CConnection connection, int rawModuleId, int moduleId) throws SQLException {
        String string2 = String.valueOf("INSERT INTO bn_base_types SELECT ");
        String string3 = String.valueOf(String.format("ex_%d_base_types", rawModuleId));
        String query = new StringBuilder(50 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(moduleId).append(", id, name, size, pointer, signed ").append("FROM ").append(string3).toString();
        connection.executeUpdate(query, true);
        String updateSequence = String.format("SELECT setval('bn_base_types_id_seq', COALESCE((SELECT MAX(id) + 1 FROM %s), 1), false) from %s", "bn_base_types", "bn_base_types");
        connection.executeQuery(updateSequence, true);
    }

    public static void importExpressionSubstitutions(CConnection connection, int rawModuleId, int moduleId) throws SQLException {
        Preconditions.checkNotNull(connection, "IE00433: connection argument can not be null");
        String string2 = String.valueOf("INSERT INTO bn_expression_substitutions (module_id, address, position, expression_id, replacement)  SELECT ");
        String query = new StringBuilder(110 + String.valueOf(string2).length()).append(string2).append(moduleId).append(" , address, position, expression_node_id, replacement ").append(" FROM ex_").append(rawModuleId).append("_expression_substitutions").toString();
        connection.executeUpdate(query, true);
    }

    public static void importExpressionTree(CConnection connection, int moduleId, int rawModuleId) throws SQLException {
        Preconditions.checkNotNull(connection, "IE00434: connection argument can not be null");
        String string2 = String.valueOf("INSERT INTO bn_expression_tree(module_id, id, type, symbol, immediate, position, parent_id) SELECT ");
        String query = new StringBuilder(99 + String.valueOf(string2).length()).append(string2).append(moduleId).append(", id, type, symbol, immediate, position, parent_id ").append(" FROM ex_").append(rawModuleId).append("_expression_nodes").toString();
        connection.executeUpdate(query, true);
    }

    public static void importExpressionTrees(CConnection connection, int moduleId, int rawModuleId) throws SQLException {
        String string2 = String.valueOf("INSERT INTO bn_expression_tree_ids SELECT ");
        String query = new StringBuilder(53 + String.valueOf(string2).length()).append(string2).append(moduleId).append(", id ").append(" FROM ex_").append(rawModuleId).append("_expression_trees").toString();
        connection.executeUpdate(query, true);
    }

    public static void importExpressionTypes(CConnection connection, int rawModuleId, int moduleId) throws SQLException {
        String string2 = String.valueOf("INSERT INTO bn_expression_types SELECT ");
        String string3 = String.valueOf(String.format("ex_%d_expression_types", rawModuleId));
        String query = new StringBuilder(69 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(moduleId).append(", address, \"position\", \"offset\", expression_id, type").append(" FROM ").append(string3).toString();
        connection.executeUpdate(query, true);
    }

    public static void importFunctions(CConnection connection, int rawModuleId, int moduleId) throws SQLException {
        Preconditions.checkNotNull(connection, "IE00435: connection argument can not be null");
        Preconditions.checkArgument(rawModuleId >= 0, "Error: raw module id can only be a positive number.");
        Preconditions.checkArgument(moduleId >= 0, "Error: module if can only be a positive number");
        String string2 = String.valueOf("INSERT INTO bn_functions (module_id, address, name, original_name, type, description, parent_module_name, parent_module_id, parent_module_function, comment_id)  SELECT ");
        String query = new StringBuilder(153 + String.valueOf(string2).length()).append(string2).append(moduleId).append(", address, demangled_name, name, (ENUM_RANGE(NULL::function_type))[type + 1], ").append("'', module_name, null, null, null ").append(" FROM ex_").append(rawModuleId).append("_functions").toString();
        connection.executeUpdate(query, true);
    }

    public static void importInstructions(SQLProvider provider, int rawModuleId, int moduleId) throws SQLException, CouldntLoadDataException {
        String architecture = PostgreSQLDataImporter.getArchitecture(provider.getConnection(), rawModuleId);
        int userId = CUserManager.get(provider).getCurrentActiveUser().getUserId();
        String string2 = String.valueOf("WITH comments_to_id(id, address, comment) AS  (    SELECT nextval('bn_comments_id_seq'::regclass), address, comment    FROM ex_");
        String string3 = String.valueOf("bn_comments");
        String string4 = String.valueOf("bn_instructions");
        String query = new StringBuilder(439 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(architecture).length()).append(string2).append(rawModuleId).append("_address_comments ").append(" ), comments_table AS ( ").append("   INSERT INTO ").append(string3).append(" (id, parent_id, user_id, comment_text) ").append("   SELECT id, null, ").append(userId).append(", comment ").append("   FROM comments_to_id ").append(" ) ").append("   INSERT INTO ").append(string4).append(" (module_id, address, mnemonic, data, native, architecture, comment_id) ").append("   SELECT ").append(moduleId).append(", isn.address, mnemonic, data, true, '").append(architecture).append("', com.id ").append("   FROM ex_").append(rawModuleId).append("_instructions AS isn ").append("   LEFT JOIN comments_to_id AS com ON com.address = isn.address; ").toString();
        provider.getConnection().executeUpdate(query, true);
    }

    public static void importOperands(CConnection connection, int rawModuleId, int moduleId) throws SQLException {
        String string2 = String.valueOf("INSERT INTO bn_operands SELECT ");
        String query = new StringBuilder(80 + String.valueOf(string2).length()).append(string2).append(moduleId).append(", address, expression_tree_id, position ").append(" FROM ex_").append(rawModuleId).append("_operands").toString();
        connection.executeUpdate(query, true);
    }

    public static void importTypes(CConnection connection, int rawModuleId, int moduleId) throws SQLException {
        String string2 = String.valueOf("INSERT INTO bn_types SELECT ");
        String string3 = String.valueOf(String.format("ex_%d_types", rawModuleId));
        String query = new StringBuilder(89 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(moduleId).append(", id, name, base_type, parent_id, position, argument, number_of_elements").append(" FROM ").append(string3).toString();
        connection.executeUpdate(query, true);
        String updateSequence = String.format("SELECT setval('bn_types_id_seq', COALESCE((SELECT MAX(id) + 1 FROM %s), 1), false) from %s", "bn_types", "bn_types");
        connection.executeQuery(updateSequence, true);
    }
}

