/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.parsers;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.containers.TypesNotificationContainer;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.interfaces.PostgreSQLNotificationParser;
import com.google.security.zynamics.binnavi.Database.cache.InstructionCache;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviOperandTree;
import com.google.security.zynamics.binnavi.disassembly.INaviOperandTreeNode;
import com.google.security.zynamics.binnavi.disassembly.types.RawTypeSubstitution;
import com.google.security.zynamics.binnavi.disassembly.types.TypeManager;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.OperandOrderIterator;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.postgresql.PGNotification;

public class PostgreSQLTypesNotificationParser
implements PostgreSQLNotificationParser<TypesNotificationContainer> {
    private static final String EXPRESSION_TYPES_NOTIFICATION_REGEX = "^(bn_expression_types)\\s(INSERT|UPDATE|DELETE)\\s(\\d*)\\s(\\d*)\\s(\\d*)\\s(\\d*)";
    private static final Pattern EXPRESSION_TYPES_NOTIFICATION_PATTERN = Pattern.compile("^(bn_expression_types)\\s(INSERT|UPDATE|DELETE)\\s(\\d*)\\s(\\d*)\\s(\\d*)\\s(\\d*)");
    private static final String TYPES_NOTIFICATION_REGEX = "^(bn_types)\\s(INSERT|UPDATE|DELETE)\\s(\\d*)\\s(\\d*)";
    private static final Pattern TYPES_NOTIFICATION_PATTERN = Pattern.compile("^(bn_types)\\s(INSERT|UPDATE|DELETE)\\s(\\d*)\\s(\\d*)");
    private static final String BASE_TYPE_NOTIFICATION_REGEX = "^(bn_base_types)\\s(INSERT|UPDATE|DELETE)\\s(\\d*)\\s(\\d*)";
    private static final Pattern BASE_TYPES_NOTIFICATION_PATTERN = Pattern.compile("^(bn_base_types)\\s(INSERT|UPDATE|DELETE)\\s(\\d*)\\s(\\d*)");

    private INaviOperandTreeNode findOperandTreeNode(SQLProvider provider, int moduleId, CAddress address, int position, int operandNodeId) {
        INaviInstruction instruction = InstructionCache.get(provider).getInstructionByAddress(address, moduleId);
        if (instruction != null) {
            INaviOperandTree operandTree = instruction.getOperands().get(position);
            INaviOperandTreeNode root = operandTree.getRootNode();
            OperandOrderIterator iterator = new OperandOrderIterator(root);
            while (iterator.next()) {
                INaviOperandTreeNode currentNode = (INaviOperandTreeNode)iterator.current();
                if (currentNode.getId() != operandNodeId) continue;
                return currentNode;
            }
        }
        return null;
    }

    private void informBaseTypesNotification(TypesNotificationContainer container, SQLProvider provider) throws CouldntLoadDataException {
        TypeManager typeManager = provider.findModule(container.getModuleId()).getTypeManager();
        if (container.getDatabaseOperation().equals("INSERT")) {
            typeManager.loadAndInitializeBaseType(container.getBaseTypeId().get());
        } else if (container.getDatabaseOperation().equals("UPDATE")) {
            typeManager.loadAndUpdateBaseType(container.getBaseTypeId().get());
        } else if (container.getDatabaseOperation().equals("DELETE")) {
            typeManager.removeBaseTypeInstance(container.getBaseTypeId().get());
        }
    }

    private void informExpressionTypesNotification(TypesNotificationContainer container, SQLProvider provider) throws CouldntLoadDataException {
        INaviModule module = provider.findModule(container.getModuleId());
        TypeManager typeManager = module.getTypeManager();
        INaviOperandTreeNode node = this.findOperandTreeNode(provider, container.getModuleId(), new CAddress(container.getAddress().get()), container.position().get(), container.expressionId().get());
        if (node == null) {
            return;
        }
        if (container.getDatabaseOperation().equals("INSERT")) {
            RawTypeSubstitution rawSubstitution = provider.loadTypeSubstitution(module, container.getAddress().get(), container.position().get(), container.expressionId().get());
            typeManager.initializeTypeSubstitution(node, rawSubstitution);
        } else if (container.getDatabaseOperation().equals("UPDATE")) {
            RawTypeSubstitution rawSubstitution = provider.loadTypeSubstitution(module, container.getAddress().get(), container.position().get(), container.expressionId().get());
            typeManager.updateTypeSubstitution(node, rawSubstitution.getBaseTypeId(), rawSubstitution.getPath(), rawSubstitution.getOffset());
        } else if (container.getDatabaseOperation().equals("DELETE")) {
            typeManager.removeTypeSubstitutionInstance(node.getTypeSubstitution());
        } else {
            String string2 = container.getDatabaseOperation();
            throw new IllegalStateException(new StringBuilder(58 + String.valueOf(string2).length()).append("Error: the database operation ").append(string2).append(" is currently not supported.").toString());
        }
    }

    private void informTypesNotification(TypesNotificationContainer container, SQLProvider provider) throws CouldntLoadDataException {
        TypeManager typeManager = provider.findModule(container.getModuleId()).getTypeManager();
        if (container.getDatabaseOperation().equals("INSERT")) {
            typeManager.loadAndInitializeTypeMember(container.getTypeId().get());
        } else if (container.getDatabaseOperation().equals("UPDATE")) {
            typeManager.loadAndUpdateTypeMember(container.getTypeId().get());
        } else if (container.getDatabaseOperation().equals("DELETE")) {
            typeManager.removeMemberInstance(container.getTypeId().get());
        } else {
            String string2 = container.getDatabaseOperation();
            throw new IllegalStateException(new StringBuilder(58 + String.valueOf(string2).length()).append("Error: the database operation ").append(string2).append(" is currently not supported.").toString());
        }
    }

    private TypesNotificationContainer parseBaseTypesNotification(PGNotification notification) {
        Matcher matcher = BASE_TYPES_NOTIFICATION_PATTERN.matcher(notification.getParameter());
        if (!matcher.find()) {
            String string2 = String.valueOf("Error: compiled pattern: ^(bn_base_types)\\s(INSERT|UPDATE|DELETE)\\s(\\d*)\\s(\\d*) did not match notification: ");
            String string3 = String.valueOf(notification.getParameter());
            throw new IllegalStateException(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        }
        String databaseOperation = matcher.group(2);
        Integer moduleId = Integer.parseInt(matcher.group(3));
        Integer baseTypeId = Integer.parseInt(matcher.group(4));
        return new TypesNotificationContainer(databaseOperation, moduleId, Optional.of(baseTypeId), Optional.absent(), Optional.absent(), Optional.absent(), Optional.absent());
    }

    private TypesNotificationContainer parseExpressionTypesNotification(PGNotification notification) {
        Matcher matcher = EXPRESSION_TYPES_NOTIFICATION_PATTERN.matcher(notification.getParameter());
        if (!matcher.find()) {
            String string2 = String.valueOf(EXPRESSION_TYPES_NOTIFICATION_PATTERN.toString());
            String string3 = String.valueOf(notification.getParameter());
            throw new IllegalStateException(new StringBuilder(54 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Error: compliled pattern ").append(string2).append(" did not match notification: ").append(string3).toString());
        }
        String databaseOperation = matcher.group(2);
        Integer moduleId = Integer.parseInt(matcher.group(3));
        BigInteger address = new BigInteger(matcher.group(4));
        Integer position = Integer.parseInt(matcher.group(5));
        Integer expressionId = Integer.parseInt(matcher.group(6));
        return new TypesNotificationContainer(databaseOperation, moduleId, Optional.absent(), Optional.absent(), Optional.of(address), Optional.of(position), Optional.of(expressionId));
    }

    private TypesNotificationContainer parseTypesNotification(PGNotification notification) {
        Matcher matcher = TYPES_NOTIFICATION_PATTERN.matcher(notification.getParameter());
        if (!matcher.find()) {
            String string2 = String.valueOf("Error: compiled pattern: ^(bn_types)\\s(INSERT|UPDATE|DELETE)\\s(\\d*)\\s(\\d*) did not match notification: ");
            String string3 = String.valueOf(notification.getParameter());
            throw new IllegalStateException(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        }
        String databaseOperation = matcher.group(2);
        Integer moduleId = Integer.parseInt(matcher.group(3));
        Integer typeMemberId = Integer.parseInt(matcher.group(4));
        return new TypesNotificationContainer(databaseOperation, moduleId, Optional.absent(), Optional.of(typeMemberId), Optional.absent(), Optional.absent(), Optional.absent());
    }

    @Override
    public void inform(Collection<TypesNotificationContainer> containers, SQLProvider provider) throws CouldntLoadDataException {
        Preconditions.checkNotNull(containers, "Error: containers argument can not be null");
        Preconditions.checkNotNull(provider, "Error: provider argument can not be null");
        for (TypesNotificationContainer container : containers) {
            if (!provider.findModule(container.getModuleId()).isLoaded()) continue;
            if (container.getAddress().isPresent()) {
                this.informExpressionTypesNotification(container, provider);
                continue;
            }
            if (container.getTypeId().isPresent()) {
                this.informTypesNotification(container, provider);
                continue;
            }
            if (container.getBaseTypeId().isPresent()) {
                this.informBaseTypesNotification(container, provider);
                continue;
            }
            throw new IllegalStateException("Error: the parsed notification does not contain a distinct element.");
        }
    }

    @Override
    public Collection<TypesNotificationContainer> parse(Collection<PGNotification> notifications, SQLProvider provider) {
        Preconditions.checkNotNull(notifications, "Error: notifications argument can not be null");
        Preconditions.checkNotNull(provider, "Error: provider argument can not be null");
        ArrayList<TypesNotificationContainer> containers = Lists.newArrayList();
        for (PGNotification notification : notifications) {
            if (notification.getParameter().startsWith("bn_expression_types")) {
                containers.add(this.parseExpressionTypesNotification(notification));
                continue;
            }
            if (notification.getParameter().startsWith("bn_types")) {
                containers.add(this.parseTypesNotification(notification));
                continue;
            }
            if (notification.getParameter().startsWith("bn_base_types")) {
                containers.add(this.parseBaseTypesNotification(notification));
                continue;
            }
            String string2 = String.valueOf(notification.getParameter());
            throw new IllegalStateException(new StringBuilder(107 + String.valueOf(string2).length()).append("Error: Table name supplied in notification ").append(string2).append(" does not match tables where type notifications are expected on.").toString());
        }
        return containers;
    }
}

