/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.parsers;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.containers.TypeInstancesNotificationContainer;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.interfaces.PostgreSQLNotificationParser;
import com.google.security.zynamics.binnavi.Database.cache.InstructionCache;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviOperandTree;
import com.google.security.zynamics.binnavi.disassembly.INaviOperandTreeNode;
import com.google.security.zynamics.binnavi.disassembly.types.TypeInstanceContainer;
import com.google.security.zynamics.binnavi.disassembly.types.TypeInstanceReference;
import com.google.security.zynamics.zylib.disassembly.OperandOrderIterator;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.postgresql.PGNotification;

public class PostgreSQLTypeInstancesNotificationParser
implements PostgreSQLNotificationParser<TypeInstancesNotificationContainer> {
    private static final String typeInstanceNotification = "(^bn_type_instances)\\s(INSERT|UPDATE|DELETE)\\s(\\d*)\\s(\\d*)$";
    private static final Pattern typeInstanceNotificationPattern = Pattern.compile("(^bn_type_instances)\\s(INSERT|UPDATE|DELETE)\\s(\\d*)\\s(\\d*)$");
    private static final String expressionTypeInstanceNotification = "(^bn_expression_type_instances)\\s(INSERT|UPDATE|DELETE)\\s(\\d*)\\s(\\d*)\\s(\\d*)\\s(\\d*)\\s(\\d*)$";
    private static final Pattern expressionTypeInstanceNotificationPattern = Pattern.compile("(^bn_expression_type_instances)\\s(INSERT|UPDATE|DELETE)\\s(\\d*)\\s(\\d*)\\s(\\d*)\\s(\\d*)\\s(\\d*)$");

    private TypeInstancesNotificationContainer parseTypeInstanceNotification(PGNotification notification) {
        Matcher matcher = typeInstanceNotificationPattern.matcher(notification.getParameter());
        if (!matcher.find()) {
            String string2 = String.valueOf(typeInstanceNotificationPattern.toString());
            String string3 = String.valueOf(notification.getParameter());
            throw new IllegalStateException(new StringBuilder(54 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Error: compiled pattern: ").append(string2).append(" did not match notification: ").append(string3).toString());
        }
        String databaseOperation = matcher.group(2);
        Integer moduleId = Integer.parseInt(matcher.group(3));
        Integer typeInstanceId = Integer.parseInt(matcher.group(4));
        return new TypeInstancesNotificationContainer(databaseOperation, moduleId, typeInstanceId, Optional.absent(), Optional.absent(), Optional.absent());
    }

    private TypeInstancesNotificationContainer parseExpressionTypeInstanceNotification(PGNotification notification) {
        Matcher matcher = expressionTypeInstanceNotificationPattern.matcher(notification.getParameter());
        if (!matcher.find()) {
            String string2 = String.valueOf(expressionTypeInstanceNotificationPattern.toString());
            String string3 = String.valueOf(notification.getParameter());
            throw new IllegalStateException(new StringBuilder(54 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Error: compiled pattern: ").append(string2).append(" did not match notification: ").append(string3).toString());
        }
        String databaseOperation = matcher.group(2);
        Integer moduleId = Integer.parseInt(matcher.group(3));
        BigInteger address = new BigInteger(matcher.group(4));
        Integer position = Integer.parseInt(matcher.group(5));
        Integer expressionId = Integer.parseInt(matcher.group(6));
        Integer typeInstanceId = Integer.parseInt(matcher.group(7));
        return new TypeInstancesNotificationContainer(databaseOperation, moduleId, typeInstanceId, Optional.of(address), Optional.of(position), Optional.of(expressionId));
    }

    @Override
    public Collection<TypeInstancesNotificationContainer> parse(Collection<PGNotification> notifications, SQLProvider provider) {
        Preconditions.checkNotNull(notifications, "Error: notifications argument can not be null");
        Preconditions.checkNotNull(provider, "Error: provider argument can not be null");
        ArrayList<TypeInstancesNotificationContainer> containers = Lists.newArrayList();
        for (PGNotification notification : notifications) {
            if (notification.getParameter().startsWith("bn_type_instances")) {
                containers.add(this.parseTypeInstanceNotification(notification));
                continue;
            }
            if (notification.getParameter().startsWith("bn_expression_type_instances")) {
                containers.add(this.parseExpressionTypeInstanceNotification(notification));
                continue;
            }
            String string2 = String.valueOf(notification.getParameter());
            throw new IllegalStateException(new StringBuilder(116 + String.valueOf(string2).length()).append("Error: Table name supplied in notification ").append(string2).append(" does not match tables where type instance notifications are accepted on.").toString());
        }
        return containers;
    }

    @Override
    public void inform(Collection<TypeInstancesNotificationContainer> containers, SQLProvider provider) throws CouldntLoadDataException {
        for (TypeInstancesNotificationContainer container : containers) {
            if (!provider.findModule(container.getModuleId()).isLoaded()) continue;
            if (container.getAddress().isPresent()) {
                this.informExpressionTypeInstanceNotification(container, provider);
                continue;
            }
            this.informTypeInstanceNotification(container, provider);
        }
    }

    private void informTypeInstanceNotification(TypeInstancesNotificationContainer container, SQLProvider provider) throws CouldntLoadDataException {
        TypeInstanceContainer typeContainer = provider.findModule(container.getModuleId()).getContent().getTypeInstanceContainer();
        if (container.getDatabaseOperation().equals("INSERT")) {
            typeContainer.loadInstance(container.getTypeInstanceId());
        } else if (container.getDatabaseOperation().equals("UPDATE")) {
            typeContainer.reloadInstance(container.getTypeInstanceId());
        } else if (container.getDatabaseOperation().equals("DELETE")) {
            typeContainer.deleteInstance(container.getTypeInstanceId());
        } else {
            String string2 = container.getDatabaseOperation();
            throw new IllegalStateException(new StringBuilder(58 + String.valueOf(string2).length()).append("Error: the database operation ").append(string2).append(" is currently not supported.").toString());
        }
    }

    private void informExpressionTypeInstanceNotification(TypeInstancesNotificationContainer container, SQLProvider provider) throws CouldntLoadDataException {
        TypeInstanceContainer typeContainer = provider.findModule(container.getModuleId()).getContent().getTypeInstanceContainer();
        if (container.getDatabaseOperation().equals("INSERT")) {
            TypeInstanceReference reference = typeContainer.loadInstanceReference(container.getTypeInstanceId(), container.getAddress().get(), container.getPosition().get(), container.getExpressionId().get());
            INaviInstruction instruction = InstructionCache.get(provider).getInstructionByAddress(reference.getAddress(), reference.getTypeInstance().getModule().getConfiguration().getId());
            if (instruction != null) {
                INaviOperandTree operandTree = instruction.getOperands().get(reference.getPosition());
                INaviOperandTreeNode root = operandTree.getRootNode();
                OperandOrderIterator iterator = new OperandOrderIterator(root);
                while (iterator.next()) {
                    INaviOperandTreeNode currentNode = (INaviOperandTreeNode)iterator.current();
                    if (currentNode.getId() != container.getExpressionId().get().intValue()) continue;
                    typeContainer.initializeTypeInstanceReference(reference.getAddress(), reference.getPosition(), container.getTypeInstanceId(), currentNode);
                    break;
                }
            }
        } else if (!container.getDatabaseOperation().equals("UPDATE")) {
            if (container.getDatabaseOperation().equals("DELETE")) {
                typeContainer.deleteReference(container.getTypeInstanceId(), container.getAddress().get(), container.getPosition().get(), container.getExpressionId().get());
            } else {
                String string2 = container.getDatabaseOperation();
                throw new IllegalStateException(new StringBuilder(58 + String.valueOf(string2).length()).append("Error: the database operation ").append(string2).append(" is currently not supported.").toString());
            }
        }
    }
}

