/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.parsers;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.containers.FunctionNotificationContainer;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.interfaces.PostgreSQLNotificationParser;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.functions.FunctionManager;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.postgresql.PGNotification;

public class PostgreSQLFunctionNotificationParser
implements PostgreSQLNotificationParser<FunctionNotificationContainer> {
    private static final String functionNotificationPattern = "^(bn_functions)\\s(INSERT|UPDATE|DELETE)\\s(\\d*)\\s(\\d*)$";

    private void informFunctionNotification(FunctionNotificationContainer container, SQLProvider provider) throws CouldntLoadDataException {
        INaviFunction databaseFunction;
        INaviFunction function;
        if (container.getDatabaseOperation().equals("INSERT")) {
            return;
        }
        if (container.getDatabaseOperation().equals("UPDATE")) {
            IAddress functionAddress = container.getFunctionAddress();
            Integer moduleId = container.getModuleId();
            INaviModule module = provider.findModule(moduleId);
            function = FunctionManager.get(provider).getFunction(functionAddress, moduleId);
            databaseFunction = provider.loadFunction(module, functionAddress);
            function.setDescriptionInternal(databaseFunction.getDescription());
            function.setNameInternal(databaseFunction.getName());
            if (databaseFunction.isForwarded()) {
                function.setForwardedFunctionInternal(FunctionManager.get(provider).getFunction(databaseFunction.getForwardedFunctionAddress(), databaseFunction.getForwardedFunctionModuleId()));
            } else {
                function.removeForwardedFunctionInternal();
            }
        } else {
            if (container.getDatabaseOperation().equals("DELETE")) {
                return;
            }
            String string2 = container.getDatabaseOperation();
            throw new IllegalStateException(new StringBuilder(46 + String.valueOf(string2).length()).append("IE02741: database operation: ").append(string2).append(" is not supported").toString());
        }
        function.setStackFrame(databaseFunction.getStackFrame());
        function.setPrototype(databaseFunction.getPrototype());
    }

    private FunctionNotificationContainer parseFunctionNotification(PGNotification notification, SQLProvider provider) {
        Pattern pattern = Pattern.compile(functionNotificationPattern);
        Matcher matcher = pattern.matcher(notification.getParameter());
        if (!matcher.find()) {
            String string2 = String.valueOf(pattern.toString());
            String string3 = String.valueOf(notification.getParameter());
            throw new IllegalStateException(new StringBuilder(56 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("IE02739: compiled pattern: ").append(string2).append(" did not match notification: ").append(string3).toString());
        }
        String databaseOperation = matcher.group(2);
        Integer moduleId = Integer.parseInt(matcher.group(3));
        CAddress functionAddress = new CAddress(new BigInteger(matcher.group(4)));
        INaviModule module = provider.findModule(moduleId);
        return new FunctionNotificationContainer(moduleId, module, functionAddress, databaseOperation);
    }

    @Override
    public void inform(Collection<FunctionNotificationContainer> parsedFunctionNotifications, SQLProvider provider) throws CouldntLoadDataException {
        Preconditions.checkNotNull(parsedFunctionNotifications, "Error: parsedFunctionNotifications argument can not be null");
        Preconditions.checkNotNull(provider, "IE02740: provider argument can not be null");
        for (FunctionNotificationContainer container : parsedFunctionNotifications) {
            this.informFunctionNotification(container, provider);
        }
    }

    @Override
    public Collection<FunctionNotificationContainer> parse(Collection<PGNotification> notifications, SQLProvider provider) {
        Preconditions.checkNotNull(notifications, "IE02629: notifications argument can not be null");
        Preconditions.checkNotNull(provider, "IE02630: provider argument can not be null");
        ArrayList<FunctionNotificationContainer> containers = new ArrayList<FunctionNotificationContainer>();
        for (PGNotification notification : notifications) {
            if (notification.getParameter().startsWith("bn_functions")) {
                containers.add(this.parseFunctionNotification(notification, provider));
                continue;
            }
            String string2 = String.valueOf(notification.getParameter());
            throw new IllegalStateException(new StringBuilder(114 + String.valueOf(string2).length()).append("IE02738: Table name supplied in notification: ").append(string2).append(" does not match tables where function notifications are accepted on.").toString());
        }
        return containers;
    }
}

