/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.parsers;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.containers.CodeNodeCommentNotificationContainer;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.containers.CommentNotificationContainer;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.containers.EdgeCommentNotificationContainer;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.containers.FunctionCommentNotificationContainer;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.containers.FunctionNodeCommentNotificationContainer;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.containers.GroupNodeCommentNotificationContainer;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.containers.InstructionCommentNotificationContainer;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.containers.TextNodeCommentNotificationContainer;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.containers.TypeInstanceCommentNotificationContainer;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.interfaces.CommentNotification;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.interfaces.PostgreSQLNotificationParser;
import com.google.security.zynamics.binnavi.Database.cache.EdgeCache;
import com.google.security.zynamics.binnavi.Database.cache.InstructionCache;
import com.google.security.zynamics.binnavi.Database.cache.NodeCache;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.CComment;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.disassembly.CommentManager;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviEdge;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviGroupNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviTextNode;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.types.TypeInstance;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.postgresql.PGNotification;

public class PostgreSQLCommentNotificationParser
implements PostgreSQLNotificationParser<CommentNotification> {
    private static final String COMMENTS_NOTIFICATION = "^(bn_comments)\\s(UPDATE|DELETE)\\s(\\d*)\\s((null)|(\\d*))\\s(\\d*)($|\\s(.*)$)";
    private static final Pattern COMMENTS_PATTERN = Pattern.compile("^(bn_comments)\\s(UPDATE|DELETE)\\s(\\d*)\\s((null)|(\\d*))\\s(\\d*)($|\\s(.*)$)", 40);
    private static final String TYPE_INSTANCE_NOTIFICATION = "^(bn_type_instances)\\s(UPDATE)\\s(\\d*)\\s(\\d*)\\s((null)$|(\\d*)$)";
    private static final Pattern TYPE_INSTANCE_PATTERN;
    private static final String EDGE_LOCAL_NOTIFICATION = "^(bn_edges)\\s(UPDATE)\\s(\\d*)\\s((\\d*)|(null))$";
    private static final Pattern EDGE_LOCAL_PATTERN;
    private static final String EDGE_GLOBAL_NOTIFICATION = "^(bn_global_edge_comments)\\s(INSERT|DELETE|UPDATE)\\s(\\d*)\\s(\\d*)\\s(\\d*)\\s(\\d*)($|\\s(\\d*)$)";
    private static final Pattern EDGE_GLOBAL_PATTERN;
    private static final String NODE_LOCAL_NOTIFICATION = "^(bn_code_nodes)\\s(UPDATE)\\s(\\d*)\\s(\\d*)\\s(\\d*)\\s((null)$|(\\d*)$)";
    private static final Pattern NODE_LOCAL_PATTERN;
    private static final String NODE_GLOBAL_NOTIFICATION = "^(bn_global_node_comments)\\s(INSERT|DELETE|UPDATE)\\s(\\d*)\\s(\\d*)($|\\s(\\d*)$)";
    private static final Pattern NODE_GLOBAL_PATTERN;
    private static final String INSTRUCTION_LOCAL_NOTIFICATION = "^(bn_codenode_instructions)\\s(UPDATE)\\s(\\d*)\\s(\\d*)\\s(\\d*)\\s(\\d*)\\s((null)$|(\\d*)$)";
    private static final Pattern INSTRUCTION_LOCAL_PATTERN;
    private static final String INSTRUCTION_GLOBAL_NOTIFICATION = "^(bn_instructions)\\s(UPDATE)\\s(\\d*)\\s(\\d*)\\s((null)$|(\\d*)$)";
    private static final Pattern INSTRUCTION_GLOBAL_PATTERN;
    private static final String FUNCTION_NODE_NOTIFICATION = "^(bn_function_nodes)\\s(UPDATE)\\s(\\d*)\\s(\\d*)\\s(\\d*)\\s((null)$|(\\d*)$)";
    private static final Pattern FUNCTION_NODE_PATTERN;
    private static final String FUNCTION_NOTIFICATION = "^(bn_functions)\\s(UPDATE)\\s(\\d*)\\s(\\d*)\\s((null)$|(\\d*)$)";
    private static final Pattern FUNCTION_PATTERN;
    private static final String GROUP_NODE_NOTIFICATION = "^(bn_group_nodes)\\s(UPDATE)\\s(\\d*)\\s((\\d*)|(null))$";
    private static final Pattern GROUP_NODE_PATTERN;
    private static final String TEXT_NODE_NOTIFICATION = "^(bn_text_nodes)\\s(UPDATE)\\s(\\d*)\\s((\\d*)|(null))$";
    private static final Pattern TEXT_NODE_PATTERN;
    private static final int FLAGS = 40;

    static CommentNotification processCommentNotification(PGNotification notification, SQLProvider provider) {
        Matcher matcher = COMMENTS_PATTERN.matcher(notification.getParameter());
        if (!matcher.find()) {
            return null;
        }
        Integer commentId = null;
        try {
            commentId = Integer.parseInt(matcher.group(3));
        }
        catch (NumberFormatException exception) {
            throw new IllegalStateException(exception);
        }
        IComment comment = CommentManager.get(provider).getCommentById(commentId);
        if (comment == null) {
            return null;
        }
        String databaseOperation = matcher.group(2);
        Integer parentId = null;
        try {
            parentId = matcher.group(4).equalsIgnoreCase("null") ? null : Integer.valueOf(Integer.parseInt(matcher.group(4)));
        }
        catch (NumberFormatException exception) {
            throw new IllegalStateException(exception);
        }
        if (databaseOperation.equals("DELETE") && (parentId == null && comment.getParent() != null || parentId != null && comment.getParent() != null && !parentId.equals(comment.getParent().getId()))) {
            Integer localCommentParentId = parentId;
            Integer notificationCommentParentId = comment.getParent() != null ? comment.getParent().getId() : null;
            String string2 = String.valueOf(localCommentParentId);
            String string3 = String.valueOf(notificationCommentParentId);
            throw new IllegalStateException(new StringBuilder(117 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("IE02521: The parent comment of the localy stored comment: ").append(string2).append(" is not equal to the ").append("notification comments parent comment: ").append(string3).toString());
        }
        String commentContent = matcher.group(9);
        if (!commentContent.equals(comment.getComment()) && databaseOperation.equals("DELETE")) {
            String notificationCommentParentId = comment.getComment();
            throw new IllegalStateException(new StringBuilder(88 + String.valueOf(notificationCommentParentId).length() + String.valueOf(commentContent).length()).append("IE02522: The local comments comment: ").append(notificationCommentParentId).append("is not equal to the notification comments content: ").append(commentContent).toString());
        }
        Integer commentUserId = null;
        try {
            commentUserId = Integer.parseInt(matcher.group(7));
        }
        catch (NumberFormatException exception) {
            throw new IllegalStateException(exception);
        }
        if (!commentUserId.equals(comment.getUser().getUserId())) {
            String exception = String.valueOf(commentUserId);
            int n2 = comment.getUser().getUserId();
            throw new IllegalStateException(new StringBuilder(109 + String.valueOf(exception).length()).append("IE02523: The user of the localy stored comment: ").append(exception).append(" is not equal to the ").append("notifications comments user: ").append(n2).toString());
        }
        IComment parentComment = CommentManager.get(provider).getCommentById(parentId);
        CComment newComment = new CComment(comment.getId(), comment.getUser(), parentComment, commentContent);
        CommentManager.CommentOperation operation = databaseOperation.equalsIgnoreCase("UPDATE") ? CommentManager.CommentOperation.EDIT : CommentManager.CommentOperation.DELETE;
        return new CommentNotificationContainer(comment, newComment, operation);
    }

    static Collection<CommentNotification> processEdgeGlobalCommentNotification(PGNotification notification, SQLProvider provider) {
        Matcher matcher = EDGE_GLOBAL_PATTERN.matcher(notification.getParameter());
        if (!matcher.find()) {
            return new ArrayList<CommentNotification>();
        }
        String databaseOperation = matcher.group(2);
        Integer notificationSourceModuleId = Integer.parseInt(matcher.group(3));
        Integer notificationDestinationModuleId = Integer.parseInt(matcher.group(4));
        CAddress notificationEdgeSourceAddress = new CAddress(new BigInteger(matcher.group(5)));
        CAddress notificationEdgeDestinationAddress = new CAddress(new BigInteger(matcher.group(6)));
        Integer commentId = matcher.group(8) == null ? null : Integer.valueOf(Integer.parseInt(matcher.group(8)));
        INaviModule notificationSourceModule = provider.findModule(notificationSourceModuleId);
        if (notificationSourceModule == null || !notificationSourceModule.isLoaded()) {
            return new ArrayList<CommentNotification>();
        }
        INaviModule notificationDestinationModule = provider.findModule(notificationDestinationModuleId);
        if (notificationDestinationModule == null || !notificationDestinationModule.isLoaded()) {
            return new ArrayList<CommentNotification>();
        }
        CommentManager.CommentOperation operation = databaseOperation.equalsIgnoreCase("DELETE") ? CommentManager.CommentOperation.DELETE : CommentManager.CommentOperation.APPEND;
        ArrayList<CommentNotification> notifications = new ArrayList<CommentNotification>();
        ImmutableCollection<INaviEdge> edges = EdgeCache.get(provider).getEdgeBySourceAndTarget(notificationEdgeSourceAddress, notificationSourceModuleId, notificationEdgeDestinationAddress, notificationDestinationModuleId);
        for (INaviEdge edge : edges) {
            notifications.add(new EdgeCommentNotificationContainer(edge, operation, CommentManager.CommentScope.GLOBAL, commentId));
        }
        return notifications;
    }

    static CommentNotification processEdgeLocalCommentNotification(PGNotification notification, SQLProvider provider) {
        Matcher matcher = EDGE_LOCAL_PATTERN.matcher(notification.getParameter());
        if (!matcher.find()) {
            return null;
        }
        Integer edgeId = Integer.parseInt(matcher.group(3));
        Integer commentId = matcher.group(4).equals("null") ? null : Integer.valueOf(Integer.parseInt(matcher.group(4)));
        INaviEdge edge = EdgeCache.get(provider).getEdgeById(edgeId);
        if (edge == null) {
            return null;
        }
        CommentManager.CommentOperation operation = commentId == null ? CommentManager.CommentOperation.DELETE : CommentManager.CommentOperation.APPEND;
        return new EdgeCommentNotificationContainer(edge, operation, CommentManager.CommentScope.LOCAL, commentId);
    }

    static CommentNotification processFunctionCommentNotification(PGNotification notification, SQLProvider provider) {
        Matcher matcher = FUNCTION_PATTERN.matcher(notification.getParameter());
        if (!matcher.find()) {
            return null;
        }
        Integer notificationModuleId = Integer.parseInt(matcher.group(3));
        CAddress notificationFunctionAddress = new CAddress(new BigInteger(matcher.group(4)));
        Integer commentId = matcher.group(5).equals("null") ? null : Integer.valueOf(Integer.parseInt(matcher.group(5)));
        INaviModule module = provider.findModule(notificationModuleId);
        if (module == null || !module.isLoaded()) {
            return null;
        }
        INaviFunction function = module.getContent().getFunctionContainer().getFunction(notificationFunctionAddress);
        if (function == null) {
            return null;
        }
        CommentManager.CommentOperation operation = commentId == null ? CommentManager.CommentOperation.DELETE : CommentManager.CommentOperation.APPEND;
        return new FunctionCommentNotificationContainer(function, operation, commentId);
    }

    static CommentNotification processFunctionNodeCommentNotification(PGNotification notification, SQLProvider provider) {
        Matcher matcher = FUNCTION_NODE_PATTERN.matcher(notification.getParameter());
        if (!matcher.find()) {
            return null;
        }
        Integer moduleId = Integer.parseInt(matcher.group(3));
        Integer nodeId = Integer.parseInt(matcher.group(4));
        Integer commentId = matcher.group(6).equals("null") ? null : Integer.valueOf(Integer.parseInt(matcher.group(6)));
        INaviModule module = provider.findModule(moduleId);
        if (module == null || !module.isLoaded()) {
            return null;
        }
        INaviFunctionNode functionNode = (INaviFunctionNode)NodeCache.get(provider).getNodeById(nodeId);
        if (functionNode == null) {
            return null;
        }
        CommentManager.CommentOperation operation = commentId == null ? CommentManager.CommentOperation.DELETE : CommentManager.CommentOperation.APPEND;
        return new FunctionNodeCommentNotificationContainer(functionNode, operation, commentId);
    }

    static CommentNotification processGroupNodeCommentNotification(PGNotification notification, SQLProvider provider) {
        Matcher matcher = GROUP_NODE_PATTERN.matcher(notification.getParameter());
        if (!matcher.find()) {
            return null;
        }
        Integer nodeId = Integer.parseInt(matcher.group(3));
        Integer commentId = matcher.group(4).equals("null") ? null : Integer.valueOf(Integer.parseInt(matcher.group(4)));
        INaviGroupNode groupNode = (INaviGroupNode)NodeCache.get(provider).getNodeById(nodeId);
        if (groupNode == null) {
            return null;
        }
        CommentManager.CommentOperation operation = commentId == null ? CommentManager.CommentOperation.DELETE : CommentManager.CommentOperation.APPEND;
        return new GroupNodeCommentNotificationContainer(groupNode, operation, commentId);
    }

    static CommentNotification processInstructionGlobalCommentNotification(PGNotification notification, SQLProvider provider) {
        Matcher matcher = INSTRUCTION_GLOBAL_PATTERN.matcher(notification.getParameter());
        if (!matcher.find()) {
            return null;
        }
        Integer moduleId = Integer.parseInt(matcher.group(3));
        CAddress address = new CAddress(new BigInteger(matcher.group(4)));
        Integer commentId = matcher.group(7) == null ? null : Integer.valueOf(Integer.parseInt(matcher.group(7)));
        INaviModule module = provider.findModule(moduleId);
        if (module == null || !module.isLoaded()) {
            return null;
        }
        INaviInstruction instruction = InstructionCache.get(provider).getInstructionByAddress(address, moduleId);
        if (instruction == null) {
            return null;
        }
        CommentManager.CommentOperation operation = commentId == null ? CommentManager.CommentOperation.DELETE : CommentManager.CommentOperation.APPEND;
        return new InstructionCommentNotificationContainer(instruction, null, operation, CommentManager.CommentScope.GLOBAL, commentId);
    }

    static Collection<CommentNotification> processNodeGlobalCommentNotification(PGNotification notification, SQLProvider provider) {
        Matcher matcher = NODE_GLOBAL_PATTERN.matcher(notification.getParameter());
        if (!matcher.find()) {
            return new ArrayList<CommentNotification>();
        }
        String databaseOperation = matcher.group(2);
        int moduleId = Integer.parseInt(matcher.group(3));
        CAddress nodeAddress = new CAddress(new BigInteger(matcher.group(4)));
        Integer commentId = matcher.group(6) == null ? null : Integer.valueOf(Integer.parseInt(matcher.group(6)));
        INaviModule notificationModule = provider.findModule(moduleId);
        if (notificationModule == null || !notificationModule.isLoaded()) {
            return new ArrayList<CommentNotification>();
        }
        ImmutableCollection<INaviViewNode> nodes = NodeCache.get(provider).getNodeByAddress(nodeAddress, moduleId);
        if (nodes == null) {
            return new ArrayList<CommentNotification>();
        }
        CommentManager.CommentOperation operation = databaseOperation.equalsIgnoreCase("DELETE") ? CommentManager.CommentOperation.DELETE : CommentManager.CommentOperation.APPEND;
        ArrayList<CommentNotification> notifications = new ArrayList<CommentNotification>();
        for (INaviViewNode node : nodes) {
            notifications.add(new CodeNodeCommentNotificationContainer((INaviCodeNode)node, operation, CommentManager.CommentScope.GLOBAL, commentId));
        }
        return notifications;
    }

    static CommentNotification processNodeLocalInstructionCommentNotification(PGNotification notification, SQLProvider provider) {
        Matcher instructionMatcher = INSTRUCTION_LOCAL_PATTERN.matcher(notification.getParameter());
        boolean instructionMatchFound = instructionMatcher.find();
        if (!instructionMatchFound) {
            return null;
        }
        Integer moduleId = Integer.parseInt(instructionMatcher.group(3));
        Integer nodeId = Integer.parseInt(instructionMatcher.group(4));
        BigInteger notificationInstructionAddress = new BigInteger(instructionMatcher.group(6));
        Integer commentId = instructionMatcher.group(7).equals("null") ? null : Integer.valueOf(Integer.parseInt(instructionMatcher.group(7)));
        INaviModule module = provider.findModule(moduleId);
        if (module == null || !module.isLoaded()) {
            return null;
        }
        CAddress address = new CAddress(notificationInstructionAddress);
        INaviInstruction instruction = InstructionCache.get(provider).getInstructionByAddress(address, module.getConfiguration().getId());
        if (instruction == null) {
            return null;
        }
        INaviCodeNode codeNode = (INaviCodeNode)NodeCache.get(provider).getNodeById(nodeId);
        if (codeNode == null) {
            return null;
        }
        CommentManager.CommentOperation operation = commentId == null ? CommentManager.CommentOperation.DELETE : CommentManager.CommentOperation.APPEND;
        return new InstructionCommentNotificationContainer(instruction, codeNode, operation, CommentManager.CommentScope.LOCAL, commentId);
    }

    static CommentNotification processNodeLocalNodeCommentNotification(PGNotification notification, SQLProvider provider) {
        Matcher matcher = NODE_LOCAL_PATTERN.matcher(notification.getParameter());
        if (!matcher.find()) {
            return null;
        }
        Integer moduleId = Integer.parseInt(matcher.group(3));
        Integer nodeId = Integer.parseInt(matcher.group(4));
        Integer commentId = matcher.group(6).equals("null") ? null : Integer.valueOf(Integer.parseInt(matcher.group(6)));
        INaviModule module = provider.findModule(moduleId);
        if (!module.isLoaded()) {
            return null;
        }
        INaviCodeNode codeNode = (INaviCodeNode)NodeCache.get(provider).getNodeById(nodeId);
        if (codeNode == null) {
            return null;
        }
        CommentManager.CommentOperation operation = commentId == null ? CommentManager.CommentOperation.DELETE : CommentManager.CommentOperation.APPEND;
        return new CodeNodeCommentNotificationContainer(codeNode, operation, CommentManager.CommentScope.LOCAL, commentId);
    }

    static CommentNotification processTextNodeCommentNotification(PGNotification notification, SQLProvider provider) {
        Matcher matcher = TEXT_NODE_PATTERN.matcher(notification.getParameter());
        if (!matcher.find()) {
            return null;
        }
        Integer nodeId = Integer.parseInt(matcher.group(3));
        Integer commentId = matcher.group(4).equals("null") ? null : Integer.valueOf(Integer.parseInt(matcher.group(4)));
        INaviTextNode node = (INaviTextNode)NodeCache.get(provider).getNodeById(nodeId);
        if (node == null) {
            return null;
        }
        CommentManager.CommentOperation operation = commentId == null ? CommentManager.CommentOperation.DELETE : CommentManager.CommentOperation.APPEND;
        return new TextNodeCommentNotificationContainer(node, operation, commentId);
    }

    static CommentNotification processTypeInstanceCommentNotification(PGNotification notification, SQLProvider provider) {
        Matcher matcher = TYPE_INSTANCE_PATTERN.matcher(notification.getParameter());
        if (!matcher.find()) {
            return null;
        }
        Integer moduleId = Integer.parseInt(matcher.group(3));
        Integer typeInstanceId = Integer.parseInt(matcher.group(4));
        Integer commentId = matcher.group(5).equals("null") ? null : Integer.valueOf(Integer.parseInt(matcher.group(5)));
        INaviModule module = provider.findModule(moduleId);
        if (module == null || !module.isLoaded()) {
            return null;
        }
        TypeInstance instance = module.getContent().getTypeInstanceContainer().getTypeInstanceById(typeInstanceId);
        if (instance == null) {
            return null;
        }
        CommentManager.CommentOperation operation = commentId == null ? CommentManager.CommentOperation.DELETE : CommentManager.CommentOperation.APPEND;
        return new TypeInstanceCommentNotificationContainer(instance, operation, commentId);
    }

    @Override
    public Collection<CommentNotification> parse(Collection<PGNotification> commentNotifications, SQLProvider provider) {
        Preconditions.checkNotNull(commentNotifications, "Error: commentNotifications argument can not be null");
        Preconditions.checkNotNull(provider, "IE02524: provider argument can not be null");
        for (PGNotification notification : commentNotifications) {
            String notificationParameter = notification.getParameter();
            String tableName = notificationParameter.split("\\s")[0];
            try {
                switch (tableName) {
                    case "bn_codenode_instructions": {
                        PostgreSQLCommentNotificationParser.informNotification(PostgreSQLCommentNotificationParser.processNodeLocalInstructionCommentNotification(notification, provider), provider);
                        break;
                    }
                    case "bn_instructions": {
                        PostgreSQLCommentNotificationParser.informNotification(PostgreSQLCommentNotificationParser.processInstructionGlobalCommentNotification(notification, provider), provider);
                        break;
                    }
                    case "bn_code_nodes": {
                        PostgreSQLCommentNotificationParser.informNotification(PostgreSQLCommentNotificationParser.processNodeLocalNodeCommentNotification(notification, provider), provider);
                        break;
                    }
                    case "bn_global_node_comments": {
                        PostgreSQLCommentNotificationParser.informNotification(PostgreSQLCommentNotificationParser.processNodeGlobalCommentNotification(notification, provider), provider);
                        break;
                    }
                    case "bn_edges": {
                        PostgreSQLCommentNotificationParser.informNotification(PostgreSQLCommentNotificationParser.processEdgeLocalCommentNotification(notification, provider), provider);
                        break;
                    }
                    case "bn_global_edge_comments": {
                        PostgreSQLCommentNotificationParser.informNotification(PostgreSQLCommentNotificationParser.processEdgeGlobalCommentNotification(notification, provider), provider);
                        break;
                    }
                    case "bn_function_nodes": {
                        PostgreSQLCommentNotificationParser.informNotification(PostgreSQLCommentNotificationParser.processFunctionNodeCommentNotification(notification, provider), provider);
                        break;
                    }
                    case "bn_functions": {
                        PostgreSQLCommentNotificationParser.informNotification(PostgreSQLCommentNotificationParser.processFunctionCommentNotification(notification, provider), provider);
                        break;
                    }
                    case "bn_text_nodes": {
                        PostgreSQLCommentNotificationParser.informNotification(PostgreSQLCommentNotificationParser.processTextNodeCommentNotification(notification, provider), provider);
                        break;
                    }
                    case "bn_group_nodes": {
                        PostgreSQLCommentNotificationParser.informNotification(PostgreSQLCommentNotificationParser.processGroupNodeCommentNotification(notification, provider), provider);
                        break;
                    }
                    case "bn_type_instances": {
                        PostgreSQLCommentNotificationParser.informNotification(PostgreSQLCommentNotificationParser.processTypeInstanceCommentNotification(notification, provider), provider);
                        break;
                    }
                    case "bn_comments": {
                        PostgreSQLCommentNotificationParser.informNotification(PostgreSQLCommentNotificationParser.processCommentNotification(notification, provider), provider);
                        break;
                    }
                    default: {
                        NaviLogger.warning("Table name %s not known", tableName);
                        break;
                    }
                }
            }
            catch (CouldntLoadDataException exception) {
                NaviLogger.severe("Error: Could not successfully parse the database comment notification: %s", notification.toString());
            }
        }
        return new ArrayList<CommentNotification>();
    }

    private static void informNotification(CommentNotification notification, SQLProvider provider) throws CouldntLoadDataException {
        if (notification != null) {
            notification.inform(CommentManager.get(provider));
        }
    }

    private static void informNotification(Collection<CommentNotification> notifications, SQLProvider provider) throws CouldntLoadDataException {
        for (CommentNotification notification : notifications) {
            PostgreSQLCommentNotificationParser.informNotification(notification, provider);
        }
    }

    @Override
    public void inform(Collection<CommentNotification> commentNotifications, SQLProvider provider) {
    }

    static {
        EDGE_GLOBAL_PATTERN = Pattern.compile(EDGE_GLOBAL_NOTIFICATION, 40);
        TYPE_INSTANCE_PATTERN = Pattern.compile(TYPE_INSTANCE_NOTIFICATION, 40);
        EDGE_LOCAL_PATTERN = Pattern.compile(EDGE_LOCAL_NOTIFICATION, 40);
        TEXT_NODE_PATTERN = Pattern.compile(TEXT_NODE_NOTIFICATION, 40);
        GROUP_NODE_PATTERN = Pattern.compile(GROUP_NODE_NOTIFICATION, 40);
        FUNCTION_PATTERN = Pattern.compile(FUNCTION_NOTIFICATION, 40);
        FUNCTION_NODE_PATTERN = Pattern.compile(FUNCTION_NODE_NOTIFICATION, 40);
        INSTRUCTION_GLOBAL_PATTERN = Pattern.compile(INSTRUCTION_GLOBAL_NOTIFICATION, 40);
        INSTRUCTION_LOCAL_PATTERN = Pattern.compile(INSTRUCTION_LOCAL_NOTIFICATION, 40);
        NODE_LOCAL_PATTERN = Pattern.compile(NODE_LOCAL_NOTIFICATION, 40);
        NODE_GLOBAL_PATTERN = Pattern.compile(NODE_GLOBAL_NOTIFICATION, 40);
    }
}

