/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.containers;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.interfaces.CommentNotification;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.disassembly.CommentManager;

public abstract class AbstractCommentNotification
implements CommentNotification {
    private final CommentManager.CommentOperation operation;
    private final Integer commentId;

    public AbstractCommentNotification(CommentManager.CommentOperation operation, Integer commentId) {
        this.operation = Preconditions.checkNotNull(operation, "Error: Operation argument can not be null.");
        this.commentId = commentId;
    }

    @Override
    public CommentManager.CommentOperation getOperation() {
        return this.operation;
    }

    @Override
    public Integer getCommentId() {
        return this.commentId;
    }

    abstract void informDelete(CommentManager var1, IComment var2);

    abstract void informAppend(CommentManager var1) throws CouldntLoadDataException;

    @Override
    public void inform(CommentManager manager) throws CouldntLoadDataException {
        IComment comment = manager.getCommentById(this.getCommentId());
        if (this.operation == CommentManager.CommentOperation.DELETE && comment != null) {
            this.informDelete(manager, comment);
        } else if (this.operation == CommentManager.CommentOperation.APPEND) {
            this.informAppend(manager);
        }
    }
}

