/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Loaders;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.Database.AbstractSQLProvider;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.PostgreSQLHelpers;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointAddress;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceEvent;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceEventType;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceList;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceRegister;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.types.lists.FilledList;
import com.google.security.zynamics.zylib.types.lists.IFilledList;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class PostgreSQLTracesLoader {
    private PostgreSQLTracesLoader() {
    }

    private static INaviModule findModule(List<? extends INaviModule> modules, int moduleId) {
        for (INaviModule iNaviModule : modules) {
            if (iNaviModule.getConfiguration().getId() != moduleId) continue;
            return iNaviModule;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadTraceEvents(CConnection connection, TraceList traceList, List<? extends INaviModule> modules) throws SQLException {
        List<List<TraceRegister>> values = PostgreSQLTracesLoader.loadTraceEventValues(connection, traceList);
        String string2 = String.valueOf("select tid, module_id, address, type from bn_trace_events where trace_id = ");
        int n2 = traceList.getId();
        String query = new StringBuilder(33 + String.valueOf(string2).length()).append(string2).append(n2).append(" order by position asc").toString();
        int counter = 0;
        try (ResultSet resultSet = connection.executeQuery(query, true);){
            while (resultSet.next()) {
                long tid = resultSet.getLong("tid");
                int moduleId = resultSet.getInt("module_id");
                INaviModule module = resultSet.wasNull() ? null : PostgreSQLTracesLoader.findModule(modules, moduleId);
                BreakpointAddress address = new BreakpointAddress(module, new UnrelocatedAddress(PostgreSQLHelpers.loadAddress(resultSet, "address")));
                int event = resultSet.getInt("type");
                traceList.addEvent(new TraceEvent(tid, address, TraceEventType.parseInt(event), values.isEmpty() ? new ArrayList() : values.get(counter)));
                ++counter;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<List<TraceRegister>> loadTraceEventValues(CConnection connection, TraceList traceList) throws SQLException {
        ArrayList<List<TraceRegister>> values = new ArrayList<List<TraceRegister>>();
        String string2 = String.valueOf("select position, register_name, register_value, memory_value from bn_trace_event_values where trace_id = ");
        int n2 = traceList.getId();
        String query = new StringBuilder(33 + String.valueOf(string2).length()).append(string2).append(n2).append(" order by position asc").toString();
        int currentPosition = -1;
        try (ResultSet resultSet = connection.executeQuery(query, true);){
            ArrayList<TraceRegister> registers = new ArrayList<TraceRegister>();
            while (resultSet.next()) {
                int position = resultSet.getInt("position");
                if (position != currentPosition) {
                    if (!registers.isEmpty()) {
                        values.add(Lists.newArrayList(registers));
                        registers = new FilledList();
                    }
                    currentPosition = position;
                }
                String name = PostgreSQLHelpers.readString(resultSet, "register_name");
                long value = resultSet.getLong("register_value");
                byte[] memory = resultSet.getBytes("memory_value");
                registers.add(new TraceRegister(name, new CAddress(value), memory));
            }
            if (!registers.isEmpty()) {
                values.add(Lists.newArrayList(registers));
            }
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IFilledList<TraceList> loadTraces(AbstractSQLProvider provider, String tableName, String columnName, int containerId, List<? extends INaviModule> modules) throws CouldntLoadDataException {
        Preconditions.checkNotNull(provider, "IE00590: Provider argument can not be null");
        Preconditions.checkNotNull(tableName, "IE00591: Table name argument can not be null");
        Preconditions.checkNotNull(columnName, "IE00592: Column name argument can not be null");
        String string2 = String.valueOf("select id, name, description from bn_traces join ");
        String string3 = String.valueOf("bn_traces");
        String query = new StringBuilder(41 + String.valueOf(string2).length() + String.valueOf(tableName).length() + String.valueOf(tableName).length() + String.valueOf(string3).length() + String.valueOf(tableName).length() + String.valueOf(columnName).length()).append(string2).append(tableName).append(" on ").append(tableName).append(".trace_id = ").append(string3).append(".id where ").append(tableName).append(".").append(columnName).append(" = ").append(containerId).toString();
        CConnection connection = provider.getConnection();
        FilledList<TraceList> traces = new FilledList<TraceList>();
        try (ResultSet resultSet = connection.executeQuery(query, true);){
            while (resultSet.next()) {
                int traceId = resultSet.getInt("id");
                String name = PostgreSQLHelpers.readString(resultSet, "name");
                String description = PostgreSQLHelpers.readString(resultSet, "description");
                TraceList traceList = new TraceList(traceId, name, description, provider);
                PostgreSQLTracesLoader.loadTraceEvents(connection, traceList, modules);
                traces.add(traceList);
            }
        }
        catch (SQLException exception) {
            throw new CouldntLoadDataException(exception);
        }
        return traces;
    }
}

