/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Loaders;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.AbstractSQLProvider;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLCommentFunctions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.disassembly.CTextNode;
import com.google.security.zynamics.binnavi.disassembly.INaviTextNode;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import java.awt.Color;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class PostgreSQLTextNodeLoader {
    private PostgreSQLTextNodeLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(AbstractSQLProvider provider, INaviView view, List<INaviViewNode> nodes) throws CouldntLoadDataException {
        Preconditions.checkNotNull(provider, "IE02516: provider argument can not be null");
        Preconditions.checkNotNull(view, "IE02517: view argument can not be null");
        Preconditions.checkNotNull(nodes, "IE02518: nodes argument can not be null");
        HashMap<Integer, CTextNode> commentIdToTextNode = new HashMap<Integer, CTextNode>();
        String string2 = String.valueOf("SELECT id, comment_id, x, y, width, height, color, selected, visible  FROM bn_nodes JOIN bn_text_nodes ON id = node_id  WHERE view_id = ");
        int n2 = view.getConfiguration().getId();
        String query = new StringBuilder(11 + String.valueOf(string2).length()).append(string2).append(n2).toString();
        try {
            PreparedStatement statement = provider.getConnection().getConnection().prepareStatement(query);
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    int nodeId = resultSet.getInt("id");
                    Integer commentId = resultSet.getInt("comment_id");
                    if (resultSet.wasNull()) {
                        commentId = null;
                    }
                    double xPos = resultSet.getDouble("x");
                    double yPos = resultSet.getDouble("y");
                    double width = resultSet.getDouble("width");
                    double height = resultSet.getDouble("height");
                    Color color = new Color(resultSet.getInt("color"));
                    boolean selected = resultSet.getBoolean("selected");
                    boolean visible = resultSet.getBoolean("visible");
                    CTextNode textNode = new CTextNode(nodeId, xPos, yPos, width, height, color, selected, visible, new HashSet<CTag>(), null, (SQLProvider)provider);
                    if (commentId != null) {
                        commentIdToTextNode.put(commentId, textNode);
                    }
                    nodes.add(textNode);
                }
            }
            if (!commentIdToTextNode.isEmpty()) {
                HashMap<Integer, ArrayList<IComment>> commentIdToComments = PostgreSQLCommentFunctions.loadMultipleCommentsById(provider, commentIdToTextNode.keySet());
                for (Map.Entry<Integer, ArrayList<IComment>> commentIdToComment : commentIdToComments.entrySet()) {
                    ((INaviTextNode)commentIdToTextNode.get(commentIdToComment.getKey())).initializeComment((List<IComment>)commentIdToComment.getValue());
                }
            }
        }
        catch (SQLException exception) {
            throw new CouldntLoadDataException(exception);
        }
    }
}

