/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Loaders;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Loaders.PostgreSQLProjectViewsLoader;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.PostgreSQLHelpers;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.Tagging.CTagManager;
import com.google.security.zynamics.binnavi.Tagging.ITagManager;
import com.google.security.zynamics.binnavi.disassembly.IFlowgraphView;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.binnavi.disassembly.views.CView;
import com.google.security.zynamics.binnavi.disassembly.views.ImmutableNaviViewConfiguration;
import com.google.security.zynamics.zylib.disassembly.GraphType;
import com.google.security.zynamics.zylib.disassembly.ViewType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class PostgreSQLProjectFlowgraphsLoader
extends PostgreSQLProjectViewsLoader {
    private PostgreSQLProjectFlowgraphsLoader() {
    }

    public static List<IFlowgraphView> loadFlowgraphs(SQLProvider provider, INaviProject project, CTagManager viewTagManager, CTagManager nodeTagManager) throws CouldntLoadDataException {
        PostgreSQLProjectFlowgraphsLoader.checkArguments(provider, project, viewTagManager);
        CConnection connection = provider.getConnection();
        String query = " SELECT * FROM load_project_flow_graphs(?, ?) ";
        try {
            PreparedStatement statement = connection.getConnection().prepareStatement(" SELECT * FROM load_project_flow_graphs(?, ?) ");
            statement.setInt(1, project.getConfiguration().getId());
            statement.setObject(2, (Object)"non-native", 1111);
            ResultSet resultSet = statement.executeQuery();
            Map<Integer, Set<CTag>> tags = PostgreSQLProjectFlowgraphsLoader.loadTags(connection, project, viewTagManager);
            return new ArrayList<IFlowgraphView>(PostgreSQLProjectFlowgraphsLoader.processQueryResults(resultSet, project, tags, (ITagManager)nodeTagManager, provider, new ArrayList<CView>(), ViewType.NonNative, GraphType.FLOWGRAPH));
        }
        catch (SQLException exception) {
            throw new CouldntLoadDataException(exception);
        }
    }

    public static ImmutableNaviViewConfiguration loadFlowGraphInformation(SQLProvider provider, INaviProject project, Integer viewId) throws CouldntLoadDataException {
        Preconditions.checkNotNull(provider, "IE02618: provider argument can not be null");
        Preconditions.checkNotNull(project, "IE02619: project argument can not be null");
        Preconditions.checkNotNull(viewId, "IE02620: viewId argument can not be null");
        CConnection connection = provider.getConnection();
        String query = " SELECT * FROM load_project_flowGraph(?,?) ";
        try {
            PreparedStatement statement = connection.getConnection().prepareStatement(" SELECT * FROM load_project_flowGraph(?,?) ");
            statement.setInt(1, project.getConfiguration().getId());
            statement.setInt(2, viewId);
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                int databaseViewId = resultSet.getInt("view_id");
                String name = PostgreSQLHelpers.readString(resultSet, "name");
                String description = PostgreSQLHelpers.readString(resultSet, "description");
                ViewType viewType = resultSet.getString("type").equalsIgnoreCase("native") ? ViewType.Native : ViewType.NonNative;
                Timestamp creationDate = resultSet.getTimestamp("creation_date");
                Timestamp modificationDate = resultSet.getTimestamp("modification_date");
                boolean isStared = resultSet.getBoolean("stared");
                int nodeCount = resultSet.getInt("bbcount");
                int edgeCount = resultSet.getInt("edgecount");
                ImmutableNaviViewConfiguration viewConfiguration = new ImmutableNaviViewConfiguration(databaseViewId, name, description, viewType, creationDate, modificationDate, isStared, nodeCount, edgeCount);
                return viewConfiguration;
            }
            return null;
        }
        catch (SQLException exception) {
            throw new CouldntLoadDataException(exception);
        }
    }
}

