/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Loaders;

import com.google.security.zynamics.binnavi.Database.AbstractSQLProvider;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.Exceptions.CPartialLoadException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Loaders.PostgreSQLCodeNodeLoader;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Loaders.PostgreSQLFunctionNodeLoader;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Loaders.PostgreSQLGroupNodeLoader;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Loaders.PostgreSQLTextNodeLoader;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.Tagging.CTagHelpers;
import com.google.security.zynamics.binnavi.Tagging.CTagManager;
import com.google.security.zynamics.binnavi.disassembly.CNaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public final class PostgreSQLNodeLoader {
    private PostgreSQLNodeLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadNodeTags(CConnection connection, List<INaviViewNode> nodes, CTagManager nodeTagManager) throws SQLException {
        HashMap<Integer, INaviViewNode> idNodeMap = new HashMap<Integer, INaviViewNode>();
        HashMap<Integer, CTag> idTagMap = new HashMap<Integer, CTag>();
        StringBuffer range = new StringBuffer();
        boolean isFirst = true;
        for (INaviViewNode node : nodes) {
            range.append(isFirst ? "" : ",");
            range.append(node.getId());
            isFirst = false;
            idNodeMap.put(node.getId(), node);
        }
        if (isFirst) {
            return;
        }
        String query = String.format("SELECT node_id, tag_id FROM %s WHERE node_id IN (%s)", "bn_tagged_nodes", range.toString());
        try (ResultSet resultSet = connection.executeQuery(query, true);){
            HashSet<Integer> tagIds = new HashSet<Integer>();
            while (resultSet.next()) {
                tagIds.add(resultSet.getInt("tag_id"));
            }
            Collection<CTag> tags = CTagHelpers.findTags(nodeTagManager.getRootTag(), tagIds);
            for (CTag tag : tags) {
                idTagMap.put(tag.getId(), tag);
            }
            resultSet.beforeFirst();
            while (resultSet.next()) {
                CTag tag;
                INaviViewNode node = (INaviViewNode)idNodeMap.get(resultSet.getInt("node_id"));
                tag = (CTag)idTagMap.get(resultSet.getInt("tag_id"));
                ((CNaviViewNode)node).tagNodeSilent(tag);
            }
        }
    }

    public static List<INaviViewNode> loadNodes(AbstractSQLProvider provider, INaviView view, List<INaviModule> modules, CTagManager nodeTagManager) throws SQLException, CPartialLoadException, CouldntLoadDataException {
        ArrayList<INaviViewNode> nodes = new ArrayList<INaviViewNode>();
        PostgreSQLGroupNodeLoader.load(provider, view, nodes);
        PostgreSQLFunctionNodeLoader.load(provider, view, nodes);
        PostgreSQLCodeNodeLoader.load(provider, view, nodes, modules);
        PostgreSQLTextNodeLoader.load(provider, view, nodes);
        Collections.sort(nodes, new Comparator<INaviViewNode>(){

            @Override
            public int compare(INaviViewNode lhs, INaviViewNode rhs) {
                return lhs.getId() - rhs.getId();
            }
        });
        CConnection connection = provider.getConnection();
        PostgreSQLGroupNodeLoader.setupGroupNodes(connection, view, nodes);
        PostgreSQLNodeLoader.loadNodeTags(connection, nodes, nodeTagManager);
        return nodes;
    }
}

