/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Loaders;

import com.google.security.zynamics.binnavi.Database.AbstractSQLProvider;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Loaders.PostgreSQLModuleViewsLoader;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Loaders.PostgreSQLViewsLoader;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.Tagging.CTagManager;
import com.google.security.zynamics.binnavi.Tagging.ITagManager;
import com.google.security.zynamics.binnavi.disassembly.ICallgraphView;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModule;
import com.google.security.zynamics.binnavi.disassembly.views.CView;
import com.google.security.zynamics.zylib.disassembly.GraphType;
import com.google.security.zynamics.zylib.disassembly.ViewType;
import com.google.security.zynamics.zylib.types.lists.FilledList;
import com.google.security.zynamics.zylib.types.lists.IFilledList;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public final class PostgreSQLModuleCallgraphsLoader
extends PostgreSQLViewsLoader {
    private PostgreSQLModuleCallgraphsLoader() {
    }

    private static IFilledList<ICallgraphView> loadModuleCallgraphs(AbstractSQLProvider provider, CModule module, CTagManager viewTagManager, ITagManager nodeTagManager, ViewType viewType) throws CouldntLoadDataException {
        PostgreSQLViewsLoader.checkArguments(provider, module, viewTagManager);
        String query = "SELECT * FROM load_module_call_graphs(?, ?)";
        try {
            CConnection connection = provider.getConnection();
            PreparedStatement statement = connection.getConnection().prepareStatement("SELECT * FROM load_module_call_graphs(?, ?)");
            statement.setInt(1, module.getConfiguration().getId());
            statement.setObject(2, (Object)(viewType == ViewType.Native ? "native" : "non-native"), 1111);
            ResultSet resultSet = statement.executeQuery();
            Map<Integer, Set<CTag>> tags = PostgreSQLModuleViewsLoader.loadTags(connection, module, viewTagManager);
            return new FilledList<ICallgraphView>((Collection<ICallgraphView>)PostgreSQLModuleCallgraphsLoader.processQueryResults(resultSet, module, tags, nodeTagManager, (SQLProvider)provider, new ArrayList<CView>(), viewType, GraphType.CALLGRAPH));
        }
        catch (SQLException exception) {
            throw new CouldntLoadDataException(exception);
        }
    }

    public static IFilledList<ICallgraphView> loadCallgraphViews(AbstractSQLProvider provider, CModule module, CTagManager viewTagManager, CTagManager nodeTagManager) throws CouldntLoadDataException {
        return PostgreSQLModuleCallgraphsLoader.loadModuleCallgraphs(provider, module, viewTagManager, nodeTagManager, ViewType.NonNative);
    }

    public static ICallgraphView loadNativeCallgraph(AbstractSQLProvider provider, CModule module, CTagManager viewTagManager, CTagManager nodeTagManager) throws CouldntLoadDataException {
        IFilledList<ICallgraphView> views = PostgreSQLModuleCallgraphsLoader.loadModuleCallgraphs(provider, module, viewTagManager, nodeTagManager, ViewType.Native);
        if (views.size() != 1) {
            throw new CouldntLoadDataException("Error: Malformed project");
        }
        return (ICallgraphView)views.get(0);
    }
}

