/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Loaders;

import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.Database.AbstractSQLProvider;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLCommentFunctions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.disassembly.CNaviViewEdge;
import com.google.security.zynamics.binnavi.disassembly.CommentManager;
import com.google.security.zynamics.binnavi.disassembly.IAddressNode;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviEdge;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.gui.zygraph.edges.CBend;
import com.google.security.zynamics.zylib.gui.zygraph.edges.EdgeType;
import java.awt.Color;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class PostgreSQLEdgeLoader {
    private PostgreSQLEdgeLoader() {
    }

    private static void initializeGlobalComment(CNaviViewEdge edge, ArrayList<IComment> globalComments, SQLProvider provider) {
        INaviViewNode source = (INaviViewNode)edge.getSource();
        INaviViewNode target = (INaviViewNode)edge.getTarget();
        if (source instanceof INaviCodeNode && target instanceof IAddressNode) {
            CommentManager.get(provider).initializeGlobalEdgeComment(edge, globalComments);
        } else if (source instanceof INaviFunctionNode && target instanceof IAddressNode) {
            CommentManager.get(provider).initializeGlobalEdgeComment(edge, globalComments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<INaviEdge> loadEdges(AbstractSQLProvider provider, INaviView view, Map<Integer, INaviViewNode> nodeLookup, Map<Integer, ArrayList<IComment>> edgeToGlobalCommentMap) throws CouldntLoadDataException {
        int n2 = view.getConfiguration().getId();
        String query = new StringBuilder(42).append("SELECT * FROM load_view_edges(").append(n2).append(")").toString();
        ArrayList<CBend> currentPaths = new ArrayList<CBend>();
        HashMap<Integer, CNaviViewEdge> commentIdToEdge = new HashMap<Integer, CNaviViewEdge>();
        HashMap<Integer, CNaviViewEdge> edgeIdToEdge = new HashMap<Integer, CNaviViewEdge>();
        try {
            CConnection connection = provider.getConnection();
            PreparedStatement statement = connection.getConnection().prepareStatement(query);
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    ArrayList<IComment> globalComments;
                    int edgeId = resultSet.getInt("id");
                    if (edgeIdToEdge.containsKey(edgeId)) {
                        INaviEdge edge = (INaviEdge)edgeIdToEdge.get(edgeId);
                        double pathX = resultSet.getDouble("x");
                        double pathY = resultSet.getDouble("y");
                        if (resultSet.wasNull()) continue;
                        edge.addBend(pathX, pathY);
                        continue;
                    }
                    int sourceNode = resultSet.getInt("source_node_id");
                    int targetNode = resultSet.getInt("target_node_id");
                    Integer localCommentId = resultSet.getInt("comment_id");
                    if (resultSet.wasNull()) {
                        localCommentId = null;
                    }
                    double x1 = resultSet.getDouble("x1");
                    double y1 = resultSet.getDouble("y1");
                    double x2 = resultSet.getDouble("x2");
                    double y2 = resultSet.getDouble("y2");
                    EdgeType type = EdgeType.valueOf(resultSet.getString("type").toUpperCase());
                    Color color = new Color(resultSet.getInt("color"));
                    boolean visible = resultSet.getBoolean("visible");
                    boolean selected = resultSet.getBoolean("selected");
                    INaviViewNode source = nodeLookup.get(sourceNode);
                    INaviViewNode target = nodeLookup.get(targetNode);
                    double pathX = resultSet.getDouble("x");
                    double pathY = resultSet.getDouble("y");
                    if (!resultSet.wasNull()) {
                        currentPaths.add(new CBend(pathX, pathY));
                    }
                    CNaviViewEdge edge = new CNaviViewEdge(edgeId, source, target, type, x1, y1, x2, y2, color, selected, visible, null, currentPaths, provider);
                    if (localCommentId != null) {
                        commentIdToEdge.put(localCommentId, edge);
                    }
                    ArrayList<IComment> arrayList = globalComments = edgeToGlobalCommentMap.containsKey(edgeId) ? edgeToGlobalCommentMap.get(edgeId) : null;
                    if (globalComments != null && globalComments.size() != 0) {
                        PostgreSQLEdgeLoader.initializeGlobalComment(edge, globalComments, provider);
                    }
                    source.addOutgoingEdge(edge);
                    target.addIncomingEdge(edge);
                    edgeIdToEdge.put(edge.getId(), edge);
                    currentPaths = new ArrayList();
                }
                if (!commentIdToEdge.isEmpty()) {
                    HashMap<Integer, ArrayList<IComment>> commentIdToComments = PostgreSQLCommentFunctions.loadMultipleCommentsById(provider, commentIdToEdge.keySet());
                    for (Map.Entry<Integer, ArrayList<IComment>> commentIdToComment : commentIdToComments.entrySet()) {
                        ((INaviEdge)commentIdToEdge.get(commentIdToComment.getKey())).initializeLocalComment((List<IComment>)commentIdToComment.getValue());
                    }
                }
            }
        }
        catch (SQLException exception) {
            throw new CouldntLoadDataException("Error: Loading of view edges failed");
        }
        return Lists.newArrayList(edgeIdToEdge.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Integer, ArrayList<IComment>> loadGlobalEdgeComments(SQLProvider provider, int viewId) throws CouldntLoadDataException {
        String string2 = String.valueOf("SELECT e.id, gc.comment_id FROM bn_global_edge_comments AS gc  join bn_instructions AS src_inst on gc.src_address = src_inst.address AND gc.src_module_id = src_inst.module_id  join bn_instructions AS dst_inst on gc.dst_address = dst_inst.address AND gc.dst_module_id = dst_inst.module_id  join bn_codenode_instructions AS src_nodes on src_nodes.address = gc.src_address AND src_nodes.position = 0 AND src_nodes.module_id = gc.src_module_id  join bn_codenode_instructions AS dst_nodes on dst_nodes.address = gc.dst_address AND dst_nodes.position = 0 AND dst_nodes.module_id = gc.dst_module_id  join bn_edges AS e ON e.source_node_id = src_nodes.node_id AND e.target_node_id = dst_nodes.node_id  join bn_nodes AS src_n ON e.source_node_id = src_n.id  join bn_nodes AS dst_n ON e.target_node_id = dst_n.id  WHERE src_n.view_id = ");
        String query = new StringBuilder(43 + String.valueOf(string2).length()).append(string2).append(viewId).append(" AND dst_n.view_id = ").append(viewId).toString();
        HashMap<Integer, Integer> commentIdsToEdgeIds = new HashMap<Integer, Integer>();
        HashMap<Integer, ArrayList<IComment>> edgeIdsToCommentArray = new HashMap<Integer, ArrayList<IComment>>();
        try (ResultSet resultSet = provider.getConnection().executeQuery(query, true);){
            while (resultSet.next()) {
                int edgeId = resultSet.getInt("id");
                int commentId = resultSet.getInt("comment_id");
                commentIdsToEdgeIds.put(commentId, edgeId);
            }
        }
        catch (SQLException exception) {
            throw new CouldntLoadDataException(exception);
        }
        if (!commentIdsToEdgeIds.isEmpty()) {
            HashMap<Integer, ArrayList<IComment>> commentIdsToComments = PostgreSQLCommentFunctions.loadMultipleCommentsById(provider, commentIdsToEdgeIds.keySet());
            for (Map.Entry<Integer, ArrayList<IComment>> commentIdToComment : commentIdsToComments.entrySet()) {
                edgeIdsToCommentArray.put((Integer)commentIdsToEdgeIds.get(commentIdToComment.getKey()), commentIdToComment.getValue());
            }
        }
        return edgeIdsToCommentArray;
    }

    public static List<INaviEdge> loadEdges(AbstractSQLProvider provider, INaviView view, Collection<INaviViewNode> nodes) throws CouldntLoadDataException {
        HashMap<Integer, INaviViewNode> nodeLookup = new HashMap<Integer, INaviViewNode>();
        ArrayList<Integer> nodeIdList = new ArrayList<Integer>();
        for (INaviViewNode viewNode : nodes) {
            nodeLookup.put(viewNode.getId(), viewNode);
            nodeIdList.add(viewNode.getId());
        }
        Map<Integer, ArrayList<IComment>> edgeToGlobalCommentMap = PostgreSQLEdgeLoader.loadGlobalEdgeComments(provider, view.getConfiguration().getId());
        return PostgreSQLEdgeLoader.loadEdges(provider, view, nodeLookup, edgeToGlobalCommentMap);
    }
}

