/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.AbstractSQLProvider;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.PostgreSQLHelpers;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplateManager;
import com.google.security.zynamics.zylib.net.NetHelpers;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class PostgresSQLDebuggerFunctions {
    private PostgresSQLDebuggerFunctions() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DebuggerTemplate createDebuggerTemplate(AbstractSQLProvider provider, String name, String host, int port) throws CouldntSaveDataException {
        Preconditions.checkNotNull(name, "IE00417: Debugger names can not be null");
        Preconditions.checkArgument(!name.isEmpty(), "IE00418: Debugger names can not be empty");
        Preconditions.checkNotNull(host, "IE00419: Debugger host can not be null");
        Preconditions.checkArgument(!host.isEmpty(), "IE00418: Debugger host can not be empty");
        Preconditions.checkArgument(port > 0 && port <= 65535, "IE00421: Debugger port is out of bounds");
        NaviLogger.info("Creating new debugger %s (%s:%d)", name, host, port);
        CConnection connection = provider.getConnection();
        String query = "INSERT INTO bn_debuggers(name, host, port) VALUES(?, ?, ?) RETURNING id";
        try (PreparedStatement statement = connection.getConnection().prepareStatement("INSERT INTO bn_debuggers(name, host, port) VALUES(?, ?, ?) RETURNING id");){
            statement.setString(1, name);
            statement.setString(2, host);
            statement.setInt(3, port);
            int id = -1;
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    id = resultSet.getInt("id");
                }
            }
            DebuggerTemplate debuggerTemplate = new DebuggerTemplate(id, name, host, port, provider);
            return debuggerTemplate;
        }
        catch (SQLException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public static void deleteDebugger(AbstractSQLProvider provider, DebuggerTemplate debugger) throws CouldntDeleteException {
        Preconditions.checkNotNull(debugger, "IE00709: Debugger template argument can not be null");
        Preconditions.checkArgument(debugger.inSameDatabase(provider), "IE00710: Debugger template is not part of this database");
        NaviLogger.info("Deleting debugger %d", debugger.getId());
        PostgreSQLHelpers.deleteById(provider.getConnection(), "bn_debuggers", debugger.getId());
    }

    public static void loadDebuggers(AbstractSQLProvider provider, DebuggerTemplateManager manager) throws CouldntLoadDataException {
        CConnection connection = provider.getConnection();
        String query = "SELECT * FROM bn_debuggers";
        try (ResultSet resultSet = connection.executeQuery("SELECT * FROM bn_debuggers", true);){
            while (resultSet.next()) {
                DebuggerTemplate debugger = new DebuggerTemplate(resultSet.getInt("id"), PostgreSQLHelpers.readString(resultSet, "name"), PostgreSQLHelpers.readString(resultSet, "host"), resultSet.getInt("port"), provider);
                manager.addDebugger(debugger);
            }
        }
        catch (SQLException e2) {
            throw new CouldntLoadDataException(e2);
        }
    }

    public static void setHost(AbstractSQLProvider provider, DebuggerTemplate debugger, String host) throws CouldntSaveDataException {
        Preconditions.checkNotNull(debugger, "IE00422: Debugger argument can not be null");
        Preconditions.checkNotNull(host, "IE00423: Host argument can not be null");
        Preconditions.checkArgument(debugger.inSameDatabase(provider), "IE00424: Debugger is not part of this database");
        String query = "UPDATE bn_debuggers SET host = ? WHERE id = ?";
        try (PreparedStatement statement = provider.getConnection().getConnection().prepareStatement("UPDATE bn_debuggers SET host = ? WHERE id = ?");){
            statement.setString(1, host);
            statement.setInt(2, debugger.getId());
            statement.executeUpdate();
        }
        catch (SQLException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public static void setName(AbstractSQLProvider provider, DebuggerTemplate debugger, String name) throws CouldntSaveDataException {
        Preconditions.checkNotNull(debugger, "IE00425: Debugger argument can not be null");
        Preconditions.checkNotNull(name, "IE00426: Name argument can not be null");
        Preconditions.checkArgument(debugger.inSameDatabase(provider), "IE00427: Debugger is not part of this database");
        String query = "UPDATE bn_debuggers SET name = ? WHERE id = ?";
        try (PreparedStatement statement = provider.getConnection().getConnection().prepareStatement("UPDATE bn_debuggers SET name = ? WHERE id = ?");){
            statement.setString(1, name);
            statement.setInt(2, debugger.getId());
            statement.executeUpdate();
        }
        catch (SQLException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public static void setPort(AbstractSQLProvider provider, DebuggerTemplate debugger, int port) throws CouldntSaveDataException {
        Preconditions.checkNotNull(debugger, "IE00428: Debugger argument can not be null");
        Preconditions.checkArgument(NetHelpers.isValidPort(port), "IE00429: Invalid port argument");
        Preconditions.checkArgument(debugger.inSameDatabase(provider), "IE00430: Debugger is not part of this database");
        String query = "UPDATE bn_debuggers SET port = ? WHERE id = ?";
        try (PreparedStatement statement = provider.getConnection().getConnection().prepareStatement("UPDATE bn_debuggers SET port = ? WHERE id = ?");){
            statement.setInt(1, port);
            statement.setInt(2, debugger.getId());
            statement.executeUpdate();
        }
        catch (SQLException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }
}

