/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLCommentFunctions;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.PostgreSQLHelpers;
import com.google.security.zynamics.binnavi.Database.PostgreSQLProvider;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.types.BaseType;
import com.google.security.zynamics.binnavi.disassembly.types.BaseTypeCategory;
import com.google.security.zynamics.binnavi.disassembly.types.RawBaseType;
import com.google.security.zynamics.binnavi.disassembly.types.RawTypeInstance;
import com.google.security.zynamics.binnavi.disassembly.types.RawTypeInstanceReference;
import com.google.security.zynamics.binnavi.disassembly.types.RawTypeMember;
import com.google.security.zynamics.binnavi.disassembly.types.RawTypeSubstitution;
import com.google.security.zynamics.binnavi.disassembly.types.TypeMember;
import com.google.security.zynamics.binnavi.disassembly.types.TypeSubstitution;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class PostgreSQLTypeFunctions {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer appendTypeInstanceComment(SQLProvider provider, int moduleId, int instanceId, String commentText, Integer userId) throws CouldntSaveDataException {
        Integer n2;
        Preconditions.checkArgument(moduleId > 0, "Error: module id must be greater then zero");
        Preconditions.checkArgument(instanceId >= 0, "instance id must be greater or equal to zero");
        Preconditions.checkNotNull(commentText, "Error: comment text argument can not be null");
        Preconditions.checkNotNull(userId, "Error: user id argument can not be null");
        CConnection connection = provider.getConnection();
        String function = " { ? = call append_type_instance_comment(?, ?, ?, ?) } ";
        CallableStatement appendCommentFunction = connection.getConnection().prepareCall(" { ? = call append_type_instance_comment(?, ?, ?, ?) } ");
        try {
            appendCommentFunction.registerOutParameter(1, 4);
            appendCommentFunction.setInt(2, moduleId);
            appendCommentFunction.setInt(3, instanceId);
            appendCommentFunction.setInt(4, (int)userId);
            appendCommentFunction.setString(5, commentText);
            appendCommentFunction.execute();
            int commentId = appendCommentFunction.getInt(1);
            if (appendCommentFunction.wasNull()) {
                throw new CouldntSaveDataException("Error: Got an comment id of null from the database");
            }
            n2 = commentId;
        }
        catch (Throwable throwable) {
            try {
                appendCommentFunction.close();
                throw throwable;
            }
            catch (SQLException exception) {
                throw new CouldntSaveDataException(exception);
            }
        }
        appendCommentFunction.close();
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final int createType(Connection connection, int moduleId, String name, int size, Integer childPointerTypeId, boolean signed, BaseTypeCategory category) throws CouldntSaveDataException {
        try {
            String query = String.format("INSERT INTO %s (module_id, id, name, size, pointer, signed, category) VALUES (?, nextval('bn_base_types_id_seq'), ?, ?, ?, ?, ?) returning id", "bn_base_types");
            try (PreparedStatement statement = connection.prepareStatement(query);){
                statement.setInt(1, moduleId);
                statement.setString(2, name);
                statement.setInt(3, size);
                if (childPointerTypeId == null) {
                    statement.setNull(4, 4);
                } else {
                    statement.setInt(4, childPointerTypeId);
                }
                statement.setBoolean(5, signed);
                statement.setObject(6, (Object)category.toString(), 1111);
                ResultSet resultSet = statement.executeQuery();
                if (!resultSet.next()) throw new CouldntSaveDataException("Empty result set while inserting base type.");
                int n2 = resultSet.getInt(1);
                return n2;
            }
        }
        catch (SQLException exception) {
            throw new CouldntSaveDataException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int createTypeInstance(Connection connection, int moduleId, String name, Integer commentId, int typeId, int sectionId, long sectionOffset) throws CouldntSaveDataException {
        int n2;
        Preconditions.checkNotNull(connection, "Error: connection argument can not be null");
        Preconditions.checkArgument(moduleId > 0, "Error: module id must be greater than zero");
        Preconditions.checkNotNull(name, "Error: name argument can not be null");
        Preconditions.checkArgument(typeId >= 0, "Error: type id must be greater than zero");
        Preconditions.checkArgument(sectionId >= 0, "Error: section id must be larger than zero");
        Preconditions.checkArgument(sectionOffset >= 0L, "Error: section offset must be larger or equal to zero");
        String query = " { ? = call create_type_instance(?, ?, ?, ?, ?, ?) } ";
        CallableStatement procedure = connection.prepareCall(" { ? = call create_type_instance(?, ?, ?, ?, ?, ?) } ");
        try {
            procedure.registerOutParameter(1, 4);
            procedure.setInt(2, moduleId);
            procedure.setString(3, name);
            if (commentId == null) {
                procedure.setNull(4, 4);
            } else {
                procedure.setInt(4, (int)commentId);
            }
            procedure.setInt(5, typeId);
            procedure.setInt(6, sectionId);
            procedure.setLong(7, sectionOffset);
            procedure.execute();
            int typeInstanceId = procedure.getInt(1);
            if (procedure.wasNull()) {
                throw new CouldntSaveDataException("Error: the type instance id returned from the database was null");
            }
            n2 = typeInstanceId;
        }
        catch (Throwable throwable) {
            try {
                procedure.close();
                throw throwable;
            }
            catch (SQLException exception) {
                throw new CouldntSaveDataException(exception);
            }
        }
        procedure.close();
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTypeInstanceReference(Connection connection, int moduleId, long address, int position, int expressionId, int typeInstanceId) throws CouldntSaveDataException {
        Preconditions.checkNotNull(connection, "Error: connection argument can not be null");
        Preconditions.checkArgument(moduleId > 0, "Error: module id must be greater than zero");
        Preconditions.checkArgument(position >= 0, "Error: position must be larger or equal to zero");
        Preconditions.checkArgument(expressionId > 0, "Error: expression id must be larger or equal to zero");
        Preconditions.checkArgument(typeInstanceId >= 0, "Error: type instance id must be larger or equal to zero");
        String query = " { call create_expression_type_instance(?, ?, ?, ?, ?) } ";
        try (CallableStatement procedure = connection.prepareCall(" { call create_expression_type_instance(?, ?, ?, ?, ?) } ");){
            procedure.setInt(1, moduleId);
            procedure.setLong(2, address);
            procedure.setInt(3, position);
            procedure.setInt(4, expressionId);
            procedure.setInt(5, typeInstanceId);
            procedure.execute();
        }
        catch (SQLException exception) {
            throw new CouldntSaveDataException(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int createTypeMember(Connection connection, int containingTypeId, Optional<Integer> offset, String name, int baseTypeId, Optional<Integer> numberOfElements, INaviModule module) throws CouldntSaveDataException {
        try {
            String query = String.format("INSERT INTO %s (module_id, id, name, base_type, parent_id, \"offset\", argument, number_of_elements) VALUES (?, nextval('bn_types_id_seq'), ?, ?, ?, ?, NULL, ?) returning id", "bn_types");
            try (PreparedStatement statement = connection.prepareStatement(query);){
                statement.setInt(1, module.getConfiguration().getId());
                statement.setString(2, name);
                statement.setInt(3, baseTypeId);
                statement.setInt(4, containingTypeId);
                if (offset.isPresent()) {
                    statement.setInt(5, offset.get());
                } else {
                    statement.setNull(5, 4);
                }
                if (numberOfElements.isPresent()) {
                    statement.setInt(6, numberOfElements.get());
                } else {
                    statement.setNull(6, 4);
                }
                ResultSet resultSet = statement.executeQuery();
                if (!resultSet.next()) throw new CouldntSaveDataException("Empty result set while inserting type member.");
                int n2 = resultSet.getInt(1);
                return n2;
            }
        }
        catch (SQLException exception) {
            throw new CouldntSaveDataException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTypeSubstitution(Connection connection, int treeNodeId, int baseTypeId, List<Integer> memberPath, int position, int offset, IAddress address, INaviModule module) throws CouldntSaveDataException {
        try {
            String query = String.format("INSERT INTO %s (module_id, address, \"position\", \"offset\", expression_id, path, base_type_id) VALUES (?, ?, ?, ?, ?, ?, ?)", "bn_expression_types");
            try (PreparedStatement statement = connection.prepareStatement(query);){
                statement.setInt(1, module.getConfiguration().getId());
                statement.setLong(2, address.toLong());
                statement.setInt(3, position);
                statement.setInt(4, offset);
                statement.setInt(5, treeNodeId);
                statement.setArray(6, connection.createArrayOf("int4", memberPath.toArray()));
                statement.setInt(7, baseTypeId);
                statement.executeUpdate();
            }
        }
        catch (SQLException exception) {
            throw new CouldntSaveDataException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteMember(Connection connection, TypeMember member, INaviModule module) throws CouldntDeleteException {
        try (CallableStatement statement = connection.prepareCall("{ call delete_type(?, ?) }");){
            statement.setInt(1, module.getConfiguration().getId());
            statement.setInt(2, member.getId());
            statement.execute();
        }
        catch (SQLException exception) {
            throw new CouldntDeleteException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteType(Connection connection, BaseType baseType, INaviModule module) throws CouldntDeleteException {
        try (PreparedStatement statement = connection.prepareStatement("DELETE FROM bn_base_types WHERE module_id = ? AND id = ?");){
            statement.setInt(1, module.getConfiguration().getId());
            statement.setInt(2, baseType.getId());
            statement.executeUpdate();
        }
        catch (SQLException exception) {
            throw new CouldntDeleteException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteTypeInstance(PostgreSQLProvider provider, int moduleId, int typeInstanceId) throws CouldntDeleteException {
        Preconditions.checkNotNull(provider, "Error: provider argument can not be null");
        Preconditions.checkArgument(moduleId > 0, "Error: module id must be larger then zero");
        Preconditions.checkArgument(typeInstanceId >= 0, "Error: type instance id must be larger or equal to zero");
        String function = " { call delete_type_instance(?, ?) } ";
        try (CallableStatement deleteCommentStatement = provider.getConnection().getConnection().prepareCall(" { call delete_type_instance(?, ?) } ");){
            deleteCommentStatement.setInt(1, moduleId);
            deleteCommentStatement.setInt(2, typeInstanceId);
            deleteCommentStatement.execute();
        }
        catch (SQLException exception) {
            throw new CouldntDeleteException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteTypeInstanceComment(SQLProvider provider, int moduleId, int instanceId, Integer commentId, Integer userId) throws CouldntDeleteException {
        Preconditions.checkArgument(moduleId > 0, "Error: module id must be greater then zero");
        Preconditions.checkArgument(instanceId >= 0, "Error: instance id must be greater or equal to zero");
        Preconditions.checkNotNull(commentId, "Error: comment text argument can not be null");
        Preconditions.checkNotNull(userId, "Error: user id argument can not be null");
        String function = " { ? = call delete_type_instance_comment(?, ?, ?, ?) } ";
        try (CallableStatement deleteCommentStatement = provider.getConnection().getConnection().prepareCall(" { ? = call delete_type_instance_comment(?, ?, ?, ?) } ");){
            deleteCommentStatement.registerOutParameter(1, 4);
            deleteCommentStatement.setInt(2, moduleId);
            deleteCommentStatement.setInt(3, instanceId);
            deleteCommentStatement.setInt(4, (int)commentId);
            deleteCommentStatement.setInt(5, (int)userId);
            deleteCommentStatement.execute();
            deleteCommentStatement.getInt(1);
            if (deleteCommentStatement.wasNull()) {
                throw new IllegalArgumentException("Error: The comment id returned from the database was null.");
            }
        }
        catch (SQLException exception) {
            throw new CouldntDeleteException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteTypeInstanceReference(PostgreSQLProvider provider, int moduleId, BigInteger address, int position, int expressionId) throws CouldntDeleteException {
        Preconditions.checkNotNull(provider, "Error: provider argument can not be null");
        Preconditions.checkArgument(moduleId > 0, "Error: module id must be larger then zero");
        Preconditions.checkNotNull(address, "Error: address argument can not be null");
        Preconditions.checkArgument(position >= 0, "Error: position must be larger or equal to zero");
        Preconditions.checkArgument(expressionId >= 0, "Error: expression id must be larger or equal to zero");
        String function = " { call delete_expression_type_instance(?, ?, ?, ?) } ";
        try (CallableStatement deleteCommentStatement = provider.getConnection().getConnection().prepareCall(" { call delete_expression_type_instance(?, ?, ?, ?) } ");){
            deleteCommentStatement.setInt(1, moduleId);
            deleteCommentStatement.setObject(2, (Object)address, 1111);
            deleteCommentStatement.setInt(3, position);
            deleteCommentStatement.setInt(4, expressionId);
            deleteCommentStatement.execute();
        }
        catch (SQLException exception) {
            throw new CouldntDeleteException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteTypeSubstitution(Connection connection, INaviModule module, TypeSubstitution typeSubstitution) throws CouldntDeleteException {
        try (PreparedStatement statement = connection.prepareStatement("DELETE FROM bn_expression_types WHERE module_id = ? AND address = ? AND \"position\" = ? AND expression_id = ?");){
            statement.setInt(1, module.getConfiguration().getId());
            statement.setLong(2, typeSubstitution.getAddress().toLong());
            statement.setInt(3, typeSubstitution.getPosition());
            statement.setInt(4, typeSubstitution.getExpressionId());
            statement.executeUpdate();
        }
        catch (SQLException exception) {
            throw new CouldntDeleteException(exception);
        }
    }

    public static void editTypeInstanceComment(SQLProvider provider, int moduleId, Integer commentId, Integer userId, String commentText) throws CouldntSaveDataException {
        Preconditions.checkNotNull(provider, "Error: provider argument can not be null");
        Preconditions.checkArgument(moduleId > 0, "Error: module id must be greater then zero");
        Preconditions.checkNotNull(commentId, "Error: commentId argument can not be null");
        Preconditions.checkNotNull(userId, "Error: userId argument can not be null");
        Preconditions.checkNotNull(commentText, "Error: commentText argument can not be null");
        PostgreSQLCommentFunctions.editComment(provider, commentId, userId, commentText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RawBaseType loadRawBaseType(SQLProvider provider, INaviModule module, Integer baseTypeId) throws CouldntLoadDataException {
        Preconditions.checkNotNull(provider, "Error: provider argument can not be null.");
        Preconditions.checkNotNull(module, "Error: module argument can not be null.");
        Preconditions.checkNotNull(baseTypeId, "Error: baseTypeId argument can not be null.");
        String query = " SELECT * FROM load_type(?, ?) ";
        try {
            PreparedStatement statement = provider.getConnection().getConnection().prepareStatement(" SELECT * FROM load_type(?, ?) ", 1004, 1007);
            statement.setInt(1, module.getConfiguration().getId());
            statement.setInt(2, baseTypeId);
            ResultSet resultSet = statement.executeQuery();
            try {
                do {
                    if (!resultSet.next()) throw new CouldntLoadDataException("Error: could not load single base type from the database.");
                } while (!resultSet.first());
                Integer pointer = resultSet.getInt("pointer");
                if (resultSet.wasNull()) {
                    pointer = null;
                }
                RawBaseType rawBaseType = new RawBaseType(resultSet.getInt("id"), resultSet.getString("name"), resultSet.getInt("size"), pointer, resultSet.getBoolean("signed"), BaseTypeCategory.fromString(resultSet.getString("category")));
                return rawBaseType;
            }
            finally {
                resultSet.close();
                statement.close();
            }
        }
        catch (SQLException exception) {
            throw new CouldntLoadDataException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RawTypeInstance loadRawTypeInstance(SQLProvider provider, INaviModule module, Integer typeInstanceId) throws CouldntLoadDataException {
        Preconditions.checkNotNull(provider, "Error: provider argument can not be null");
        Preconditions.checkNotNull(module, "Error: module argument can not be null");
        Preconditions.checkNotNull(typeInstanceId, "Error: typeInstanceId argument can not be null");
        String query = " SELECT * FROM load_type_instance(?, ?) ";
        try {
            PreparedStatement statement = provider.getConnection().getConnection().prepareStatement(" SELECT * FROM load_type_instance(?, ?) ", 1004, 1007);
            statement.setInt(1, module.getConfiguration().getId());
            statement.setInt(2, typeInstanceId);
            ResultSet resultSet = statement.executeQuery();
            try {
                do {
                    if (!resultSet.next()) throw new CouldntLoadDataException("Error: could not load singe type instance from the database.");
                } while (!resultSet.first());
                int moduleId = resultSet.getInt("module_id");
                int id = resultSet.getInt("id");
                String name = resultSet.getString("name");
                int commentId = resultSet.getInt("comment_id");
                int typeId = resultSet.getInt("type_id");
                int sectionId = resultSet.getInt("section_id");
                long sectionOffset = resultSet.getLong("section_offset");
                RawTypeInstance rawTypeInstance = new RawTypeInstance(moduleId, id, name, commentId, typeId, sectionId, sectionOffset);
                return rawTypeInstance;
            }
            finally {
                resultSet.close();
                statement.close();
            }
        }
        catch (SQLException exception) {
            throw new CouldntLoadDataException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RawTypeInstanceReference loadRawTypeInstanceReference(SQLProvider provider, INaviModule module, Integer typeInstanceId, BigInteger address, Integer position, Integer expressionId) throws CouldntLoadDataException {
        Preconditions.checkNotNull(provider, "Error: provider argument can not be null");
        Preconditions.checkNotNull(module, "Error: module argument can not be null");
        Preconditions.checkNotNull(typeInstanceId, "Error: typeInstanceId argument can not be null");
        Preconditions.checkNotNull(address, "Error: address argument can not be null");
        Preconditions.checkNotNull(position, "Error: position argument can not be null");
        Preconditions.checkNotNull(expressionId, "Error: expressionId argument can not be null");
        String query = " SELECT * FROM load_expression_type_instance(?, ?, ?, ?, ?) ";
        try {
            PreparedStatement statement = provider.getConnection().getConnection().prepareStatement(" SELECT * FROM load_expression_type_instance(?, ?, ?, ?, ?) ", 1004, 1007);
            statement.setInt(1, module.getConfiguration().getId());
            statement.setInt(2, typeInstanceId);
            statement.setObject(3, (Object)address, -5);
            statement.setInt(4, position);
            statement.setInt(5, expressionId);
            ResultSet resultSet = statement.executeQuery();
            try {
                do {
                    if (!resultSet.next()) throw new CouldntLoadDataException("Error: could not load single cross reference from the database.");
                } while (!resultSet.isFirst());
                int viewId = resultSet.getInt("view_id");
                int moduleId = resultSet.getInt("module_id");
                RawTypeInstanceReference rawTypeInstanceReference = new RawTypeInstanceReference(moduleId, viewId, new CAddress(address), position, expressionId, typeInstanceId);
                return rawTypeInstanceReference;
            }
            finally {
                resultSet.close();
                statement.close();
            }
        }
        catch (SQLException exception) {
            throw new CouldntLoadDataException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<RawTypeInstanceReference> loadRawTypeInstanceReferences(Connection connection, INaviModule module) throws CouldntLoadDataException {
        ArrayList<RawTypeInstanceReference> rawReferences = Lists.newArrayList();
        String query = " SELECT * FROM load_expression_type_instances(?) ";
        try {
            statement.setInt(1, module.getConfiguration().getId());
            try (PreparedStatement statement = connection.prepareStatement(" SELECT * FROM load_expression_type_instances(?) ");){
                ResultSet resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    int viewId = resultSet.getInt("view_id");
                    int moduleId = resultSet.getInt("module_id");
                    IAddress address = PostgreSQLHelpers.loadAddress(resultSet, "address");
                    int position = resultSet.getInt("position");
                    int expressionId = resultSet.getInt("expression_id");
                    int typeInstanceId = resultSet.getInt("type_instance_id");
                    rawReferences.add(new RawTypeInstanceReference(moduleId, viewId, address, position, expressionId, typeInstanceId));
                }
            }
        }
        catch (SQLException exception) {
            throw new CouldntLoadDataException(exception);
        }
        return rawReferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<RawTypeInstance> loadRawTypeInstances(Connection connection, INaviModule module) throws CouldntLoadDataException {
        ArrayList<RawTypeInstance> instances = new ArrayList<RawTypeInstance>();
        try {
            String query = "SELECT * FROM load_type_instances(?)";
            statement.setInt(1, module.getConfiguration().getId());
            try (PreparedStatement statement = connection.prepareStatement("SELECT * FROM load_type_instances(?)");){
                ResultSet result = statement.executeQuery();
                while (result.next()) {
                    int id = result.getInt("id");
                    String name = result.getString("name");
                    Integer commentId = result.getInt("comment_id");
                    if (result.wasNull()) {
                        commentId = null;
                    }
                    int typeId = result.getInt("type_id");
                    int sectionId = result.getInt("section_id");
                    long sectionOffset = result.getLong("section_offset");
                    instances.add(new RawTypeInstance(module.getConfiguration().getId(), id, name, commentId, typeId, sectionId, sectionOffset));
                }
            }
        }
        catch (SQLException exception) {
            throw new CouldntLoadDataException(exception);
        }
        return instances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RawTypeMember loadRawTypeMember(SQLProvider provider, INaviModule module, Integer typeId) throws CouldntLoadDataException {
        Preconditions.checkNotNull(provider, "Error: provider argument can not be null");
        Preconditions.checkNotNull(module, "Error: module argument can not be null");
        Preconditions.checkNotNull(typeId, "Error: typeId argument can not be null");
        String query = " SELECT * FROM load_type_member(?, ?) ";
        try {
            PreparedStatement statement = provider.getConnection().getConnection().prepareStatement(" SELECT * FROM load_type_member(?, ?) ", 1004, 1007);
            statement.setInt(1, module.getConfiguration().getId());
            statement.setInt(2, typeId);
            ResultSet resultSet = statement.executeQuery();
            try {
                do {
                    if (!resultSet.next()) throw new CouldntLoadDataException("Error: could not load single type member from the database.");
                } while (!resultSet.first());
                int id = resultSet.getInt("id");
                String name = resultSet.getString("name");
                int baseTypeId = resultSet.getInt("base_type");
                Integer parentId = resultSet.getInt("parent_id");
                Integer offset = resultSet.getInt("offset");
                if (resultSet.wasNull()) {
                    offset = null;
                }
                Integer argument = resultSet.getInt("argument");
                if (resultSet.wasNull()) {
                    argument = null;
                }
                Integer numberOfElements = resultSet.getInt("number_of_elements");
                if (resultSet.wasNull()) {
                    numberOfElements = null;
                }
                RawTypeMember rawTypeMember = new RawTypeMember(id, name, baseTypeId, parentId, offset, argument, numberOfElements);
                return rawTypeMember;
            }
            finally {
                resultSet.close();
                statement.close();
            }
        }
        catch (SQLException exception) {
            throw new CouldntLoadDataException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<RawTypeMember> loadRawTypeMembers(Connection connection, INaviModule module) throws CouldntLoadDataException {
        Preconditions.checkNotNull(connection, "Error: connection argument can not be null");
        Preconditions.checkNotNull(module, "Error: module argument can not be null");
        ArrayList<RawTypeMember> rawMembers = new ArrayList<RawTypeMember>();
        String query = " SELECT * FROM load_type_members(?) ";
        try {
            PreparedStatement statement = connection.prepareStatement(" SELECT * FROM load_type_members(?) ");
            statement.setInt(1, module.getConfiguration().getId());
            ResultSet results = statement.executeQuery();
            try {
                while (results.next()) {
                    Integer parentId = results.getInt("parent_id");
                    if (results.wasNull()) continue;
                    Integer argument = results.getInt("argument");
                    if (results.wasNull()) {
                        argument = null;
                    }
                    Integer offset = results.getInt("offset");
                    if (results.wasNull()) {
                        offset = null;
                    }
                    Integer numberOfElements = results.getInt("number_of_elements");
                    if (results.wasNull()) {
                        numberOfElements = null;
                    }
                    rawMembers.add(new RawTypeMember(results.getInt("id"), results.getString("name"), results.getInt("base_type"), parentId, offset, argument, numberOfElements));
                }
            }
            finally {
                results.close();
                statement.close();
            }
        }
        catch (SQLException exception) {
            throw new CouldntLoadDataException(exception);
        }
        return rawMembers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<RawBaseType> loadRawTypes(Connection connection, INaviModule module) throws CouldntLoadDataException {
        String query = " SELECT * FROM load_types(?) ";
        ArrayList<RawBaseType> rawTypes = new ArrayList<RawBaseType>();
        try {
            PreparedStatement statement = connection.prepareStatement(" SELECT * FROM load_types(?) ");
            statement.setInt(1, module.getConfiguration().getId());
            ResultSet results = statement.executeQuery();
            try {
                while (results.next()) {
                    Integer pointer = results.getInt("pointer");
                    if (results.wasNull()) {
                        pointer = null;
                    }
                    rawTypes.add(new RawBaseType(results.getInt("id"), results.getString("name"), results.getInt("size"), pointer, results.getBoolean("signed"), BaseTypeCategory.fromString(results.getString("category"))));
                }
            }
            finally {
                results.close();
                statement.close();
            }
        }
        catch (SQLException exception) {
            throw new CouldntLoadDataException(exception);
        }
        return rawTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RawTypeSubstitution loadRawTypeSubstitution(SQLProvider provider, INaviModule module, BigInteger address, Integer position, Integer expressionId) throws CouldntLoadDataException {
        Preconditions.checkNotNull(provider, "Error: provider argument can not be null");
        Preconditions.checkNotNull(module, "Error: module argument can not be null");
        Preconditions.checkNotNull(address, "Error: address argument can not be null");
        Preconditions.checkNotNull(position, "Error: position argument can not be null");
        Preconditions.checkNotNull(expressionId, "Error: expressionId argument can not be null");
        String query = " SELECT * FROM load_type_substitution(?, ?, ?, ?) ";
        try {
            PreparedStatement statement = provider.getConnection().getConnection().prepareStatement(" SELECT * FROM load_type_substitution(?, ?, ?, ?) ", 1004, 1007);
            statement.setInt(1, module.getConfiguration().getId());
            statement.setObject(2, (Object)address, -5);
            statement.setInt(3, position);
            statement.setInt(4, expressionId);
            ResultSet resultSet = statement.executeQuery();
            try {
                do {
                    if (!resultSet.next()) throw new CouldntLoadDataException("Error: could not load single type substitution from the database.");
                } while (!resultSet.first());
                int baseTypeId = resultSet.getInt("base_type_id");
                Array arr = resultSet.getArray("path");
                Integer[] path = resultSet.wasNull() ? new Integer[]{} : (Integer[])arr.getArray();
                Integer offset = resultSet.getInt("offset");
                if (resultSet.wasNull()) {
                    offset = null;
                }
                RawTypeSubstitution rawTypeSubstitution = new RawTypeSubstitution(new CAddress(address), position, expressionId, baseTypeId, path, offset);
                return rawTypeSubstitution;
            }
            finally {
                resultSet.close();
                statement.close();
            }
        }
        catch (SQLException exception) {
            throw new CouldntLoadDataException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<RawTypeSubstitution> loadRawTypeSubstitutions(Connection connection, INaviModule module) throws CouldntLoadDataException {
        Preconditions.checkNotNull(connection, "Error: connection argument can not be null");
        Preconditions.checkNotNull(module, "Error: module argument can not be null");
        String query = " SELECT * FROM load_type_substitutions(?) ";
        ArrayList<RawTypeSubstitution> rawSubstitutions = new ArrayList<RawTypeSubstitution>();
        try {
            PreparedStatement statement = connection.prepareStatement(" SELECT * FROM load_type_substitutions(?) ");
            statement.setInt(1, module.getConfiguration().getId());
            ResultSet results = statement.executeQuery();
            try {
                while (results.next()) {
                    long address = results.getLong("address");
                    int position = results.getInt("position");
                    int expressionId = results.getInt("expression_id");
                    int baseTypeId = results.getInt("base_type_id");
                    Array arr = results.getArray("path");
                    Integer[] path = (Integer[])arr.getArray();
                    if (results.wasNull()) {
                        path = new Integer[]{};
                    }
                    Integer offset = results.getInt("offset");
                    if (results.wasNull()) {
                        offset = null;
                    }
                    rawSubstitutions.add(new RawTypeSubstitution(new CAddress(address), position, expressionId, baseTypeId, path, offset));
                }
            }
            finally {
                results.close();
                statement.close();
            }
        }
        catch (SQLException exception) {
            throw new CouldntLoadDataException(exception);
        }
        return rawSubstitutions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTypeInstanceName(PostgreSQLProvider provider, int moduleId, int id, String name) throws CouldntSaveDataException {
        Preconditions.checkNotNull(provider, "Error: provider argument can not be null");
        Preconditions.checkArgument(moduleId > 0, "Error: module id must be larger then zero");
        Preconditions.checkArgument(id >= 0, "Error: type instance id must be larger or equal to zero");
        Preconditions.checkNotNull(name, "Error: name argument can not be null");
        String function = " { call set_type_instance_name(?, ?, ?) } ";
        try (CallableStatement setTypeInstanceNameStatement = provider.getConnection().getConnection().prepareCall(" { call set_type_instance_name(?, ?, ?) } ");){
            setTypeInstanceNameStatement.setInt(1, moduleId);
            setTypeInstanceNameStatement.setInt(2, id);
            setTypeInstanceNameStatement.setString(3, name);
            setTypeInstanceNameStatement.execute();
        }
        catch (SQLException exception) {
            throw new CouldntSaveDataException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateMemberOffsets(Connection connection, List<Integer> members, int delta, List<Integer> implicitlyUpdatedMembers, int implicitDelta, INaviModule module) throws CouldntSaveDataException {
        try (CallableStatement statement = connection.prepareCall("{ call update_member_offsets(?, ?, ?, ?, ?) }");){
            statement.setInt(1, module.getConfiguration().getId());
            statement.setArray(2, connection.createArrayOf("int4", members.toArray()));
            statement.setInt(3, delta);
            statement.setArray(4, connection.createArrayOf("int4", implicitlyUpdatedMembers.toArray()));
            statement.setInt(5, implicitDelta);
            statement.execute();
        }
        catch (SQLException exception) {
            throw new CouldntSaveDataException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateType(Connection connection, BaseType baseType, String name, int size, boolean isSigned, INaviModule module) throws CouldntSaveDataException {
        try (PreparedStatement statement = connection.prepareStatement("UPDATE bn_base_types SET name = ?, size = ?, signed = ? WHERE module_id = ? AND id = ?");){
            statement.setString(1, name);
            statement.setInt(2, size);
            statement.setBoolean(3, isSigned);
            statement.setInt(4, module.getConfiguration().getId());
            statement.setInt(5, baseType.getId());
            statement.executeUpdate();
        }
        catch (SQLException exception) {
            throw new CouldntSaveDataException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateTypeMember(Connection connection, TypeMember member, String newName, BaseType newBaseType, Optional<Integer> offset, Optional<Integer> newNumberOfElements, Optional<Integer> newArgumentIndex, INaviModule module) throws CouldntSaveDataException {
        Preconditions.checkNotNull(member, "Error: member argument can not be null.");
        Preconditions.checkNotNull(newName, "Error: new name argument can not be null");
        Preconditions.checkNotNull(newBaseType, "Error: new base type argument can not be null.");
        Preconditions.checkNotNull(offset, "Error: offset argument can not be null");
        Preconditions.checkNotNull(newNumberOfElements, "Error: new number of elements argument can not be null.");
        Preconditions.checkNotNull(newArgumentIndex, "Error: new argument index argument can not be null.");
        try (PreparedStatement statement = connection.prepareStatement("UPDATE bn_types SET name = ?, base_type = ?, parent_id = ?, \"offset\" = ?, number_of_elements = ?, argument = ? WHERE module_id = ? AND id = ?");){
            statement.setString(1, newName);
            statement.setInt(2, newBaseType.getId());
            statement.setInt(3, member.getParentType().getId());
            if (offset.isPresent()) {
                statement.setInt(4, offset.get());
            } else {
                statement.setNull(4, 4);
            }
            if (newNumberOfElements.isPresent()) {
                statement.setInt(5, newNumberOfElements.get());
            } else {
                statement.setNull(5, 4);
            }
            if (newArgumentIndex.isPresent()) {
                statement.setInt(6, newArgumentIndex.get());
            } else {
                statement.setNull(6, 4);
            }
            statement.setInt(7, module.getConfiguration().getId());
            statement.setInt(8, member.getId());
            statement.executeUpdate();
        }
        catch (SQLException exception) {
            throw new CouldntSaveDataException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateTypeSubstitution(Connection connection, TypeSubstitution substitution, BaseType baseType, List<Integer> memberPath, int position, int offset, INaviModule module) throws CouldntSaveDataException {
        try (PreparedStatement statement = connection.prepareStatement("UPDATE bn_expression_types SET base_type_id = ?, \"position\" = ?, \"offset\" = ?, path = ? WHERE module_id = ? AND expression_id = ? AND address = ?");){
            statement.setInt(1, baseType.getId());
            statement.setInt(2, position);
            statement.setInt(3, offset);
            statement.setArray(4, connection.createArrayOf("int4", memberPath.toArray()));
            statement.setInt(5, module.getConfiguration().getId());
            statement.setInt(6, substitution.getExpressionId());
            statement.setLong(7, substitution.getAddress().toLong());
            statement.executeUpdate();
        }
        catch (SQLException exception) {
            throw new CouldntSaveDataException(exception);
        }
    }
}

