/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.AbstractSQLProvider;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.PostgreSQLHelpers;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceList;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceRegister;
import com.google.security.zynamics.binnavi.debug.models.trace.interfaces.ITraceEvent;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;

public final class PostgreSQLTraceFunctions {
    private PostgreSQLTraceFunctions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TraceList createTrace(AbstractSQLProvider provider, String tracesTable, String tracesColumn, String containerTable, int containerId, String name, String description) throws CouldntSaveDataException {
        Preconditions.checkNotNull(name, "IE00568: Name argument can not be null");
        Preconditions.checkNotNull(description, "IE00569: Description argument can not be null");
        CConnection connection = provider.getConnection();
        String query = "INSERT INTO bn_traces(view_id, name, description) VALUES(?, ?, ?) RETURNING id";
        try {
            Integer listId = null;
            try (PreparedStatement statement = connection.getConnection().prepareStatement("INSERT INTO bn_traces(view_id, name, description) VALUES(?, ?, ?) RETURNING id", 1004, 1007);){
                statement.setInt(1, 0);
                statement.setString(2, name);
                statement.setString(3, description);
                try (ResultSet resultSet = statement.executeQuery();){
                    while (resultSet.next()) {
                        if (!resultSet.isFirst()) continue;
                        listId = resultSet.getInt(1);
                    }
                }
            }
            String string2 = String.valueOf(listId);
            connection.executeUpdate(new StringBuilder(47 + String.valueOf(tracesTable).length() + String.valueOf(tracesColumn).length() + String.valueOf(string2).length()).append("INSERT INTO ").append(tracesTable).append("(").append(tracesColumn).append(", trace_id) ").append(" VALUES(").append(containerId).append(", ").append(string2).append(")").toString(), true);
            PostgreSQLHelpers.updateModificationDate(connection, containerTable, containerId);
            return new TraceList(listId, name, description, provider);
        }
        catch (SQLException exception) {
            throw new CouldntSaveDataException(exception);
        }
    }

    private static void saveEvents(CConnection connection, TraceList trace2) throws CouldntSaveDataException {
        String queryPrefix = "INSERT INTO bn_trace_events(trace_id, position, tid, module_id, address, type) VALUES";
        StringBuilder stringBuilder = new StringBuilder("INSERT INTO bn_trace_events(trace_id, position, tid, module_id, address, type) VALUES");
        int position = 0;
        for (ITraceEvent traceEvent : trace2) {
            String moduleString = traceEvent.getOffset().getModule() == null ? "null" : String.valueOf(traceEvent.getOffset().getModule().getConfiguration().getId());
            stringBuilder.append(String.format(Locale.ENGLISH, "(%d, %d, %d, %s, %s, %d)", trace2.getId(), position, traceEvent.getThreadId(), moduleString, traceEvent.getOffset().getAddress().getAddress().toBigInteger().toString(), 1));
            if (trace2.getEventCount() <= ++position) continue;
            stringBuilder.append(", ");
        }
        try (PreparedStatement prep = connection.getConnection().prepareStatement(stringBuilder.toString());){
            prep.execute();
        }
        catch (SQLException exception) {
            throw new CouldntSaveDataException(exception);
        }
    }

    public static TraceList createTrace(AbstractSQLProvider provider, INaviModule module, String name, String description) throws CouldntSaveDataException {
        Preconditions.checkNotNull(provider, "IE00570: Provider argument can not be null");
        Preconditions.checkNotNull(module, "IE00571: Module argument can not be null");
        Preconditions.checkNotNull(name, "IE02192: Name argument can not be null");
        Preconditions.checkNotNull(description, "IE02193: Description argument can not be null");
        Preconditions.checkArgument(module.inSameDatabase(provider), "IE00572: The given module is not part of this database");
        return PostgreSQLTraceFunctions.createTrace(provider, "bn_module_traces", "module_id", "bn_modules", module.getConfiguration().getId(), name, description);
    }

    public static TraceList createTrace(AbstractSQLProvider provider, INaviProject project, String name, String description) throws CouldntSaveDataException {
        Preconditions.checkNotNull(provider, "IE00573: Provider argument can not be null");
        Preconditions.checkNotNull(project, "IE00574: Project argument can not be null");
        Preconditions.checkNotNull(name, "IE00575: Name argument can not be null");
        Preconditions.checkNotNull(description, "IE02194: Description argument can not be null");
        return PostgreSQLTraceFunctions.createTrace(provider, "bn_project_traces", "project_id", "bn_projects", project.getConfiguration().getId(), name, description);
    }

    public static void deleteTrace(AbstractSQLProvider provider, TraceList trace2) throws CouldntDeleteException {
        Preconditions.checkNotNull(provider, "IE00576: Provider argument can not be null");
        Preconditions.checkNotNull(trace2, "IE00577: Trace argument can not be null");
        Preconditions.checkArgument(trace2.inSameDatabase(provider), "IE00578: Trace list is not part of this database");
        CConnection connection = provider.getConnection();
        String string2 = String.valueOf("DELETE FROM bn_traces WHERE id = ");
        int n2 = trace2.getId();
        String query = new StringBuilder(11 + String.valueOf(string2).length()).append(string2).append(n2).toString();
        try {
            connection.executeUpdate(query, true);
        }
        catch (SQLException e2) {
            throw new CouldntDeleteException(e2);
        }
    }

    public static void save(AbstractSQLProvider provider, TraceList trace2) throws CouldntSaveDataException {
        Preconditions.checkNotNull(provider, "IE00579: Provider argument can not be null");
        Preconditions.checkNotNull(trace2, "IE00580: List argument can not be null");
        Preconditions.checkArgument(trace2.inSameDatabase(provider), "IE00581: List is not part of this database");
        CConnection connection = provider.getConnection();
        if (trace2.getEventCount() != 0) {
            PostgreSQLTraceFunctions.saveEvents(connection, trace2);
            PostgreSQLTraceFunctions.saveEventValues(connection, trace2);
        }
    }

    public static void saveEventValues(CConnection connection, TraceList trace2) throws CouldntSaveDataException {
        Preconditions.checkNotNull(connection, "IE02412: connection argument can not be null");
        Preconditions.checkNotNull(trace2, "IE02413: trace argument can not be null");
        String query = "INSERT INTO bn_trace_event_values(trace_id, position, register_name, register_value, memory_value) VALUES (?, ?, ?, ?, ?)";
        try {
            PreparedStatement preparedStatement = connection.getConnection().prepareStatement("INSERT INTO bn_trace_event_values(trace_id, position, register_name, register_value, memory_value) VALUES (?, ?, ?, ?, ?)");
            int position = 0;
            for (ITraceEvent traceEvent : trace2) {
                for (TraceRegister register2 : traceEvent.getRegisterValues()) {
                    preparedStatement.setInt(1, trace2.getId());
                    preparedStatement.setInt(2, position);
                    preparedStatement.setString(3, register2.getName());
                    preparedStatement.setLong(4, register2.getValue().toLong());
                    preparedStatement.setBytes(5, register2.getMemory());
                    preparedStatement.addBatch();
                }
                ++position;
            }
            preparedStatement.executeBatch();
            preparedStatement.close();
        }
        catch (SQLException exception) {
            throw new CouldntSaveDataException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDescription(AbstractSQLProvider provider, TraceList trace2, String description) throws CouldntSaveDataException {
        Preconditions.checkNotNull(provider, "IE00582: Provider argument can not be null");
        Preconditions.checkNotNull(trace2, "IE00583: Trace list argument can not be null");
        Preconditions.checkNotNull(description, "IE00584: Description argument can not be null");
        Preconditions.checkArgument(trace2.inSameDatabase(provider), "IE00585: Trace list is not part of this database");
        CConnection connection = provider.getConnection();
        String query = "UPDATE bn_traces SET description = ? WHERE id = ?";
        try (PreparedStatement statement = connection.getConnection().prepareStatement("UPDATE bn_traces SET description = ? WHERE id = ?");){
            statement.setString(1, description);
            statement.setInt(2, trace2.getId());
            statement.executeUpdate();
        }
        catch (SQLException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setName(AbstractSQLProvider provider, TraceList trace2, String name) throws CouldntSaveDataException {
        Preconditions.checkNotNull(provider, "IE00586: Provider argument can not be null");
        Preconditions.checkNotNull(trace2, "IE00587: Trace list argument can not be null");
        Preconditions.checkNotNull(name, "IE00588: Name argument can not be null");
        Preconditions.checkArgument(trace2.inSameDatabase(provider), "IE00589: Trace list is not part of this database");
        CConnection connection = provider.getConnection();
        String query = "UPDATE bn_traces SET name = ? WHERE id = ?";
        try (PreparedStatement statement = connection.getConnection().prepareStatement("UPDATE bn_traces SET name = ? WHERE id = ?");){
            statement.setString(1, name);
            statement.setInt(2, trace2.getId());
            statement.executeUpdate();
        }
        catch (SQLException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }
}

