/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.AbstractSQLProvider;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLTagFunctions;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.PostgreSQLHelpers;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.Tagging.CTagManager;
import com.google.security.zynamics.binnavi.Tagging.TagType;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.types.trees.Tree;
import com.google.security.zynamics.zylib.types.trees.TreeNode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public final class PostgreSQLTagManagerFunctions {
    private PostgreSQLTagManagerFunctions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CTagManager loadTagManager(AbstractSQLProvider provider, TagType type) throws CouldntLoadDataException {
        CTagManager cTagManager;
        Preconditions.checkNotNull(type, "IE00567: Tag type argument can't be null");
        CConnection connection = provider.getConnection();
        if (!PostgreSQLHelpers.hasTable(connection, "bn_tags")) {
            CTag rootTag = new CTag(0, "Root Node", "", type, provider);
            return new CTagManager(new Tree<CTag>(new TreeNode<CTag>(rootTag)), type, provider);
        }
        String query = String.format("select id, parent_id, name, description from %s where type = '%s'", "bn_tags", PostgreSQLTagFunctions.tagToString(type));
        ResultSet resultSet = connection.executeQuery(query, true);
        try {
            HashMap<Integer, Pair<TreeNode<CTag>, Integer>> treeNodes = new HashMap<Integer, Pair<TreeNode<CTag>, Integer>>();
            CTag rootTag = new CTag(0, "Root Node", "", type, provider);
            TreeNode<CTag> rootTreeNode = new TreeNode<CTag>(rootTag);
            treeNodes.put(0, new Pair<TreeNode<CTag>, Integer>(rootTreeNode, -1));
            while (resultSet.next()) {
                int tagId = resultSet.getInt("id");
                int parentId = resultSet.getInt("parent_id");
                TreeNode<CTag> treeNode = new TreeNode<CTag>(new CTag(tagId, PostgreSQLHelpers.readString(resultSet, "name"), PostgreSQLHelpers.readString(resultSet, "description"), type, provider));
                Pair<TreeNode<CTag>, Integer> pair = new Pair<TreeNode<CTag>, Integer>(treeNode, parentId);
                treeNodes.put(tagId, pair);
            }
            for (Map.Entry e2 : treeNodes.entrySet()) {
                if ((Integer)e2.getKey() == 0) continue;
                TreeNode child = (TreeNode)((Pair)e2.getValue()).first();
                TreeNode parent = (TreeNode)((Pair)treeNodes.get(((Pair)e2.getValue()).second())).first();
                child.setParent(parent);
                parent.addChild(child);
            }
            cTagManager = new CTagManager(new Tree<CTag>(rootTreeNode), type, provider);
        }
        catch (Throwable throwable) {
            try {
                resultSet.close();
                throw throwable;
            }
            catch (SQLException e3) {
                throw new CouldntLoadDataException(e3);
            }
        }
        resultSet.close();
        return cTagManager;
    }
}

