/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.AbstractSQLProvider;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.PostgreSQLHelpers;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModule;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class PostgreSQLSettingsFunctions {
    private PostgreSQLSettingsFunctions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readSetting(CConnection connection, int containerId, String key, String column, String table) throws CouldntLoadDataException {
        try (PreparedStatement statement = connection.getConnection().prepareStatement(new StringBuilder(42 + String.valueOf(table).length() + String.valueOf(column).length()).append("select value from ").append(table).append(" where name = ? and ").append(column).append(" = ?").toString());){
            statement.setString(1, key);
            statement.setInt(2, containerId);
            try (ResultSet resultSet = statement.executeQuery();){
                if (resultSet.next()) {
                    String string2 = PostgreSQLHelpers.readString(resultSet, "value");
                    return string2;
                }
            }
            String string3 = null;
            return string3;
        }
        catch (SQLException exception) {
            throw new CouldntLoadDataException(exception);
        }
    }

    private static void writeSetting(CConnection connection, int containerId, String key, String value, String table) throws CouldntSaveDataException {
        String id_column = "";
        id_column = table.equalsIgnoreCase("bn_module_settings") ? "module_id" : "project_id";
        String string2 = id_column;
        String deleteQuery = new StringBuilder(49 + String.valueOf(table).length() + String.valueOf(string2).length() + String.valueOf(key).length()).append("DELETE FROM ").append(table).append(" WHERE ").append(string2).append(" = ").append(containerId).append(" AND \"name\" = '").append(key).append("'").toString();
        String insertQuery = new StringBuilder(38 + String.valueOf(table).length() + String.valueOf(key).length() + String.valueOf(value).length()).append("INSERT INTO ").append(table).append(" VALUES('").append(containerId).append("','").append(key).append("',").append(value).append(")").toString();
        try {
            PostgreSQLHelpers.beginTransaction(connection);
            connection.executeUpdate(deleteQuery, true);
            connection.executeUpdate(insertQuery, true);
            PostgreSQLHelpers.endTransaction(connection);
        }
        catch (SQLException exception) {
            String string3 = String.valueOf(table);
            throw new CouldntSaveDataException(string3.length() != 0 ? "E00058: Could not update setting on ".concat(string3) : new String("E00058: Could not update setting on "));
        }
    }

    public static String readSetting(AbstractSQLProvider provider, CModule module, String key) throws CouldntLoadDataException {
        Preconditions.checkNotNull(module, "IE00534: Module argument can not be null");
        Preconditions.checkNotNull(key, "IE00535: Key argument can not be null");
        Preconditions.checkArgument(module.inSameDatabase(provider), "IE00536: Module is not part of this database");
        return PostgreSQLSettingsFunctions.readSetting(provider.getConnection(), module.getConfiguration().getId(), key, "module_id", "bn_module_settings");
    }

    public static String readSetting(AbstractSQLProvider provider, INaviProject project, String key) throws CouldntLoadDataException {
        Preconditions.checkNotNull(project, "IE00537: Project argument can not be null");
        Preconditions.checkNotNull(key, "IE00538: Key argument can not be null");
        Preconditions.checkArgument(project.inSameDatabase(provider), "IE00539: Project is not part of this database");
        return PostgreSQLSettingsFunctions.readSetting(provider.getConnection(), project.getConfiguration().getId(), key, "project_id", "bn_project_settings");
    }

    public static void writeSetting(AbstractSQLProvider provider, CModule module, String key, String value) throws CouldntSaveDataException {
        Preconditions.checkNotNull(provider, "IE01999: Provider argument can not be null");
        Preconditions.checkNotNull(module, "IE00540: Module argument can not be null");
        Preconditions.checkNotNull(key, "IE00541: Key argument can not be null");
        Preconditions.checkNotNull(value, "IE02011: Value argument can not be null");
        Preconditions.checkArgument(module.inSameDatabase(provider), "IE00542: Module is not part of this database");
        PostgreSQLSettingsFunctions.writeSetting(provider.getConnection(), module.getConfiguration().getId(), key, value, "bn_module_settings");
    }

    public static void writeSetting(AbstractSQLProvider provider, INaviProject project, String key, String value) throws CouldntSaveDataException {
        Preconditions.checkNotNull(provider, "IE02050: Provider argument can not be null");
        Preconditions.checkNotNull(project, "IE00543: Project argument can not be null");
        Preconditions.checkNotNull(key, "IE00544: Key argument can not be null");
        Preconditions.checkNotNull(value, "IE02082: Value argument can not be null");
        Preconditions.checkArgument(project.inSameDatabase(provider), "IE00545: Project is not part of this database");
        PostgreSQLSettingsFunctions.writeSetting(provider.getConnection(), project.getConfiguration().getId(), key, value, "bn_project_settings");
    }
}

