/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.AbstractSQLProvider;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.CProjectViewFinder;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.PostgreSQLHelpers;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.CAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public final class PostgreSQLProjectFunctions {
    private PostgreSQLProjectFunctions() {
    }

    private static void checkArguments(AbstractSQLProvider provider, INaviProject project) {
        Preconditions.checkNotNull(provider, "IE00516: Provider argument can not be null");
        Preconditions.checkNotNull(project, "IE00517: Project argument can not be null");
        Preconditions.checkArgument(project.inSameDatabase(provider), "IE00518: Project is not part of this database");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDebugger(AbstractSQLProvider provider, INaviProject project, DebuggerTemplate debugger) throws CouldntSaveDataException {
        PostgreSQLProjectFunctions.checkArguments(provider, project);
        Preconditions.checkNotNull(debugger, "IE00519: Debugger argument can't be null");
        Preconditions.checkArgument(debugger.inSameDatabase(provider), "IE00520: The given debugger template is not part of this database");
        CConnection connection = provider.getConnection();
        try {
            String insertQuery = String.format("INSERT INTO %s values(?, ?)", "bn_project_debuggers");
            PreparedStatement insertStatement = connection.getConnection().prepareStatement(insertQuery);
            String deleteQuery = String.format("DELETE FROM %s WHERE project_id = ? AND debugger_id = ?", "bn_project_debuggers");
            PreparedStatement deleteStatement = connection.getConnection().prepareStatement(deleteQuery);
            try {
                PostgreSQLHelpers.beginTransaction(connection);
                deleteStatement.setInt(1, project.getConfiguration().getId());
                deleteStatement.setInt(2, debugger.getId());
                deleteStatement.execute();
                insertStatement.setInt(1, project.getConfiguration().getId());
                insertStatement.setInt(2, debugger.getId());
                insertStatement.execute();
                PostgreSQLHelpers.endTransaction(connection);
            }
            finally {
                deleteStatement.close();
                insertStatement.close();
            }
        }
        catch (SQLException exception) {
            try {
                PostgreSQLHelpers.rollback(connection);
            }
            catch (SQLException e2) {
                throw new CouldntSaveDataException("E00056: Could not rollback transaction");
            }
            throw new CouldntSaveDataException("E00057: Could not update project debugger");
        }
        PostgreSQLHelpers.updateModificationDate(connection, "bn_projects", project.getConfiguration().getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CAddressSpace createAddressSpace(AbstractSQLProvider provider, INaviProject project, String name) throws CouldntSaveDataException {
        CAddressSpace cAddressSpace;
        PostgreSQLProjectFunctions.checkArguments(provider, project);
        Preconditions.checkNotNull(name, "IE00521: Address space names can not be null");
        Preconditions.checkArgument(!"".equals(name), "IE00522: Address space names can not be empty");
        CConnection connection = provider.getConnection();
        int projectId = project.getConfiguration().getId();
        NaviLogger.info("Creating a new address space with name %s in project %s (%d)", name, project.getConfiguration().getName(), projectId);
        String query = "insert into bn_address_spaces(project_id, name, description, creation_date, modification_date) values(?, ?, '', NOW(), NOW()) returning id";
        PreparedStatement statement = connection.getConnection().prepareStatement("insert into bn_address_spaces(project_id, name, description, creation_date, modification_date) values(?, ?, '', NOW(), NOW()) returning id", 1004, 1007);
        try {
            statement.setInt(1, projectId);
            statement.setString(2, name);
            Integer addressSpaceId = null;
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    if (!resultSet.isFirst()) continue;
                    addressSpaceId = resultSet.getInt(1);
                    break;
                }
            }
            Preconditions.checkNotNull(addressSpaceId, "IE02130: Error address space id may not be null after project creation");
            cAddressSpace = PostgreSQLProjectFunctions.readAddressSpace(provider, addressSpaceId, project);
        }
        catch (Throwable throwable) {
            try {
                statement.close();
                throw throwable;
            }
            catch (SQLException e2) {
                throw new CouldntSaveDataException(e2);
            }
        }
        statement.close();
        return cAddressSpace;
    }

    public static void deleteProject(AbstractSQLProvider provider, INaviProject project) throws CouldntDeleteException {
        PostgreSQLProjectFunctions.checkArguments(provider, project);
        NaviLogger.info("Deleting project %s", project.getConfiguration().getName());
        PostgreSQLHelpers.deleteById(provider.getConnection(), "bn_projects", project.getConfiguration().getId());
    }

    public static Date getModificationDate(AbstractSQLProvider provider, INaviProject project) throws CouldntLoadDataException {
        PostgreSQLProjectFunctions.checkArguments(provider, project);
        return PostgreSQLHelpers.getModificationDate(provider.getConnection(), "bn_projects", project.getConfiguration().getId());
    }

    public static List<INaviView> getViewsWithAddresses(AbstractSQLProvider provider, INaviProject project, List<UnrelocatedAddress> addresses, boolean all) throws CouldntLoadDataException {
        PostgreSQLProjectFunctions.checkArguments(provider, project);
        Preconditions.checkNotNull(addresses, "IE00523: Addresses argument can not be null");
        StringBuilder queryBuilder = new StringBuilder();
        if (addresses.size() == 0) {
            return new ArrayList<INaviView>();
        }
        if (addresses.size() == 1) {
            String string2 = String.valueOf("SELECT bn_project_views.project_id, bn_project_views.view_id  FROm bn_project_views JOIN bn_nodes ON bn_project_views.view_id = bn_nodes.view_id  JOIN bn_codenode_instructions ON bn_nodes.id = bn_codenode_instructions.node_id  WHERE project_id = ");
            int n2 = project.getConfiguration().getId();
            String string3 = String.valueOf("bn_codenode_instructions");
            String string4 = String.valueOf(addresses.get(0).getAddress().toBigInteger().toString());
            queryBuilder.append(new StringBuilder(27 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append(string2).append(n2).append(" AND ").append(string3).append(".address = ").append(string4).toString());
        } else if (all) {
            boolean needsComma = false;
            int counter = 0;
            queryBuilder.append("select view_id from ");
            for (UnrelocatedAddress address : addresses) {
                if (needsComma) {
                    queryBuilder.append(" inner join ");
                }
                needsComma = true;
                String string5 = String.valueOf("(select bn_project_views.project_id, bn_project_views.view_id  from bn_project_views  join bn_nodes on bn_project_views.view_id = bn_nodes.view_id  join bn_codenode_instructions on bn_nodes.id = bn_codenode_instructions.node_id  where bn_project_views.project_id = ");
                int n3 = project.getConfiguration().getId();
                String string6 = String.valueOf("bn_codenode_instructions");
                long l2 = address.getAddress().toLong();
                int n4 = counter++;
                queryBuilder.append(new StringBuilder(65 + String.valueOf(string5).length() + String.valueOf(string6).length()).append(string5).append(n3).append(" ").append(" and ").append(string6).append(".address = ").append(l2).append(") as t").append(n4).toString());
            }
            queryBuilder.append(" using (view_id)");
        } else {
            String needsComma = String.valueOf("select bn_project_views.project_id, bn_project_views.view_id from bn_project_views join bn_nodes on bn_project_views.view_id = bn_nodes.view_id join bn_codenode_instructions on bn_nodes.id = bn_codenode_instructions.node_id where bn_project_views.project_id = ");
            int n5 = project.getConfiguration().getId();
            String string7 = String.valueOf("bn_codenode_instructions");
            queryBuilder.append(new StringBuilder(29 + String.valueOf(needsComma).length() + String.valueOf(string7).length()).append(needsComma).append(n5).append(" and ").append(string7).append(".address in (").toString());
            boolean needsComma2 = false;
            for (UnrelocatedAddress address : addresses) {
                if (needsComma2) {
                    queryBuilder.append(", ");
                }
                needsComma2 = true;
                queryBuilder.append(address.getAddress().toLong());
            }
            queryBuilder.append(") group by bn_project_views.view_id, bn_project_views.project_id");
        }
        return PostgreSQLHelpers.getViewsWithAddress(provider.getConnection(), queryBuilder.toString(), "project_id", new CProjectViewFinder(provider));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CAddressSpace readAddressSpace(AbstractSQLProvider provider, int addressSpaceId, INaviProject project) throws SQLException {
        String string2 = String.valueOf("SELECT name, description, creation_date, modification_date  FROM bn_address_spaces WHERE id = ");
        String query = new StringBuilder(11 + String.valueOf(string2).length()).append(string2).append(addressSpaceId).toString();
        try (ResultSet resultSet = provider.getConnection().executeQuery(query, true);){
            if (resultSet.next()) {
                String name = PostgreSQLHelpers.readString(resultSet, "name");
                String description = PostgreSQLHelpers.readString(resultSet, "description");
                Timestamp creationDate = resultSet.getTimestamp("creation_date");
                Timestamp modificationDate = resultSet.getTimestamp("modification_date");
                CAddressSpace cAddressSpace = new CAddressSpace(addressSpaceId, name, description == null ? "" : description, creationDate, modificationDate, new HashMap<INaviModule, IAddress>(), null, provider, project);
                return cAddressSpace;
            }
        }
        return null;
    }

    public static void removeDebugger(AbstractSQLProvider provider, INaviProject project, DebuggerTemplate debugger) throws CouldntSaveDataException {
        PostgreSQLProjectFunctions.checkArguments(provider, project);
        Preconditions.checkNotNull(debugger, "IE00524: Debugger argument can not be null");
        Preconditions.checkArgument(debugger.inSameDatabase(provider), "IE00525: Debugger is not part of this database");
        String query = String.format("delete from bn_project_debuggers where project_id = %d and debugger_id = %d", project.getConfiguration().getId(), debugger.getId());
        try {
            provider.getConnection().executeUpdate(query, true);
        }
        catch (SQLException e2) {
            throw new CouldntSaveDataException(e2);
        }
        PostgreSQLHelpers.updateModificationDate(provider.getConnection(), "bn_projects", project.getConfiguration().getId());
    }

    public static void setDescription(AbstractSQLProvider provider, INaviProject project, String description) throws CouldntSaveDataException {
        PostgreSQLProjectFunctions.checkArguments(provider, project);
        Preconditions.checkNotNull(description, "IE00526: Description argument can not be null");
        PostgreSQLHelpers.setDescription(provider.getConnection(), project.getConfiguration().getId(), description, "bn_projects");
    }

    public static void setName(AbstractSQLProvider provider, INaviProject project, String name) throws CouldntSaveDataException {
        PostgreSQLProjectFunctions.checkArguments(provider, project);
        Preconditions.checkNotNull(name, "IE00527: Name argument can not be null");
        PostgreSQLHelpers.setName(provider.getConnection(), project.getConfiguration().getId(), name, "bn_projects");
    }
}

