/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.AbstractSQLProvider;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.DatabaseVersion;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntUpdateDatabaseException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.PostgreSQLHelpers;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplateManager;
import com.google.security.zynamics.binnavi.disassembly.CProject;
import com.google.security.zynamics.binnavi.disassembly.CRawModule;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.binnavi.disassembly.INaviRawModule;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModule;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public final class PostgreSQLDatabaseFunctions {
    protected static Multimap<Pair<CConnection, String>, String> m_cache = HashMultimap.create();

    private PostgreSQLDatabaseFunctions() {
    }

    protected static void checkArguments(AbstractSQLProvider provider, DebuggerTemplateManager debuggerManager) {
        Preconditions.checkNotNull(provider, "IE00413: Provider argument can not be null");
        Preconditions.checkNotNull(debuggerManager, "IE01227: Debugger final manager argument can final not be null");
        Preconditions.checkArgument(debuggerManager.inSameDatabase(provider), "IE00415: Debugger manager is not part of the given database");
    }

    protected static boolean checkRawModulesTables(CConnection connection, String databaseName, int rawModuleId) {
        Preconditions.checkNotNull(connection, "IE02261: Connection argument can not be null");
        Preconditions.checkNotNull(databaseName, "IE02262: Database name argument can not be null");
        Preconditions.checkArgument(rawModuleId > 0, "Raw module id %s must be a positive integer", rawModuleId);
        ImmutableSet<String> rawTableNames = ImmutableSet.of(String.format("ex_%d_address_comments", rawModuleId), String.format("ex_%d_address_references", rawModuleId), String.format("ex_%d_base_types", rawModuleId), String.format("ex_%d_basic_block_instructions", rawModuleId), String.format("ex_%d_basic_blocks", rawModuleId), String.format("ex_%d_callgraph", rawModuleId), new String[]{String.format("ex_%d_control_flow_graphs", rawModuleId), String.format("ex_%d_expression_nodes", rawModuleId), String.format("ex_%d_expression_substitutions", rawModuleId), String.format("ex_%d_expression_tree_nodes", rawModuleId), String.format("ex_%d_expression_trees", rawModuleId), String.format("ex_%d_expression_types", rawModuleId), String.format("ex_%d_functions", rawModuleId), String.format("ex_%d_instructions", rawModuleId), String.format("ex_%d_operands", rawModuleId), String.format("ex_%d_sections", rawModuleId), String.format("ex_%d_expression_type_instances", rawModuleId), String.format("ex_%d_type_instances", rawModuleId), String.format("ex_%d_types", rawModuleId)});
        Pair<CConnection, String> cacheKey = new Pair<CConnection, String>(connection, databaseName);
        if (PostgreSQLDatabaseFunctions.queryCache(cacheKey, rawTableNames)) {
            return true;
        }
        if (!PostgreSQLDatabaseFunctions.fillCache(cacheKey)) {
            return false;
        }
        return PostgreSQLDatabaseFunctions.queryCache(cacheKey, rawTableNames);
    }

    protected static boolean fillCache(Pair<CConnection, String> cacheKey) {
        m_cache.clear();
        String string2 = cacheKey.second();
        String query = new StringBuilder(75 + String.valueOf(string2).length()).append("SELECT table_name FROM information_schema.tables  WHERE table_catalog = '").append(string2).append("' ").toString();
        try (ResultSet result = cacheKey.first().executeQuery(query, true);){
            while (result.next()) {
                m_cache.put(cacheKey, result.getString(1));
            }
        }
        catch (SQLException exception) {
            return false;
        }
        return true;
    }

    protected static INaviRawModule findRawModule(int rawModuleId, List<INaviRawModule> rawModules) {
        Preconditions.checkArgument(rawModuleId > 0, "Raw module id %s must be positive integer", rawModuleId);
        Preconditions.checkNotNull(rawModules, "IE02263: raw modules argument can not be null");
        for (INaviRawModule rawModule : rawModules) {
            if (rawModule.getId() != rawModuleId) continue;
            return rawModule;
        }
        throw new IllegalStateException("IE00160: Could not find raw module");
    }

    protected static List<DebuggerTemplate> getAssignedDebuggers(CConnection connection, int projectId, DebuggerTemplateManager debuggerManager) throws CouldntLoadDataException {
        Preconditions.checkNotNull(connection, "IE02264: Connection argument can not be null");
        Preconditions.checkArgument(projectId > 0, "Project id %s must be a positive integer.", projectId);
        Preconditions.checkNotNull(debuggerManager, "IE02265: debugger manager argument can not be null");
        ArrayList<DebuggerTemplate> debuggerIds = new ArrayList<DebuggerTemplate>();
        String query = String.format("SELECT debugger_id FROM %s WHERE project_id = %d", "bn_project_debuggers", projectId);
        try (ResultSet resultSet = connection.executeQuery(query, true);){
            while (resultSet.next()) {
                debuggerIds.add(debuggerManager.findDebugger(resultSet.getInt("debugger_id")));
            }
        }
        catch (SQLException exception) {
            throw new CouldntLoadDataException(exception);
        }
        return debuggerIds;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static int getRawModuleFunctionCount(CConnection connection, int rawModuleId) throws SQLException {
        Preconditions.checkNotNull(connection, "IE02266: Connection argument can not be null");
        Preconditions.checkArgument(rawModuleId > 0, "Raw module id %s must be a positive integer", rawModuleId);
        String string2 = String.valueOf("SELECT count(*) AS fcount  FROM ex_");
        String query = new StringBuilder(55 + String.valueOf(string2).length()).append(string2).append(rawModuleId).append("_functions ").append(" WHERE address <> 0 ").append(" OR type <> 3").toString();
        try (ResultSet resultSet = connection.executeQuery(query, true);){
            if (resultSet.next()) {
                int n2 = resultSet.getInt("fcount");
                return n2;
            }
            int n3 = 0;
            return n3;
        }
        catch (SQLException exception) {
            throw new SQLException("Could not load function count");
        }
    }

    protected static ArrayList<Integer> getRawModuleIDs(CConnection connection) throws SQLException {
        Preconditions.checkNotNull(connection, "IE02267: Connection argument can not be null");
        ArrayList<Integer> rawModuleIDs = new ArrayList<Integer>();
        try (ResultSet resultSet = connection.executeQuery("SELECT id FROM modules", true);){
            while (resultSet.next()) {
                rawModuleIDs.add(resultSet.getInt("id"));
            }
        }
        catch (Exception exception) {
            return null;
        }
        return rawModuleIDs;
    }

    protected static boolean queryCache(Pair<CConnection, String> cacheKey, ImmutableSet<String> rawTableNames) {
        return m_cache.get(cacheKey).containsAll(rawTableNames);
    }

    public static DatabaseVersion getDatabaseVersion(CConnection m_connection) throws CouldntLoadDataException, SQLException {
        if (PostgreSQLHelpers.hasTable(m_connection, "bn_sections")) {
            return new DatabaseVersion("6.0.0");
        }
        if (PostgreSQLHelpers.hasTable(m_connection, "bn_users")) {
            return new DatabaseVersion("5.0.0");
        }
        if (PostgreSQLHelpers.hasTable(m_connection, "modules") && PostgreSQLHelpers.hasTable(m_connection, "bn_modules")) {
            ArrayList<Integer> rawModuleIds = PostgreSQLDatabaseFunctions.getRawModuleIDs(m_connection);
            if (rawModuleIds.isEmpty()) {
                return new DatabaseVersion("3.0.0");
            }
            String string2 = String.valueOf(rawModuleIds.get(0));
            if (PostgreSQLHelpers.hasTable(m_connection, new StringBuilder(16 + String.valueOf(string2).length()).append("ex_").append(string2).append("_type_structs").toString())) {
                return new DatabaseVersion("4.0.0");
            }
            return new DatabaseVersion("3.0.0");
        }
        return new DatabaseVersion("6.0.1");
    }

    public static List<INaviModule> loadModules(AbstractSQLProvider provider, List<INaviRawModule> rawModules, DebuggerTemplateManager debuggerManager) throws CouldntLoadDataException {
        Preconditions.checkNotNull(rawModules, "IE02043: rawModules argument can not be null");
        PostgreSQLDatabaseFunctions.checkArguments(provider, debuggerManager);
        ArrayList<CModule> modules = new ArrayList<CModule>();
        CConnection connection = provider.getConnection();
        if (!PostgreSQLHelpers.hasTable(connection, "bn_modules")) {
            return new ArrayList<INaviModule>(modules);
        }
        String query = "SELECT id, raw_module_id, bn_modules.name,  md5, sha1, description, import_time, modification_date, file_base, image_base, stared,  initialization_state, debugger_id,  (SELECT count(*) FROM bn_functions  WHERE id = bn_functions.module_id)  AS function_count,  (SELECT count(*) FROM bn_module_views JOIN bn_views ON view_id = id  WHERE type = 'non-native' and module_id = bn_modules.id)  AS view_count FROM bn_modules  WHERE raw_module_id IS NOT NULL ORDER BY id";
        try (ResultSet resultSet = connection.executeQuery("SELECT id, raw_module_id, bn_modules.name,  md5, sha1, description, import_time, modification_date, file_base, image_base, stared,  initialization_state, debugger_id,  (SELECT count(*) FROM bn_functions  WHERE id = bn_functions.module_id)  AS function_count,  (SELECT count(*) FROM bn_module_views JOIN bn_views ON view_id = id  WHERE type = 'non-native' and module_id = bn_modules.id)  AS view_count FROM bn_modules  WHERE raw_module_id IS NOT NULL ORDER BY id", true);){
            while (resultSet.next()) {
                int moduleId = resultSet.getInt("id");
                String name = PostgreSQLHelpers.readString(resultSet, "name");
                String md52 = PostgreSQLHelpers.readString(resultSet, "md5");
                String sha1 = PostgreSQLHelpers.readString(resultSet, "sha1");
                String comment = PostgreSQLHelpers.readString(resultSet, "description");
                Timestamp timestamp = resultSet.getTimestamp("import_time");
                Timestamp modificationDate = resultSet.getTimestamp("modification_date");
                int functionCount = resultSet.getInt("function_count");
                int viewCount = resultSet.getInt("view_count");
                IAddress imageBase = PostgreSQLHelpers.loadAddress(resultSet, "image_base");
                IAddress fileBase = PostgreSQLHelpers.loadAddress(resultSet, "file_base");
                int debuggerId = resultSet.getInt("debugger_id");
                boolean isStared = resultSet.getBoolean("stared");
                int initializationState = resultSet.getInt("initialization_state");
                DebuggerTemplate description = debuggerManager.findDebugger(debuggerId);
                int rawModuleId = resultSet.getInt("raw_module_id");
                INaviRawModule rawModule = PostgreSQLDatabaseFunctions.findRawModule(rawModuleId, rawModules);
                if (functionCount == 0 && rawModule != null) {
                    functionCount = rawModule.getFunctionCount();
                }
                modules.add(new CModule(moduleId, name, comment, timestamp, modificationDate, md52, sha1, functionCount, viewCount, fileBase, imageBase, description, rawModule, initializationState, isStared, provider));
            }
        }
        catch (SQLException e2) {
            throw new CouldntLoadDataException(e2);
        }
        return new ArrayList<INaviModule>(modules);
    }

    public static List<INaviProject> loadProjects(AbstractSQLProvider provider, DebuggerTemplateManager debuggerManager) throws CouldntLoadDataException {
        PostgreSQLDatabaseFunctions.checkArguments(provider, debuggerManager);
        CConnection connection = provider.getConnection();
        ArrayList<INaviProject> projects = new ArrayList<INaviProject>();
        if (!PostgreSQLHelpers.hasTable(connection, "bn_projects")) {
            return projects;
        }
        String query = "SELECT id, name, description, creation_date, modification_date,  (SELECT count(*) FROM bn_address_spaces WHERE project_id = bn_projects.id)  AS addressspace_count FROM bn_projects";
        try (ResultSet resultSet = connection.executeQuery(query, true);){
            while (resultSet.next()) {
                int projectId = resultSet.getInt("id");
                String name = PostgreSQLHelpers.readString(resultSet, "name");
                String description = PostgreSQLHelpers.readString(resultSet, "description");
                int addressSpaceCount = resultSet.getInt("addressspace_count");
                Timestamp creationDate = resultSet.getTimestamp("creation_date");
                Timestamp modificationDate = resultSet.getTimestamp("modification_date");
                List<DebuggerTemplate> debuggers = PostgreSQLDatabaseFunctions.getAssignedDebuggers(connection, projectId, debuggerManager);
                projects.add(new CProject(projectId, name, description == null ? "" : description, creationDate, modificationDate, addressSpaceCount, debuggers, provider));
            }
        }
        catch (SQLException e2) {
            throw new CouldntLoadDataException(e2);
        }
        return new ArrayList<INaviProject>(projects);
    }

    public static final List<INaviRawModule> loadRawModules(AbstractSQLProvider provider) throws CouldntLoadDataException {
        Preconditions.checkNotNull(provider, "IE00416: Provider argument can not be null");
        CConnection connection = provider.getConnection();
        ArrayList<INaviRawModule> modules = new ArrayList<INaviRawModule>();
        if (!PostgreSQLHelpers.hasTable(connection, "modules")) {
            return modules;
        }
        String query = "SELECT id, name FROM modules ORDER BY id";
        try (ResultSet resultSet = connection.executeQuery("SELECT id, name FROM modules ORDER BY id", true);){
            while (resultSet.next()) {
                int rawModuleId = resultSet.getInt("id");
                String name = PostgreSQLHelpers.readString(resultSet, "name");
                boolean isComplete = PostgreSQLDatabaseFunctions.checkRawModulesTables(provider.getConnection(), PostgreSQLHelpers.getDatabaseName(provider.getConnection()), rawModuleId);
                int functionCount = isComplete ? PostgreSQLDatabaseFunctions.getRawModuleFunctionCount(connection, rawModuleId) : 0;
                CRawModule module = new CRawModule(rawModuleId, name, functionCount, isComplete, provider);
                modules.add(module);
            }
        }
        catch (SQLException e2) {
            throw new CouldntLoadDataException(e2);
        }
        return modules;
    }

    private static void databaseUpdater(CConnection connection, String resource) throws CouldntUpdateDatabaseException {
        BufferedReader input = new BufferedReader(new InputStreamReader(ClassLoader.getSystemResourceAsStream(resource)));
        StringBuffer contents = new StringBuffer();
        String line = null;
        try {
            while ((line = input.readLine()) != null) {
                if (line.length() > 0 && line.charAt(0) == '#') continue;
                contents.append(line);
                contents.append('\n');
            }
            input.close();
        }
        catch (IOException exception) {
            throw new CouldntUpdateDatabaseException(exception.toString(), 40);
        }
        try (PreparedStatement statement = connection.getConnection().prepareStatement(contents.toString());){
            statement.execute();
        }
        catch (SQLException exception) {
            throw new CouldntUpdateDatabaseException(exception.toString(), 41);
        }
    }

    public static void updateDatabase(SQLProvider provider) throws CouldntUpdateDatabaseException {
        try {
            if (provider.getDatabaseVersion().compareTo(new DatabaseVersion("4.0.0")) == 0) {
                PostgreSQLDatabaseFunctions.databaseUpdater(provider.getConnection(), "com/google/security/zynamics/binnavi/data/postgresql_convert_4_0_7_to_5_0_0.sql");
                PostgreSQLDatabaseFunctions.databaseUpdater(provider.getConnection(), "com/google/security/zynamics/binnavi/data/postgresql_convert_5_0_0_to_5_0_1.sql");
            } else if (provider.getDatabaseVersion().compareTo(new DatabaseVersion("5.0.0")) == 0) {
                PostgreSQLDatabaseFunctions.databaseUpdater(provider.getConnection(), "com/google/security/zynamics/binnavi/data/postgresql_convert_5_0_0_to_5_0_1.sql");
            }
        }
        catch (CouldntLoadDataException exception) {
            CUtilityFunctions.logException(exception);
        }
    }
}

