/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.AbstractSQLProvider;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModule;
import com.google.security.zynamics.zylib.general.ByteHelpers;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class PostgreSQLDataFunctions {
    private PostgreSQLDataFunctions() {
    }

    public static void saveData(AbstractSQLProvider provider, INaviModule module, byte[] data) throws CouldntSaveDataException {
        Preconditions.checkNotNull(provider, "IE01267: Provider argument can not be null");
        Preconditions.checkNotNull(module, "IE01268: Module argument can not be null");
        Preconditions.checkNotNull(data, "IE01269: Data argument can not be null");
        CConnection connection = provider.getConnection();
        try {
            String string2 = String.valueOf("DELETE FROM bn_data_parts WHERE module_id = ");
            int n2 = module.getConfiguration().getId();
            connection.executeUpdate(new StringBuilder(11 + String.valueOf(string2).length()).append(string2).append(n2).toString(), true);
        }
        catch (SQLException exception) {
            throw new CouldntSaveDataException(exception);
        }
        String preparedStatement = "INSERT INTO bn_data_parts(module_id, part_id, data) VALUES(?, ?, ?)";
        try (PreparedStatement statement = provider.getConnection().getConnection().prepareStatement("INSERT INTO bn_data_parts(module_id, part_id, data) VALUES(?, ?, ?)");){
            statement.setInt(1, module.getConfiguration().getId());
            statement.setInt(2, 0);
            statement.setBinaryStream(3, (InputStream)new ByteArrayInputStream(data, 0, data.length), data.length);
            statement.execute();
        }
        catch (SQLException exception) {
            throw new CouldntSaveDataException(exception);
        }
    }

    public static List<byte[]> loadDataChunks(AbstractSQLProvider provider, CModule module) throws SQLException {
        ArrayList<byte[]> dataList = new ArrayList<byte[]>();
        String string2 = String.valueOf("SELECT data FROM bn_data_parts WHERE module_id = ");
        int n2 = module.getConfiguration().getId();
        String query = new StringBuilder(32 + String.valueOf(string2).length()).append(string2).append(n2).append(" ORDER BY part_id ASC").toString();
        try (ResultSet resultSet = provider.executeQuery(query);){
            while (resultSet.next()) {
                dataList.add(resultSet.getBytes("data"));
            }
        }
        return dataList;
    }

    public static byte[] loadData(AbstractSQLProvider provider, CModule module) throws CouldntLoadDataException {
        Preconditions.checkNotNull(provider, "IE01265: Provider argument can not be null");
        Preconditions.checkNotNull(module, "IE01266: Module argument can not be null");
        Preconditions.checkArgument(module.inSameDatabase(provider), "IE00532: Module is not stored in the given database");
        try {
            return ByteHelpers.combine(PostgreSQLDataFunctions.loadDataChunks(provider, module));
        }
        catch (SQLException e2) {
            throw new CouldntLoadDataException(e2);
        }
    }
}

