/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Creators;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.AbstractSQLProvider;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.CModuleViewGenerator;
import com.google.security.zynamics.binnavi.Database.CProjectViewGenerator;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.ViewGenerator;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.PostgreSQLHelpers;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Savers.PostgreSQLEdgeSaver;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Savers.PostgreSQLNodeSaver;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.disassembly.INaviEdge;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.views.CView;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.disassembly.ViewType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.List;

public final class PostgreSQLViewCreator {
    private PostgreSQLViewCreator() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static CView createView(AbstractSQLProvider provider, int containerId, INaviView view, String name, String description, String containerTable, String viewContainerTable, ViewGenerator generator2) throws CouldntSaveDataException {
        CConnection connection = provider.getConnection();
        try {
            PostgreSQLHelpers.beginTransaction(connection);
            int viewId = PostgreSQLViewCreator.insertView(connection, name, description);
            connection.executeUpdate(new StringBuilder(45 + String.valueOf(viewContainerTable).length()).append("INSERT INTO ").append(viewContainerTable).append(" VALUES(").append(containerId).append(", ").append(viewId).append(")").toString(), true);
            List<INaviViewNode> nodes = view.getGraph().getNodes();
            List<INaviEdge> edges = view.getGraph().getEdges();
            PostgreSQLNodeSaver.writeNodes(provider, viewId, nodes);
            PostgreSQLEdgeSaver.writeEdges(provider, edges);
            PostgreSQLHelpers.endTransaction(connection);
            String string2 = String.valueOf("SELECT creation_date, modification_date FROM bn_views WHERE id = ");
            String query = new StringBuilder(11 + String.valueOf(string2).length()).append(string2).append(viewId).toString();
            try (ResultSet resultSet = connection.executeQuery(query, true);){
                if (!resultSet.next()) throw new CouldntSaveDataException("Error: Couldnt't load the created view");
                Timestamp creationDate = resultSet.getTimestamp("creation_date");
                Timestamp modificationDate = resultSet.getTimestamp("modification_date");
                PostgreSQLHelpers.updateModificationDate(connection, containerTable, containerId);
                CView cView = generator2.generate(viewId, name, description, ViewType.NonNative, view.getGraphType(), creationDate, modificationDate, view.getNodeCount(), view.getEdgeCount(), new HashSet<CTag>(), new HashSet<CTag>(), false);
                return cView;
            }
        }
        catch (SQLException exception) {
            CUtilityFunctions.logException(exception);
            try {
                PostgreSQLHelpers.rollback(connection);
                throw new CouldntSaveDataException(exception);
            }
            catch (SQLException e2) {
                CUtilityFunctions.logException(e2);
            }
            throw new CouldntSaveDataException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int insertView(CConnection connection, String name, String description) throws SQLException {
        String query = "INSERT INTO bn_views(type, name, description, creation_date, modification_date)  VALUES(?::view_type, ?, ?, NOW(), NOW()) RETURNING id";
        try (PreparedStatement statement = connection.getConnection().prepareStatement("INSERT INTO bn_views(type, name, description, creation_date, modification_date)  VALUES(?::view_type, ?, ?, NOW(), NOW()) RETURNING id", 1004, 1007);){
            statement.setString(1, "non-native");
            statement.setString(2, name);
            if (description == null) {
                statement.setNull(3, 12);
            } else {
                statement.setString(3, description);
            }
            int lastId = 0;
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    if (!resultSet.isFirst()) continue;
                    lastId = resultSet.getInt(1);
                    break;
                }
                if (!resultSet.isFirst()) {
                    throw new IllegalStateException("IE02071: Unable to determine last id after SQL insertion.");
                }
            }
            int n2 = lastId;
            return n2;
        }
    }

    public static CView createView(AbstractSQLProvider provider, INaviModule module, INaviView view, String name, String description) throws CouldntSaveDataException {
        Preconditions.checkNotNull(provider, "IE02268: Provider argument can not be null");
        Preconditions.checkNotNull(module, "IE02269: Module argument can not be null");
        Preconditions.checkNotNull(view, "IE02270: View argument can not be null");
        Preconditions.checkNotNull(name, "IE02271: Name argument can not be null");
        Preconditions.checkState(module.inSameDatabase(provider), "Error: Module is not part of this database");
        Preconditions.checkState(view.inSameDatabase(provider), "Error: View is not part of this database");
        return PostgreSQLViewCreator.createView(provider, module.getConfiguration().getId(), view, name, description, "bn_modules", "bn_module_views", new CModuleViewGenerator(provider, module));
    }

    public static CView createView(AbstractSQLProvider provider, INaviProject project, INaviView view, String name, String description) throws CouldntSaveDataException {
        Preconditions.checkNotNull(project, "Error: Project argument can not be null");
        Preconditions.checkNotNull(view, "IE02273: View argument can not be null");
        Preconditions.checkNotNull(name, "IE02274: Name argument can not be null");
        Preconditions.checkState(view.inSameDatabase(provider), "Error: View is not part of this database");
        return PostgreSQLViewCreator.createView(provider, project.getConfiguration().getId(), view, name, description, "bn_projects", "bn_project_views", new CProjectViewGenerator(provider, project));
    }
}

