/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Creators;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.AbstractSQLProvider;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.PostgreSQLHelpers;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate;
import com.google.security.zynamics.binnavi.disassembly.CProject;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;

public final class PostgreSQLProjectCreator {
    private PostgreSQLProjectCreator() {
    }

    protected static CProject loadProject(AbstractSQLProvider provider, int projectId) throws SQLException {
        String string2 = String.valueOf("select id, name, description, creation_date, modification_date from bn_projects where id = ");
        String query = new StringBuilder(11 + String.valueOf(string2).length()).append(string2).append(projectId).toString();
        try (ResultSet resultSet = provider.getConnection().executeQuery(query, true);){
            if (resultSet.next()) {
                String name = PostgreSQLHelpers.readString(resultSet, "name");
                String description = PostgreSQLHelpers.readString(resultSet, "description");
                boolean addressSpaceCount = false;
                Timestamp creationDate = resultSet.getTimestamp("creation_date");
                Timestamp modificationDate = resultSet.getTimestamp("modification_date");
                CProject cProject = new CProject(projectId, name, description, creationDate, modificationDate, 0, new ArrayList<DebuggerTemplate>(), provider);
                return cProject;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CProject createProject(AbstractSQLProvider provider, String name) throws CouldntSaveDataException {
        Preconditions.checkNotNull(provider, "IE00513: Provider argument can not be null");
        Preconditions.checkNotNull(name, "IE00514: Project names can not be null");
        Preconditions.checkArgument(!"".equals(name), "IE00515: Project names can not be empty");
        CConnection connection = provider.getConnection();
        NaviLogger.info("Creating new project %s", name);
        String query = "INSERT INTO bn_projects(name, description, creation_date, modification_date) VALUES(?, '', NOW(), NOW()) RETURNING id";
        try (PreparedStatement statement = connection.getConnection().prepareStatement("INSERT INTO bn_projects(name, description, creation_date, modification_date) VALUES(?, '', NOW(), NOW()) RETURNING id", 1004, 1007);){
            statement.setString(1, name);
            ResultSet resultSet = statement.executeQuery();
            Integer id = null;
            while (resultSet.next()) {
                if (!resultSet.isFirst()) continue;
                id = resultSet.getInt(1);
                break;
            }
            Preconditions.checkNotNull(id, "IE02044: Error id for a project after creation may not be null");
            CProject cProject = PostgreSQLProjectCreator.loadProject(provider, id);
            return cProject;
        }
        catch (SQLException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }
}

