/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Creators;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.CConnection;
import java.sql.CallableStatement;
import java.sql.SQLException;

public final class PostgreSQLModuleCreator {
    private PostgreSQLModuleCreator() {
    }

    public static void connectViewsFunctions(CConnection connection, int moduleId, int firstViewId) throws SQLException {
        Preconditions.checkNotNull(connection, "IE00453: connection argument can not be null");
        String query = " { call connect_views_to_functions(?,?) } ";
        CallableStatement call = connection.getConnection().prepareCall(" { call connect_views_to_functions(?,?) } ");
        call.setInt(1, moduleId);
        call.setInt(2, firstViewId);
        call.execute();
    }

    public static int createNewModule(CConnection connection, int rawModuleId) throws SQLException {
        Preconditions.checkNotNull(connection, "IE01857: Connection argument can not be null");
        String query = " { ? = call create_module(?) } ";
        CallableStatement call = connection.getConnection().prepareCall(" { ? = call create_module(?) } ");
        call.registerOutParameter(1, 4);
        call.setInt(2, rawModuleId);
        call.execute();
        return call.getInt(1);
    }

    public static void connectInstructionsToCodeNodes(CConnection connection, int rawModuleId, int moduleId) throws SQLException {
        Preconditions.checkNotNull(connection, "IE00454: connection argument can not be null");
        String query = " { call connect_instructions_to_code_nodes(?,?) } ";
        CallableStatement call = connection.getConnection().prepareCall(" { call connect_instructions_to_code_nodes(?,?) } ");
        call.setInt(1, rawModuleId);
        call.setInt(2, moduleId);
        call.execute();
    }
}

