/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.NodeParser;

import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Database.NodeParser.InstructionLine;
import com.google.security.zynamics.binnavi.Database.NodeParser.OperandTree;
import com.google.security.zynamics.binnavi.Database.NodeParser.OperandTreeNode;
import com.google.security.zynamics.binnavi.disassembly.CInstruction;
import com.google.security.zynamics.binnavi.disassembly.COperandTree;
import com.google.security.zynamics.binnavi.disassembly.COperandTreeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.types.TypeInstanceContainer;
import com.google.security.zynamics.binnavi.disassembly.types.TypeManager;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.util.ArrayList;
import java.util.HashMap;

public final class InstructionConverter {
    private InstructionConverter() {
    }

    private static COperandTree generateTree(OperandTree rawTree, SQLProvider provider, INaviModule module) {
        ArrayList<COperandTreeNode> realNodes = new ArrayList<COperandTreeNode>();
        HashMap<COperandTreeNode, OperandTreeNode> realToRawMapping = new HashMap<COperandTreeNode, OperandTreeNode>();
        HashMap<Integer, COperandTreeNode> idToRealMapping = new HashMap<Integer, COperandTreeNode>();
        COperandTreeNode root = null;
        TypeManager typeManager = module.getTypeManager();
        TypeInstanceContainer instanceContainer = module.getContent().getTypeInstanceContainer();
        for (OperandTreeNode rawNode : rawTree.getNodes()) {
            COperandTreeNode node = new COperandTreeNode(rawNode.getId(), rawNode.getType(), rawNode.getValue(), rawNode.getReplacement(), rawNode.getReferences(), provider, typeManager, instanceContainer);
            if (rawNode.getTypeSubstitution() != null) {
                typeManager.initializeTypeSubstitution(node, rawNode.getTypeSubstitution());
            }
            if (rawNode.getTypeInstanceId() != null) {
                instanceContainer.initializeTypeInstanceReference(rawNode.getAddress(), rawNode.getPosition(), rawNode.getId(), node);
            }
            realToRawMapping.put(node, rawNode);
            idToRealMapping.put(rawNode.getId(), node);
            if (rawNode.getParentId() == null) {
                root = node;
            }
            realNodes.add(node);
        }
        for (COperandTreeNode realNode : realNodes) {
            OperandTreeNode rawNode = (OperandTreeNode)realToRawMapping.get(realNode);
            Integer parentId = rawNode.getParentId();
            if (parentId == null) continue;
            COperandTreeNode realParent = (COperandTreeNode)idToRealMapping.get(parentId);
            COperandTreeNode.link(realParent, realNode);
        }
        return new COperandTree(root, provider, typeManager, instanceContainer);
    }

    public static CInstruction createInstruction(InstructionLine line, SQLProvider provider) {
        ArrayList<COperandTree> operands = new ArrayList<COperandTree>();
        INaviModule module = line.getModule();
        for (OperandTree rawTree : line.getOperands()) {
            operands.add(InstructionConverter.generateTree(rawTree, provider, module));
        }
        IAddress address = line.getAddress();
        String mnemonic = line.getMnemonic();
        String architecture = line.getArchitecture();
        CInstruction instruction = new CInstruction(true, module, address, mnemonic, operands, line.getData(), architecture, provider);
        return instruction;
    }
}

