/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.NodeParser;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.security.zynamics.binnavi.Database.Exceptions.CPartialLoadException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.LoadCancelledException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Database.NodeParser.ICodeNodeProvider;
import com.google.security.zynamics.binnavi.Database.NodeParser.InstructionConverter;
import com.google.security.zynamics.binnavi.Database.NodeParser.InstructionLine;
import com.google.security.zynamics.binnavi.Database.NodeParser.OperandTree;
import com.google.security.zynamics.binnavi.Database.NodeParser.OperandTreeNode;
import com.google.security.zynamics.binnavi.Database.NodeParser.ParserException;
import com.google.security.zynamics.binnavi.Database.cache.InstructionCache;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.disassembly.CCodeNode;
import com.google.security.zynamics.binnavi.disassembly.CFunctionReplacement;
import com.google.security.zynamics.binnavi.disassembly.CInstruction;
import com.google.security.zynamics.binnavi.disassembly.CReference;
import com.google.security.zynamics.binnavi.disassembly.CStringReplacement;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviReplacement;
import com.google.security.zynamics.binnavi.disassembly.types.RawTypeSubstitution;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.Pair;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class CCodeNodeParser {
    private final Map<Integer, INaviModule> modules = new HashMap<Integer, INaviModule>();
    final Map<Integer, INaviCodeNode> localCommentIdToCodeNode = new HashMap<Integer, INaviCodeNode>();
    final Map<Integer, INaviCodeNode> globalCommentIdToCodeNode = new HashMap<Integer, INaviCodeNode>();
    final Map<Integer, Pair<INaviInstruction, INaviCodeNode>> localCommentIdToInstruction = new HashMap<Integer, Pair<INaviInstruction, INaviCodeNode>>();
    final Map<Integer, INaviInstruction> globalCommentIdToInstruction = new HashMap<Integer, INaviInstruction>();
    private final ICodeNodeProvider dataProvider;
    private final SQLProvider sqlProvider;
    private final List<CCodeNode> nodes = new ArrayList<CCodeNode>();
    private CCodeNode currentNode;
    private InstructionLine currentLine;

    public CCodeNodeParser(ICodeNodeProvider dataProvider, List<? extends INaviModule> modules, SQLProvider sqlProvider) {
        this.dataProvider = Preconditions.checkNotNull(dataProvider, "IE00645: Data provider argument can't be null");
        this.sqlProvider = Preconditions.checkNotNull(sqlProvider, "IE00646: SQL provider argument can't be null");
        Preconditions.checkNotNull(modules, "IE01664: modules argument can not be null");
        for (INaviModule iNaviModule : modules) {
            this.modules.put(iNaviModule.getConfiguration().getId(), iNaviModule);
        }
    }

    private static OperandTreeNode createNewOperand(INaviModule module, ICodeNodeProvider dataset) throws ParserException {
        int expressionId = dataset.getExpressionTreeId();
        int type = dataset.getExpressionTreeType();
        String value = CCodeNodeParser.getValue(dataset, type);
        Integer parentId = dataset.getParentId();
        String replacementString = dataset.getReplacement();
        IAddress functionAddress = dataset.getFunctionAddress();
        Integer typeId = dataset.getSubstitutionTypeId();
        RawTypeSubstitution substitution = null;
        if (typeId != null) {
            substitution = new RawTypeSubstitution(dataset.getInstructionAddress(), dataset.getSubstitutionPosition(), expressionId, typeId, dataset.getSubstitutionPath(), dataset.getSubstitutionOffset());
        }
        Integer instanceId = dataset.getTypeInstanceId() == null ? null : dataset.getTypeInstanceId();
        int operandPosition = dataset.getOperandPosition();
        IAddress address = dataset.getInstructionAddress();
        List<CReference> references = CCodeNodeParser.parseReferences(expressionId, dataset);
        INaviReplacement replacement = CCodeNodeParser.lookupReplacement(replacementString, module, functionAddress);
        return new OperandTreeNode(expressionId, type, value, CCodeNodeParser.getParentId(parentId), replacement, references, substitution, instanceId, operandPosition, address);
    }

    private static Integer getParentId(Integer parentId) {
        return parentId == 0 ? null : parentId;
    }

    private static String getValue(ICodeNodeProvider dataset, int type) throws ParserException {
        return type == 2 ? dataset.getImmediate() : dataset.getSymbol();
    }

    private static List<CReference> parseReferences(int expressionId, ICodeNodeProvider dataset) throws ParserException {
        ArrayList<CReference> references = new ArrayList<CReference>();
        boolean hasReferences = false;
        do {
            CReference reference;
            if ((reference = dataset.getReference()) == null) {
                if (!hasReferences) break;
                dataset.prev();
                break;
            }
            hasReferences = true;
            int currentExpressionId = dataset.getExpressionTreeId();
            if (expressionId != currentExpressionId) {
                dataset.prev();
                break;
            }
            references.add(reference);
        } while (dataset.next());
        return references;
    }

    private static INaviReplacement lookupReplacement(String replacementString, INaviModule module, IAddress functionAddress) {
        INaviFunction function;
        if (functionAddress != null && (function = module.getContent().getFunctionContainer().getFunction(functionAddress)) != null) {
            return new CFunctionReplacement(function);
        }
        if (replacementString != null) {
            return new CStringReplacement(replacementString);
        }
        return null;
    }

    private void addInstruction(CCodeNode node, InstructionLine line) {
        CInstruction instruction = InstructionConverter.createInstruction(line, this.sqlProvider);
        InstructionCache.get(this.sqlProvider).addInstruction(instruction);
        this.localCommentIdToInstruction.put(line.getLocalInstructionCommentId(), new Pair<CInstruction, CCodeNode>(instruction, node));
        this.globalCommentIdToInstruction.put(line.getGlobalInstructionComment(), instruction);
        this.localCommentIdToCodeNode.put(line.getLocalNodeCommentId(), node);
        this.globalCommentIdToCodeNode.put(line.getGlobalNodeCommentId(), node);
        node.addInstruction(instruction, null);
    }

    private CCodeNode createCurrentNode(ICodeNodeProvider resultSet) throws ParserException, CPartialLoadException {
        INaviFunction function;
        int nodeId = resultSet.getNodeId();
        int moduleId = resultSet.getModule();
        IAddress parentFunction = resultSet.getParentFunction();
        INaviModule module = this.modules.get(moduleId);
        if (module == null) {
            throw new ParserException(String.format("Node with ID %d has unknown parent module with ID %d", nodeId, moduleId));
        }
        if (!module.isLoaded()) {
            try {
                module.load();
            }
            catch (CouldntLoadDataException e2) {
                throw new CPartialLoadException("E00066: The view could not be loaded because not all modules that form the view could be loaded", module);
            }
            catch (LoadCancelledException e3) {
                throw new CPartialLoadException("E00067: The view could not be loaded because it was cancelled", module);
            }
        }
        INaviFunction iNaviFunction = function = parentFunction == null ? null : module.getContent().getFunctionContainer().getFunction(parentFunction);
        if (parentFunction != null && function == null) {
            throw new ParserException(String.format("Node with ID %d has unknown parent function with address %s", nodeId, parentFunction.toHexString()));
        }
        double x2 = resultSet.getX();
        double y2 = resultSet.getY();
        double width = resultSet.getWidth();
        double height = resultSet.getHeight();
        Color color = new Color(resultSet.getColor());
        Color bordercolor = new Color(resultSet.getBorderColor());
        boolean selected = resultSet.isSelected();
        boolean visible = resultSet.isVisible();
        Integer localCodeNodeCommentId = resultSet.getLocalNodeCommentId();
        Integer globalCodeNodeCommentId = resultSet.getGlobalNodeCommentId();
        CCodeNode codeNode = new CCodeNode(nodeId, x2, y2, width, height, color, bordercolor, selected, visible, null, function, new HashSet<CTag>(), this.sqlProvider);
        if (localCodeNodeCommentId != null) {
            this.localCommentIdToCodeNode.put(localCodeNodeCommentId, codeNode);
        }
        if (globalCodeNodeCommentId != null) {
            this.globalCommentIdToCodeNode.put(globalCodeNodeCommentId, codeNode);
        }
        return codeNode;
    }

    private InstructionLine createLine(ICodeNodeProvider instructionSet) throws ParserException {
        InstructionLine row = new InstructionLine();
        row.setBasicBlock(instructionSet.getNodeId());
        row.setAddress(instructionSet.getInstructionAddress());
        row.setMnemonic(instructionSet.getMnemonic());
        row.setArchitecture(instructionSet.getInstructionArchitecture());
        int moduleId = instructionSet.getModule();
        IAddress parentFunction = instructionSet.getParentFunction();
        INaviModule module = this.modules.get(moduleId);
        if (module == null) {
            throw new ParserException(String.format("Instruction with ID %d has unknown module with ID %d", row.getId(), moduleId));
        }
        INaviFunction function = parentFunction == null ? null : module.getContent().getFunctionContainer().getFunction(parentFunction);
        row.setParentFunction(function);
        if (parentFunction != null && function == null) {
            throw new ParserException(String.format("Instruction with ID %d has unknown parent function with address %s", row.getId(), parentFunction.toHexString()));
        }
        row.setX(instructionSet.getX());
        row.setY(instructionSet.getY());
        row.setColor(new Color(instructionSet.getColor()));
        row.setBorderColor(new Color(instructionSet.getBorderColor()));
        row.setSelected(instructionSet.isSelected());
        row.setVisible(instructionSet.isVisible());
        row.setLocalNodeCommentId(instructionSet.getLocalNodeCommentId());
        row.setGlobalNodeComment(instructionSet.getGlobalNodeCommentId());
        row.setGlobalInstructionComment(instructionSet.getGlobalInstructionCommentId());
        row.setLocalInstructionComment(instructionSet.getLocalInstructionCommentId());
        row.setData(instructionSet.getData());
        row.setModule(module);
        return row;
    }

    private InstructionLine extractLine(ICodeNodeProvider dataset) throws ParserException {
        if (dataset.isAfterLast()) {
            return null;
        }
        InstructionLine row = this.createLine(dataset);
        OperandTree tree = new OperandTree(dataset.getExpressionTreeId());
        int operandPositionCounter = 0;
        do {
            IAddress currentAddress = dataset.getInstructionAddress();
            if (!row.getAddress().equals(currentAddress) || row.getBasicBlock() != dataset.getNodeId()) break;
            Integer position = dataset.getOperandPosition();
            if (position == null || position != operandPositionCounter) {
                if (tree.getNodes().size() != 0) {
                    row.getOperands().add(tree);
                }
                tree = new OperandTree(dataset.getExpressionTreeId());
                int n2 = operandPositionCounter = position == null ? 0 : position;
            }
            if (position == null) continue;
            int moduleId = dataset.getModule();
            INaviModule module = this.modules.get(moduleId);
            tree.getNodes().add(CCodeNodeParser.createNewOperand(module, dataset));
        } while (dataset.next());
        if (tree.getNodes().size() != 0) {
            row.getOperands().add(tree);
        }
        return row;
    }

    private CCodeNode extractNode(ICodeNodeProvider dataset) throws ParserException, CPartialLoadException {
        if (this.currentNode == null) {
            this.currentNode = this.createCurrentNode(dataset);
        }
        CCodeNode nodeInProcess = this.currentNode;
        while ((this.currentLine = this.extractLine(dataset)) != null) {
            if (this.currentLine.getBasicBlock() == this.currentNode.getId()) {
                this.addInstruction(this.currentNode, this.currentLine);
                continue;
            }
            this.currentNode = new CCodeNode(this.currentLine.getBasicBlock(), this.currentLine.getX(), this.currentLine.getY(), this.currentLine.getWidth(), this.currentLine.getHeight(), this.currentLine.getColor(), this.currentLine.getBorderColor(), this.currentLine.isSelected(), this.currentLine.isVisible(), null, this.currentLine.getParentFunction(), new HashSet<CTag>(), this.sqlProvider);
            this.addInstruction(this.currentNode, this.currentLine);
            return nodeInProcess;
        }
        this.currentNode = null;
        return nodeInProcess;
    }

    public List<CCodeNode> parse() throws ParserException, CPartialLoadException {
        if (!this.dataProvider.next()) {
            return new ArrayList<CCodeNode>();
        }
        while (true) {
            if (this.dataProvider.isAfterLast()) {
                if (this.currentNode == null) break;
                this.nodes.add(this.currentNode);
                break;
            }
            this.nodes.add(this.extractNode(this.dataProvider));
        }
        HashSet<Integer> allComments = Sets.newHashSet();
        allComments.addAll(this.localCommentIdToCodeNode.keySet());
        allComments.addAll(this.globalCommentIdToCodeNode.keySet());
        allComments.addAll(this.globalCommentIdToInstruction.keySet());
        allComments.addAll(this.localCommentIdToInstruction.keySet());
        try {
            HashMap<Integer, ArrayList<IComment>> commentIdToComments = this.sqlProvider.loadMultipleCommentsById(allComments);
            for (Map.Entry<Integer, ArrayList<IComment>> commentIdToComment : commentIdToComments.entrySet()) {
                if (this.localCommentIdToCodeNode.containsKey(commentIdToComment.getKey())) {
                    this.localCommentIdToCodeNode.get(commentIdToComment.getKey()).getComments().initializeLocalCodeNodeComment((List<IComment>)commentIdToComment.getValue());
                }
                if (this.globalCommentIdToCodeNode.containsKey(commentIdToComment.getKey())) {
                    this.globalCommentIdToCodeNode.get(commentIdToComment.getKey()).getComments().initializeGlobalCodeNodeComment((List<IComment>)commentIdToComment.getValue());
                }
                if (this.localCommentIdToInstruction.containsKey(commentIdToComment.getKey())) {
                    Pair<INaviInstruction, INaviCodeNode> instructionToCodeNode = this.localCommentIdToInstruction.get(commentIdToComment.getKey());
                    instructionToCodeNode.second().getComments().initializeLocalInstructionComment(instructionToCodeNode.first(), (List<IComment>)commentIdToComment.getValue());
                }
                if (!this.globalCommentIdToInstruction.containsKey(commentIdToComment.getKey())) continue;
                this.globalCommentIdToInstruction.get(commentIdToComment.getKey()).initializeGlobalComment(commentIdToComment.getValue());
            }
        }
        catch (CouldntLoadDataException exception) {
            throw new CPartialLoadException("Error: Comments could not be loaded.", null);
        }
        return this.nodes;
    }
}

