/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Gui.Users.CUser;
import com.google.security.zynamics.binnavi.Gui.Users.Interfaces.IUser;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class CGenericSQLUserFunctions {
    public static IUser addUser(SQLProvider provider, String userName) throws CouldntSaveDataException {
        Preconditions.checkNotNull(provider, "IE00081: provider argument can not be null");
        Preconditions.checkNotNull(userName, "IE00087: userName argument can not be null");
        Connection connection = provider.getConnection().getConnection();
        String query = "INSERT INTO bn_users VALUES (DEFAULT, ?, null, null) RETURNING user_id;";
        CUser user2 = null;
        try (PreparedStatement statement = connection.prepareStatement("INSERT INTO bn_users VALUES (DEFAULT, ?, null, null) RETURNING user_id;");){
            statement.setString(1, userName);
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                user2 = new CUser(resultSet.getInt(1), userName);
            }
        }
        catch (SQLException exception) {
            throw new CouldntSaveDataException(exception);
        }
        return user2;
    }

    public static void deleteUser(SQLProvider provider, IUser user2) throws CouldntDeleteException {
        Preconditions.checkNotNull(provider, "IE00088: provider argument can not be null");
        Preconditions.checkNotNull(user2, "IE00106: user argument can not be null");
        Connection connection = provider.getConnection().getConnection();
        String query = "DELETE FROM bn_users WHERE user_id = ?;";
        try (PreparedStatement statement = connection.prepareStatement("DELETE FROM bn_users WHERE user_id = ?;");){
            statement.setInt(1, user2.getUserId());
            statement.execute();
        }
        catch (SQLException exception) {
            throw new CouldntDeleteException(exception);
        }
    }

    public static IUser editUserName(SQLProvider provider, IUser user2, String userName) throws CouldntSaveDataException {
        Preconditions.checkNotNull(provider, "IE00117: provider argument can not be null");
        Preconditions.checkNotNull(user2, "IE00118: user argument can not be null");
        Preconditions.checkNotNull(userName, "IE00205: userName argument can not be null");
        Connection connection = provider.getConnection().getConnection();
        String query = "UPDATE bn_users SET user_name = ? WHERE user_id = ?;";
        try (PreparedStatement statement = connection.prepareStatement("UPDATE bn_users SET user_name = ? WHERE user_id = ?;");){
            statement.setString(1, userName);
            statement.setInt(2, user2.getUserId());
            statement.execute();
        }
        catch (SQLException exception) {
            throw new CouldntSaveDataException(exception);
        }
        return new CUser(user2.getUserId(), userName);
    }

    public static List<IUser> loadUsers(SQLProvider provider) throws CouldntLoadDataException {
        Preconditions.checkNotNull(provider, "IE00206: provider argument can not be null");
        CConnection connection = provider.getConnection();
        String query = "SELECT user_id, user_name FROM bn_users";
        ArrayList<IUser> users = new ArrayList<IUser>();
        try (ResultSet resultSet = connection.executeQuery("SELECT user_id, user_name FROM bn_users", true);){
            while (resultSet.next()) {
                int userId = resultSet.getInt(1);
                String userName = resultSet.getString(2);
                users.add(new CUser(userId, userName));
            }
        }
        catch (SQLException exception) {
            throw new CouldntLoadDataException(exception);
        }
        return users;
    }
}

