/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Interfaces.DatabaseManagerListener;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabaseManager;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class CDatabaseManager
implements IDatabaseManager,
Iterable<IDatabase> {
    private static CDatabaseManager m_instance = new CDatabaseManager();
    private final List<IDatabase> m_databases = new ArrayList<IDatabase>();
    private final ListenerProvider<DatabaseManagerListener> m_listeners = new ListenerProvider();

    private CDatabaseManager() {
    }

    public static CDatabaseManager instance() {
        return m_instance;
    }

    @Override
    public IDatabase addDatabase(IDatabase database) {
        Preconditions.checkNotNull(database, "IE00694: Database argument can't be null");
        Preconditions.checkArgument(!this.m_databases.contains(database), "IE00695: Database object can't be added more than once");
        this.m_databases.add(database);
        for (DatabaseManagerListener listener : this.m_listeners) {
            try {
                listener.addedDatabase(this, database);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        return database;
    }

    @Override
    public void addListener(DatabaseManagerListener listener) {
        this.m_listeners.addListener(listener);
    }

    @Override
    public Iterator<IDatabase> iterator() {
        return this.m_databases.iterator();
    }

    @Override
    public void moveDatabase(IDatabase database, int index) {
        Preconditions.checkNotNull(database, "IE00696: Database argument can't be null");
        Preconditions.checkArgument(this.m_databases.remove(database), "IE00697: The database is not known to the database manager");
        this.m_databases.add(index - 1, database);
        for (DatabaseManagerListener listener : this.m_listeners) {
            try {
                listener.reorderedDatabases(this, database, index);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    @Override
    public void removeDatabase(IDatabase database) {
        Preconditions.checkNotNull(database, "IE00698: Database argument can't be null");
        Preconditions.checkArgument(this.m_databases.remove(database), "IE00699: The database is not known to the database manager");
        for (DatabaseManagerListener listener : this.m_listeners) {
            try {
                listener.removedDatabase(this, database);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    @Override
    public void removeListener(DatabaseManagerListener listener) {
        this.m_listeners.removeListener(listener);
    }
}

