/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.CDatabaseConfiguration;
import com.google.security.zynamics.binnavi.Database.CDatabaseListenerAdapter;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntConnectException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntInitializeDatabaseException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDriverException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntUpdateDatabaseException;
import com.google.security.zynamics.binnavi.Database.Exceptions.InvalidDatabaseException;
import com.google.security.zynamics.binnavi.Database.Exceptions.InvalidDatabaseVersionException;
import com.google.security.zynamics.binnavi.Database.Exceptions.InvalidExporterDatabaseFormatException;
import com.google.security.zynamics.binnavi.Database.Exceptions.LoadCancelledException;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabaseListener;
import com.google.security.zynamics.binnavi.Database.LoadEvents;
import com.google.security.zynamics.binnavi.Gui.Database.implementations.CDatabaseCreator;
import com.google.security.zynamics.binnavi.Gui.Progress.CDefaultProgressOperation;
import com.google.security.zynamics.binnavi.Gui.Progress.CGlobalProgressManager;
import com.google.security.zynamics.binnavi.Gui.Progress.IProgressOperation;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CProgressPanel;
import java.awt.Window;

public final class CDatabaseLoader {
    private CDatabaseLoader() {
    }

    private static String getErrorCode(CouldntUpdateDatabaseException upgradeException) {
        return String.valueOf(upgradeException.getErrorCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadDatabase(Window parent, IDatabase database) {
        block30: {
            CDatabaseLoaderOperation operation = new CDatabaseLoaderOperation(database);
            try {
                database.connect();
                database.load();
            }
            catch (CouldntLoadDriverException exception) {
                String message2 = "E00012: Database driver could not be loaded";
                String description = CUtilityFunctions.createDescription(String.format("BinNavi could not create a database connection because the database driver '%s' could not be loaded", database.getConfiguration().getDriver()), new String[]{"The database driver string is wrong.", "The database driver file could not be found."}, new String[]{"BinNavi can not load data from the given database until the problem is resolved."});
                NaviErrorDialog.show(parent, "E00012: Database driver could not be loaded", description, exception);
            }
            catch (CouldntLoadDataException exception) {
                String message3 = "E00014: Could not load data from the database";
                String description = CUtilityFunctions.createDescription("An error occurred when loading data from the database.", new String[]{"The connection to the database was dropped while the data was loaded.", "The database contains inconsistent information."}, new String[]{"Close the database and open it again. Maybe close and re-start BinNavi too. If the program persists, please contact the BinNavi support."});
                NaviErrorDialog.show(parent, "E00014: Could not load data from the database", description, exception);
            }
            catch (InvalidDatabaseException exception) {
                String message4 = "E00015: Database is in an inconsistent state";
                String description = CUtilityFunctions.createDescription("The selected database contains an invalid combination of BinNavi tables.", new String[]{"An earlier connection attempt failed and left the database in an inconsistent state.", "Some BinNavi tables were deleted accidentally by an outside program."}, new String[]{"BinNavi can not use this database anymore. If the database is empty, please delete the database and create a new database to work with BinNavi. If the database already contains data please contact the BinNavi support."});
                NaviErrorDialog.show(parent, "E00015: Database is in an inconsistent state", description, exception);
            }
            catch (CouldntInitializeDatabaseException exception) {
                String message5 = "E00016: Database could not be initialized";
                String description = CUtilityFunctions.createDescription("BinNavi could not initialize the tables required for storing disassembly data in the database.", new String[]{"There might have been a communication problem with the database."}, new String[]{"The database is probably corrupted at this point. It is recommended to delete the database. Afterwards you can try again with a fresh database. If you do not want to do this please contact the BinNavi support to find out what other options exist for you."});
                NaviErrorDialog.show(parent, "E00016: Database could not be initialized", description, exception);
            }
            catch (InvalidExporterDatabaseFormatException exception) {
                String message6 = "E00017: Database has invalid exporter tables";
                String description = CUtilityFunctions.createDescription("BinNavi could not load data from the selected database because the database contains invalid exporter tables", new String[]{"The database is too old to use with BinNavi."}, new String[]{"It is recommended to create a database for this version of BinNavi. If you do not want to do this please contact the BinNavi support to find out what other options exist for you."});
                NaviErrorDialog.show(parent, "E00017: Database has invalid exporter tables", description, exception);
            }
            catch (InvalidDatabaseVersionException exception) {
                String exceptionVersion = exception.getVersion().getString();
                if (!exceptionVersion.equals("4.0.0") || !exceptionVersion.equals("5.0.0")) {
                    CMessageBox.showInformation(parent, String.format("You are trying to connect to an outdated BinNavi %s database.\n\nUnfortunately you can not upgrade this database. Please create a new database and export your modules again.", exceptionVersion));
                    break block30;
                }
                CMessageBox.showInformation(parent, String.format("You are trying to connect to an outdated BinNavi %s database.\n\nYou have the option to update the database.", exceptionVersion));
                if (0 == CMessageBox.showYesNoQuestion(parent, "Do you want to upgrade the database now?\n\n(The upgrade process can take very long depending on the size of your current database)\n\n(Make sure that the identity field contains a user name)")) {
                    CDefaultProgressOperation updateOperation = new CDefaultProgressOperation("Upgrading database", true, false);
                    updateOperation.getProgressPanel().setText("Upgrading database");
                    try {
                        database.update();
                        database.close();
                    }
                    catch (CouldntUpdateDatabaseException upgradeException) {
                        CUtilityFunctions.logException(upgradeException);
                        String message7 = "E00018: Database could not be upgraded";
                        String description = CUtilityFunctions.createDescription(String.format("BinNavi could not upgrade the database (database error %d). This is a serious problem because the database could be left in an inconsistent state. Please try to fix the problem that led to the error and try to update the database again.", upgradeException.getErrorCode()), new String[]{CDatabaseLoader.getErrorCode(upgradeException)}, new String[]{"Please note that nobody must work with this database until the database conversion process is complete. If someone works with the database in its current state, partial or total data loss could happen."});
                        NaviErrorDialog.show(parent, "E00018: Database could not be upgraded", description, exception);
                    }
                    finally {
                        updateOperation.stop();
                    }
                    CDatabaseLoader.loadDatabase(parent, database);
                    break block30;
                }
                database.close();
            }
            catch (CouldntConnectException exception) {
                CDatabaseConfiguration config2 = database.getConfiguration();
                if (exception.getSqlState().equalsIgnoreCase("28P01")) {
                    CMessageBox.showInformation(parent, String.format("The password for user '%s' on database '%s' is invalid", config2.getUser(), config2.getUrl()));
                    return;
                }
                if (exception.getSqlState().equalsIgnoreCase("3D000")) {
                    if (0 == CMessageBox.showYesNoCancelQuestion(parent, String.format("The database '%s' does not exist. Do you want to create it now?", config2.getUrl()))) {
                        CDatabaseCreator.createDatabase(parent, config2);
                    }
                } else {
                    String message8 = "E00013: Database connection could not be established";
                    String description = CUtilityFunctions.createDescription(String.format("BinNavi could not connect to the database '%s'", database.getConfiguration().getName()), new String[]{exception.getMessage()}, new String[]{"BinNavi can not load data from the given database until the problem is resolved."});
                    NaviErrorDialog.show(parent, "E00013: Database connection could not be established", description, exception);
                }
            }
            catch (LoadCancelledException loadCancelledException) {
            }
            finally {
                operation.stop();
            }
        }
    }

    private static class CDatabaseLoaderOperation
    implements IProgressOperation {
        private final IDatabase m_database;
        private final CProgressPanel m_loadProgressPanel = new CProgressPanel("", false, true){

            @Override
            protected void closeRequested() {
                this.setText("Cancelling database loading");
                m_continue = false;
            }
        };
        private boolean m_continue = true;
        private static final String[] DESCRIPTION_TEXTS = new String[]{"Connecting to the database", "Checking exporter table format", "Checking BinNavi databases tables status", "Initializing BinNavi database tables", "Determining BinNavi database version", "Loading debuggers", "Loading modules", "Loading raw modules", "Loading projects", "Loading node tags", "Loading view tags", "Loading data", "Loading users", "Finished loading"};
        private final IDatabaseListener m_databaseListener = new CDatabaseListenerAdapter(){
            private boolean m_first = true;

            @Override
            public boolean loading(LoadEvents event, int counter) {
                if (!m_continue) {
                    m_continue = true;
                    return false;
                }
                m_loadProgressPanel.next();
                if (event == LoadEvents.LOADING_FINISHED) {
                    m_loadProgressPanel.setVisible(false);
                    this.m_first = true;
                    m_continue = true;
                } else if (this.m_first) {
                    m_loadProgressPanel.setValue(counter);
                    this.m_first = false;
                }
                m_loadProgressPanel.setText(DESCRIPTION_TEXTS[event.ordinal()]);
                return true;
            }
        };

        public CDatabaseLoaderOperation(IDatabase database) {
            this.m_database = database;
            this.m_loadProgressPanel.start();
            database.addListener(this.m_databaseListener);
            CGlobalProgressManager.instance().add(this);
        }

        @Override
        public String getDescription() {
            return "Loading database";
        }

        @Override
        public CProgressPanel getProgressPanel() {
            this.m_loadProgressPanel.setMaximum(LoadEvents.values().length);
            this.m_loadProgressPanel.setVisible(true);
            return this.m_loadProgressPanel;
        }

        public void stop() {
            this.m_loadProgressPanel.stop();
            this.m_database.removeListener(this.m_databaseListener);
            CGlobalProgressManager.instance().remove(this);
        }
    }
}

