/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabaseListener;
import com.google.security.zynamics.zylib.general.ListenerProvider;

public final class CDatabaseConfiguration {
    private String m_identity;
    private final IDatabase m_database;
    private final ListenerProvider<IDatabaseListener> m_listeners;
    private String m_description;
    private String m_driver;
    private String m_host;
    private String m_name;
    private String m_user;
    private String m_password;
    private boolean m_autoConnect;
    private boolean m_savePassword;

    public CDatabaseConfiguration(IDatabase database, ListenerProvider<IDatabaseListener> listeners, String description, String driver, String host, String name, String user2, String password, String identity, boolean autoConnect, boolean savePassword) {
        this.m_database = Preconditions.checkNotNull(database, "IE02401: database argument can not be null");
        this.m_listeners = Preconditions.checkNotNull(listeners, "IE02402: listeners argument can not be null");
        this.m_description = Preconditions.checkNotNull(description, "IE02403: description argument can not be null");
        this.m_driver = Preconditions.checkNotNull(driver, "IE02404: driver argument can not be null");
        this.m_host = Preconditions.checkNotNull(host, "IE02405: host argument can not be null");
        this.m_name = Preconditions.checkNotNull(name, "IE02406: name argument can not be null");
        this.m_user = Preconditions.checkNotNull(user2, "IE02407: user argument can not be null");
        this.m_password = Preconditions.checkNotNull(password, "IE02408: password argument can not be null");
        this.m_identity = Preconditions.checkNotNull(identity, "IE00065: identity argument can not be null");
        if (this.m_identity.isEmpty()) {
            this.m_identity = "identity";
        }
        this.m_autoConnect = autoConnect;
        this.m_savePassword = savePassword;
    }

    public String getDescription() {
        return this.m_description;
    }

    public String getDriver() {
        return this.m_driver;
    }

    public String getHost() {
        return this.m_host;
    }

    public String getIdentity() {
        return this.m_identity;
    }

    public String getName() {
        return this.m_name;
    }

    public String getPassword() {
        return this.m_password;
    }

    public String getUrl() {
        return String.format("jdbc:postgresql://%s/%s", this.m_host, this.m_name);
    }

    public String getUser() {
        return this.m_user;
    }

    public boolean isAutoConnect() {
        return this.m_autoConnect;
    }

    public boolean isSavePassword() {
        return this.m_savePassword;
    }

    public void setAutoConnect(boolean autoConnect) {
        if (autoConnect == this.isAutoConnect()) {
            return;
        }
        this.m_autoConnect = autoConnect;
        for (IDatabaseListener listener : this.m_listeners) {
            try {
                listener.changedAutoConnect(this.m_database, autoConnect);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void setDescription(String description) {
        Preconditions.checkNotNull(description, "IE00689: Database description can not be null");
        if (description.equals(this.m_description)) {
            return;
        }
        this.m_description = description;
        for (IDatabaseListener listener : this.m_listeners) {
            try {
                listener.changedDescription(this.m_database, description);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void setDriver(String driver) {
        Preconditions.checkNotNull(driver, "IE00690: Database driver can not be null");
        if (driver.equals(this.getDriver())) {
            return;
        }
        this.m_driver = driver;
        for (IDatabaseListener listener : this.m_listeners) {
            try {
                listener.changedDriver(this.m_database, driver);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void setHost(String host) {
        Preconditions.checkNotNull(host, "IE00040: Database host can not be null");
        if (host.equals(this.m_host)) {
            return;
        }
        this.m_host = host;
        for (IDatabaseListener listener : this.m_listeners) {
            try {
                listener.changedHost(this.m_database, host);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void setIdentity(String identity) {
        Preconditions.checkNotNull(identity, "IE00067: identity argument can not be null");
        if (identity.equals(this.m_identity)) {
            return;
        }
        this.m_identity = identity;
        for (IDatabaseListener listener : this.m_listeners) {
            try {
                listener.changedIdentity(this.m_database, identity);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void setName(String name) {
        Preconditions.checkNotNull(name, "IE00159: Database name can not be null");
        if (name.equals(this.m_name)) {
            return;
        }
        this.m_name = name;
        for (IDatabaseListener listener : this.m_listeners) {
            try {
                listener.changedName(this.m_database, name);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void setPassword(String password) {
        Preconditions.checkNotNull(password, "IE00691: Database password can not be null");
        if (password.equals(this.getPassword())) {
            return;
        }
        this.m_password = password;
        for (IDatabaseListener listener : this.m_listeners) {
            try {
                listener.changedPassword(this.m_database, password);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void setSavePassword(boolean savePassword) {
        if (savePassword == this.isSavePassword()) {
            return;
        }
        this.m_savePassword = savePassword;
        for (IDatabaseListener listener : this.m_listeners) {
            try {
                listener.changedSavePassword(this.m_database, savePassword);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void setUser(String user2) {
        Preconditions.checkNotNull(user2, "IE00692: Database user can not be null");
        if (user2.equals(this.getUser())) {
            return;
        }
        this.m_user = user2;
        for (IDatabaseListener listener : this.m_listeners) {
            try {
                listener.changedUser(this.m_database, user2);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }
}

