/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.CDatabaseConfiguration;
import com.google.security.zynamics.binnavi.Database.CDatabaseConnection;
import com.google.security.zynamics.binnavi.Database.CDatabaseContent;
import com.google.security.zynamics.binnavi.Database.DatabaseVersion;
import com.google.security.zynamics.binnavi.Database.DefaultDatabaseLoadProgressReporter;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntConnectException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntInitializeDatabaseException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDriverException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntUpdateDatabaseException;
import com.google.security.zynamics.binnavi.Database.Exceptions.InvalidDatabaseException;
import com.google.security.zynamics.binnavi.Database.Exceptions.InvalidDatabaseVersionException;
import com.google.security.zynamics.binnavi.Database.Exceptions.InvalidExporterDatabaseFormatException;
import com.google.security.zynamics.binnavi.Database.Exceptions.LoadCancelledException;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabaseContent;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabaseListener;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabaseLoadProgressReporter;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Database.LoadEvents;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.NotificationChannel;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.PostgreSQLNotificationProvider;
import com.google.security.zynamics.binnavi.Gui.Users.CUserManager;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.Tagging.CTagManager;
import com.google.security.zynamics.binnavi.Tagging.TagType;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplateManager;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebuggerTemplateManagerListener;
import com.google.security.zynamics.binnavi.disassembly.IDatabaseObject;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.binnavi.disassembly.INaviRawModule;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.types.trees.Tree;
import com.google.security.zynamics.zylib.types.trees.TreeNode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public final class CDatabase
implements IDatabase,
IDatabaseObject {
    private final CDatabaseConfiguration description;
    private CDatabaseContent content = null;
    private final ListenerProvider<IDatabaseListener> listeners = new ListenerProvider();
    private SQLProvider provider;
    private final InternalDebuggerTemplateListener internalDebuggerTemplateListener = new InternalDebuggerTemplateListener();
    private final IDatabaseLoadProgressReporter<LoadEvents> loadReporter = new DefaultDatabaseLoadProgressReporter<LoadEvents>(){

        @Override
        protected boolean report(LoadEvents event, int counter) {
            boolean cont = true;
            for (IDatabaseListener listener : CDatabase.this.listeners) {
                cont &= listener.loading(event, counter);
            }
            return cont;
        }
    };
    private boolean isConnecting = false;
    private boolean isLoading = false;

    public CDatabase(String description, String driver, String host, String name, String user2, String password, String identity, boolean savePassword, boolean autoConnect) {
        Preconditions.checkNotNull(description, "IE00656: Database description can not be null");
        Preconditions.checkNotNull(driver, "IE00657: Database driver can not be null");
        Preconditions.checkNotNull(host, "IE01148: Database host can not be null");
        Preconditions.checkNotNull(name, "IE00658: Database name can not be null");
        Preconditions.checkNotNull(user2, "IE00659: Database user can not be null");
        Preconditions.checkNotNull(password, "IE00660: Database password can not be null");
        Preconditions.checkNotNull(identity, "IE00064: identity argument can not be null");
        this.description = new CDatabaseConfiguration(this, this.listeners, description, driver, host, name, user2, password, identity, autoConnect, savePassword);
    }

    private CTagManager loadNodeTagManager() {
        try {
            return this.provider.loadTagManager(TagType.NODE_TAG);
        }
        catch (CouldntLoadDataException e2) {
            CUtilityFunctions.logException(e2);
            CTag root = new CTag(0, "Root Node Tag", "", TagType.NODE_TAG, this.provider);
            Tree<CTag> tree = new Tree<CTag>(new TreeNode<CTag>(root));
            return new CTagManager(tree, TagType.NODE_TAG, this.provider);
        }
    }

    private CUserManager loadUserManager() throws CouldntLoadDataException {
        String userName;
        CUserManager userManager = CUserManager.get(this.provider);
        if (userManager.containsUserName(userName = this.getConfiguration().getIdentity())) {
            userManager.setCurrentActiveUser(userManager.getUserByUserName(userName));
        } else {
            try {
                userManager.setCurrentActiveUser(userManager.addUser(userName));
            }
            catch (CouldntSaveDataException e2) {
                CUtilityFunctions.logException(e2);
                throw new CouldntLoadDataException(e2);
            }
        }
        return userManager;
    }

    private CTagManager loadViewTagManager() {
        try {
            return this.provider.loadTagManager(TagType.VIEW_TAG);
        }
        catch (CouldntLoadDataException e2) {
            CUtilityFunctions.logException(e2);
            CTag root = new CTag(0, "Root View Tag", "", TagType.VIEW_TAG, this.provider);
            Tree<CTag> tree = new Tree<CTag>(new TreeNode<CTag>(root));
            return new CTagManager(tree, TagType.VIEW_TAG, this.provider);
        }
    }

    @Override
    public void addListener(IDatabaseListener listener) {
        this.listeners.addListener(listener);
    }

    @Override
    public boolean close() {
        Preconditions.checkArgument(this.isConnected(), "IE00664: Can not disconnect from the database because it is not connected");
        if (PostgreSQLNotificationProvider.contains(this.provider)) {
            PostgreSQLNotificationProvider.get(this.provider).unInitialize();
        }
        for (IDatabaseListener listener : this.listeners) {
            try {
                if (listener.closingDatabase(this)) continue;
                return false;
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        if (this.isLoaded()) {
            for (INaviProject project : this.content.getProjects()) {
                if (!project.isLoaded() || project.close()) continue;
                return false;
            }
        }
        this.provider.close();
        this.provider = null;
        for (IDatabaseListener listener : this.listeners) {
            try {
                listener.closedDatabase(this);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        this.content = null;
        return true;
    }

    @Override
    public void connect() throws CouldntLoadDriverException, CouldntConnectException, InvalidDatabaseException, CouldntInitializeDatabaseException, InvalidExporterDatabaseFormatException, LoadCancelledException {
        this.loadReporter.start();
        this.isConnecting = true;
        try {
            Pair<CConnection, SQLProvider> connectionData = CDatabaseConnection.connect(this.description, this.loadReporter);
            this.provider = connectionData.second();
        }
        catch (CouldntLoadDriverException exception) {
            this.loadReporter.report(LoadEvents.LOADING_FINISHED);
            throw exception;
        }
        catch (CouldntConnectException exception) {
            this.loadReporter.report(LoadEvents.LOADING_FINISHED);
            throw exception;
        }
        catch (CouldntInitializeDatabaseException exception) {
            this.loadReporter.report(LoadEvents.LOADING_FINISHED);
            throw exception;
        }
        catch (InvalidDatabaseException exception) {
            this.loadReporter.report(LoadEvents.LOADING_FINISHED);
            throw exception;
        }
        catch (InvalidExporterDatabaseFormatException exception) {
            this.loadReporter.report(LoadEvents.LOADING_FINISHED);
            throw exception;
        }
        catch (LoadCancelledException exception) {
            this.loadReporter.report(LoadEvents.LOADING_FINISHED);
            throw exception;
        }
        finally {
            this.isConnecting = false;
        }
        for (IDatabaseListener listener : this.listeners) {
            try {
                listener.openedDatabase(this);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        try {
            PostgreSQLNotificationProvider notificationProvider = PostgreSQLNotificationProvider.initialize(this.provider, this.description);
            notificationProvider.listen(NotificationChannel.all());
            notificationProvider.startPolling();
        }
        catch (SQLException exception) {
            NaviLogger.severe("Error: Could not establish a channel for receiving notifications from the database %s", exception);
        }
    }

    @Override
    public ResultSet executeQuery(String query) throws SQLException {
        Preconditions.checkNotNull(query, "IE00729: Query argument can not be null");
        return this.provider.executeQuery(query);
    }

    @Override
    public CDatabaseConfiguration getConfiguration() {
        return this.description;
    }

    @Override
    public IDatabaseContent getContent() {
        return this.content;
    }

    @Override
    public boolean inSameDatabase(IDatabaseObject provider) {
        return provider.inSameDatabase(provider);
    }

    @Override
    public boolean inSameDatabase(SQLProvider provider) {
        return this.provider == provider;
    }

    @Override
    public boolean isConnected() {
        return this.provider != null;
    }

    @Override
    public boolean isConnecting() {
        return this.isConnecting;
    }

    @Override
    public boolean isLoaded() {
        return this.content != null;
    }

    @Override
    public boolean isLoading() {
        return this.isLoading;
    }

    @Override
    public void load() throws CouldntLoadDataException, InvalidDatabaseVersionException, LoadCancelledException {
        Preconditions.checkArgument(this.isConnected(), "IE00686: Not connected to the database");
        try {
            DatabaseVersion currentVersion;
            if (!this.loadReporter.report(LoadEvents.LOADING_DATABASE)) {
                throw new LoadCancelledException();
            }
            if (!this.loadReporter.report(LoadEvents.DETERMINING_DATABASE_VERSION)) {
                throw new LoadCancelledException();
            }
            DatabaseVersion databaseVersion = this.provider.getDatabaseVersion();
            if (databaseVersion.compareTo(currentVersion = new DatabaseVersion("6.0.1")) != 0 && currentVersion.needsUpgrading(databaseVersion)) {
                throw new InvalidDatabaseVersionException(databaseVersion);
            }
            if (!this.loadReporter.report(LoadEvents.LOADING_USERS)) {
                throw new LoadCancelledException();
            }
            this.loadUserManager();
            if (!this.loadReporter.report(LoadEvents.LOADING_VIEW_TAGS)) {
                throw new LoadCancelledException();
            }
            CTagManager viewTagManager = this.loadViewTagManager();
            if (!this.loadReporter.report(LoadEvents.LOADING_NODE_TAGS)) {
                throw new LoadCancelledException();
            }
            CTagManager nodeTagManager = this.loadNodeTagManager();
            if (!this.loadReporter.report(LoadEvents.LOADING_DEBUGGERS)) {
                throw new LoadCancelledException();
            }
            DebuggerTemplateManager debuggerDescriptionManager = this.provider.loadDebuggers();
            if (!this.loadReporter.report(LoadEvents.LOADING_PROJECTS)) {
                throw new LoadCancelledException();
            }
            List<INaviProject> projects = this.provider.loadProjects();
            if (!this.loadReporter.report(LoadEvents.LOADING_RAW_MODULES)) {
                throw new LoadCancelledException();
            }
            List<INaviRawModule> rawModules = this.provider.loadRawModules();
            if (!this.loadReporter.report(LoadEvents.LOADING_MODULES)) {
                throw new LoadCancelledException();
            }
            List<INaviModule> modules = this.provider.loadModules();
            debuggerDescriptionManager.addListener(this.internalDebuggerTemplateListener);
            this.content = new CDatabaseContent(this.provider, this, this.listeners, projects, modules, rawModules, viewTagManager, nodeTagManager, debuggerDescriptionManager);
        }
        catch (CouldntLoadDataException exception) {
            this.loadReporter.report(LoadEvents.LOADING_FINISHED);
            this.close();
            throw exception;
        }
        catch (InvalidDatabaseVersionException exception) {
            this.loadReporter.report(LoadEvents.LOADING_FINISHED);
            throw exception;
        }
        catch (LoadCancelledException exception) {
            this.loadReporter.report(LoadEvents.LOADING_FINISHED);
            this.close();
            throw exception;
        }
        finally {
            this.isLoading = false;
        }
        this.content.initializeRawModules(this.content.getModules(), this.content.getRawModules());
        for (IDatabaseListener listener : this.listeners) {
            try {
                listener.loadedDatabase(this);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        this.loadReporter.report(LoadEvents.LOADING_FINISHED);
    }

    @Override
    public void removeListener(IDatabaseListener listener) {
        this.listeners.removeListener(listener);
    }

    @Override
    public void update() throws CouldntUpdateDatabaseException {
        this.provider.updateDatabase();
    }

    private class InternalDebuggerTemplateListener
    implements IDebuggerTemplateManagerListener {
        private InternalDebuggerTemplateListener() {
        }

        @Override
        public void addedDebugger(DebuggerTemplateManager manager, DebuggerTemplate debugger) {
        }

        @Override
        public void removedDebugger(DebuggerTemplateManager manager, DebuggerTemplate debugger) {
            if (!CDatabase.this.isLoaded()) {
                return;
            }
            for (INaviProject project : CDatabase.this.content.getProjects()) {
                try {
                    if (!project.getConfiguration().hasDebugger(debugger)) continue;
                    project.getConfiguration().removeDebugger(debugger);
                }
                catch (CouldntSaveDataException e2) {
                    CUtilityFunctions.logException(e2);
                }
            }
            for (INaviModule module : CDatabase.this.content.getModules()) {
                try {
                    if (module.getConfiguration().getDebuggerTemplate() != debugger) continue;
                    module.getConfiguration().setDebuggerTemplate(null);
                }
                catch (CouldntSaveDataException e3) {
                    CUtilityFunctions.logException(e3);
                }
            }
        }
    }
}

