/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.CDatabaseConfiguration;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDriverException;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.GregorianCalendar;
import java.util.Properties;

public final class CConnection {
    private static final boolean m_performanceOutput = true;
    private static final int MAXIMUM_OUTPUT_SIZE = 2048;
    private static CDatabaseConfiguration m_databaseConfiguration;
    private static Properties m_properties;
    private Connection m_connection;
    private long m_debugQueryCount = 0L;

    public CConnection(CDatabaseConfiguration databaseConfiguration) throws CouldntLoadDriverException, SQLException {
        m_databaseConfiguration = Preconditions.checkNotNull(databaseConfiguration, "IE02409: m_databaseConfiguration argument can not be null");
        String url = Preconditions.checkNotNull(databaseConfiguration.getUrl(), "IE03409: m_databaseConfiguration.getUrl() argument can not be null");
        Preconditions.checkNotNull(databaseConfiguration.getName(), "IE03410: m_databaseConfiguration.getName() argument can not be null");
        String user2 = Preconditions.checkNotNull(databaseConfiguration.getUser(), "IE03411: databaseConfiguration.getUser() argument can not be null");
        String password = Preconditions.checkNotNull(databaseConfiguration.getPassword(), "IE03412: databaseConfiguration.getPassword() argument can not be null");
        m_properties = new Properties();
        m_properties.put("user", user2);
        m_properties.put("password", password);
        m_properties.put("application_name", "BinNavi");
        this.testDriver();
        this.connect(url, m_properties);
    }

    private void connect(String databaseUrl, Properties properties) throws SQLException {
        if (this.m_connection != null) {
            this.closeConnection();
        }
        try {
            this.m_connection = DriverManager.getConnection(databaseUrl, properties);
        }
        catch (SQLException exception) {
            NaviLogger.severe("Error: Connection to the database server could not be established: %s", exception);
            throw exception;
        }
    }

    private String getDatabaseUrl(String baseUrl, String databaseName) {
        return baseUrl.endsWith("/") ? String.format("%s%s", baseUrl, databaseName) : String.format("%s/%s", baseUrl, databaseName);
    }

    private void testDriver() throws CouldntLoadDriverException {
        try {
            Class.forName(m_databaseConfiguration.getDriver());
        }
        catch (ClassNotFoundException exception) {
            String string2 = m_databaseConfiguration.getDriver();
            throw new CouldntLoadDriverException(new StringBuilder(39 + String.valueOf(string2).length()).append("E00044: Couldn't load database driver ").append(string2).append(".").toString());
        }
    }

    public void closeConnection() {
        try {
            if (this.m_connection != null) {
                this.m_connection.close();
            }
        }
        catch (SQLException exception) {
            NaviLogger.severe("Error: Closing the database connection failed with exception: %s", exception);
        }
        this.m_connection = null;
    }

    public ResultSet executeQuery(String query, boolean retry) throws SQLException {
        if (!this.isConnectionValid()) {
            this.connect(this.getURL(), m_properties);
        }
        ++this.m_debugQueryCount;
        long militime = 0L;
        militime = new GregorianCalendar().getTimeInMillis();
        ResultSet retSet = null;
        PreparedStatement prep = this.m_connection.prepareStatement(query, 1004, 1007);
        try {
            retSet = prep.executeQuery();
        }
        catch (SQLException error) {
            NaviLogger.severe(String.format("<%d>    <%d ms>    %s", this.m_debugQueryCount, Math.abs(militime), query), new Object[0]);
            NaviLogger.severe("Error: Query failed on %s try: %s", retry ? "first" : "second", query);
            if ((error.getSQLState() == "08003" || error.getSQLState() == "08006") && retry) {
                this.connect(this.getDatabaseUrl(m_databaseConfiguration.getUrl(), m_databaseConfiguration.getName()), m_properties);
                this.executeQuery(query, false);
            }
            throw error;
        }
        NaviLogger.info("<%d>    <%d ms>    %s", this.m_debugQueryCount, Math.abs(militime -= new GregorianCalendar().getTimeInMillis()), query.substring(0, Math.min(2048, query.length())));
        return retSet;
    }

    public int executeUpdate(String query, boolean retry) throws SQLException {
        ++this.m_debugQueryCount;
        long militime = 0L;
        militime = new GregorianCalendar().getTimeInMillis();
        int result = 0;
        try (PreparedStatement prep = this.m_connection.prepareStatement(query);){
            result = prep.executeUpdate();
        }
        catch (SQLException error) {
            NaviLogger.severe("<%d>    <%d ms>    %s", this.m_debugQueryCount, Math.abs(militime), query);
            NaviLogger.severe("Error: Query failed on %s try: %s", retry ? "first" : "second", query);
            if (error.getSQLState() == "08003" && retry) {
                this.connect(this.getDatabaseUrl(m_databaseConfiguration.getUrl(), m_databaseConfiguration.getName()), m_properties);
                this.executeUpdate(query, false);
            }
            throw error;
        }
        NaviLogger.info("<%d>    <%d ms>    %s", this.m_debugQueryCount, Math.abs(militime -= new GregorianCalendar().getTimeInMillis()), query.substring(0, Math.min(2048, query.length())));
        return result;
    }

    public Connection getConnection() {
        return this.m_connection;
    }

    public String getURL() {
        return m_databaseConfiguration.getUrl();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isConnectionValid() {
        if (this.m_connection == null) {
            return false;
        }
        try (Statement statement = this.m_connection.createStatement();){
            statement.execute("SELECT 1;");
            boolean bl2 = true;
            return bl2;
        }
        catch (SQLException exception) {
            NaviLogger.severe("Error: The connection to the database is in an invalid state as statement creation failed with: %s", exception);
            return false;
        }
    }
}

