/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.Exceptions.CPartialLoadException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.InvalidDatabaseException;
import com.google.security.zynamics.binnavi.Database.Interfaces.ModuleConverter;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLAddressSpaceFunctions;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLDataFunctions;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLEdgeFunctions;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLFunctionFunctions;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLInstructionFunctions;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLModuleFunctions;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLNodeFunctions;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLProjectFunctions;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLRawModuleFunctions;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLSectionFunctions;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLSettingsFunctions;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLTagFunctions;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLTraceFunctions;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLTypeFunctions;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLViewFunctions;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgresSQLDebuggerFunctions;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Loaders.PostgreSQLAddressSpaceLoader;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Loaders.PostgreSQLCallgraphLoader;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Loaders.PostgreSQLFunctionsLoader;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Loaders.PostgreSQLModuleCallgraphsLoader;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Loaders.PostgreSQLModuleFlowgraphsLoader;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Loaders.PostgreSQLModuleMixedGraphsLoader;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Loaders.PostgreSQLProjectCallgraphLoader;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Loaders.PostgreSQLProjectFlowgraphsLoader;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Loaders.PostgreSQLProjectMixedGraphsLoader;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Loaders.PostgreSQLTracesLoader;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Loaders.PostgreSQLViewLoader;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Loaders.PostgreSQLViewsLoader;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.PostgreSQLHelpers;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.Tagging.CTagManager;
import com.google.security.zynamics.binnavi.Tagging.TagType;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplateManager;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceList;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.CAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.CCallgraph;
import com.google.security.zynamics.binnavi.disassembly.COperandTreeNode;
import com.google.security.zynamics.binnavi.disassembly.CProject;
import com.google.security.zynamics.binnavi.disassembly.ICallgraphView;
import com.google.security.zynamics.binnavi.disassembly.IFlowgraphView;
import com.google.security.zynamics.binnavi.disassembly.INaviAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviEdge;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviOperandTreeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.binnavi.disassembly.INaviRawModule;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModule;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.binnavi.disassembly.types.BaseType;
import com.google.security.zynamics.binnavi.disassembly.types.BaseTypeCategory;
import com.google.security.zynamics.binnavi.disassembly.types.RawBaseType;
import com.google.security.zynamics.binnavi.disassembly.types.RawTypeInstance;
import com.google.security.zynamics.binnavi.disassembly.types.RawTypeMember;
import com.google.security.zynamics.binnavi.disassembly.types.RawTypeSubstitution;
import com.google.security.zynamics.binnavi.disassembly.types.Section;
import com.google.security.zynamics.binnavi.disassembly.types.SectionPermission;
import com.google.security.zynamics.binnavi.disassembly.types.TypeMember;
import com.google.security.zynamics.binnavi.disassembly.types.TypeSubstitution;
import com.google.security.zynamics.binnavi.disassembly.views.CView;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.ImmutableNaviViewConfiguration;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.disassembly.ReferenceType;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.types.graphs.MutableDirectedGraph;
import com.google.security.zynamics.zylib.types.lists.IFilledList;
import com.google.security.zynamics.zylib.types.trees.ITreeNode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Map;

public abstract class AbstractSQLProvider
implements SQLProvider {
    private static final String[] TABLES = new String[]{"bn_projects", "bn_modules", "bn_address_spaces", "bn_space_modules", "bn_functions", "bn_function_views", "bn_instructions", "bn_operands", "bn_expression_tree", "bn_expression_tree_ids", "bn_expression_tree_mapping", "bn_code_nodes", "bn_codenode_instructions", "bn_edges", "bn_edge_paths", "bn_function_nodes", "bn_group_nodes", "bn_nodes", "bn_project_settings", "bn_module_settings", "bn_traces", "bn_trace_events", "bn_trace_event_values", "bn_views", "bn_module_views", "bn_project_views", "bn_view_settings", "bn_global_edge_comments", "bn_global_node_comments", "bn_project_debuggers", "bn_debuggers", "bn_tags", "bn_tagged_views", "bn_tagged_nodes", "bn_expression_substitutions", "bn_comments", "bn_comments_audit", "bn_types", "bn_base_types", "bn_users", "bn_expression_types"};
    protected final CConnection connection;
    protected List<INaviProject> projects;
    private List<INaviModule> modules;
    private List<INaviRawModule> rawModules;
    private CTagManager viewTagManager;
    protected CTagManager nodeTagManager;
    private final DebuggerTemplateManager debuggerManager = new DebuggerTemplateManager(this);

    public AbstractSQLProvider(CConnection connection) {
        this.connection = Preconditions.checkNotNull(connection, "IE00042: Connection argument can not be null");
    }

    private static String parseSQLFile(BufferedReader input) throws IOException {
        StringBuffer contents = new StringBuffer();
        String line = null;
        while ((line = input.readLine()) != null) {
            if (line.length() > 0 && line.charAt(0) == '#') continue;
            contents.append(line);
            contents.append('\n');
        }
        input.close();
        return contents.toString();
    }

    public static String parseResourceAsSQLFile(InputStream resource) throws IOException {
        return AbstractSQLProvider.parseSQLFile(new BufferedReader(new InputStreamReader(resource)));
    }

    public static String parseSystemResourceAsSQLFile(String file) throws IOException {
        return AbstractSQLProvider.parseSQLFile(new BufferedReader(new InputStreamReader(ClassLoader.getSystemResourceAsStream(file))));
    }

    protected abstract void createModulesTable() throws SQLException;

    protected void executeUpdate(String statement) throws SQLException {
        this.connection.executeUpdate(statement, true);
    }

    protected DebuggerTemplateManager getDebuggerManager() {
        return this.debuggerManager;
    }

    protected abstract ModuleConverter getModuleConverter();

    protected abstract String getTablesFile();

    protected boolean hasAllTables() throws CouldntLoadDataException, InvalidDatabaseException {
        NaviLogger.info("Checking the existence of the BinNavi database tables", new Object[0]);
        int counter = PostgreSQLHelpers.getTableCount(this.getConnection(), Lists.newArrayList(TABLES));
        if (counter == 0) {
            return false;
        }
        if (counter == TABLES.length) {
            return true;
        }
        throw new InvalidDatabaseException(String.format("Invalid database state (%d of %d tables found)", counter, TABLES.length));
    }

    protected abstract boolean hasTable(String var1) throws CouldntLoadDataException;

    protected void setRawModules(List<INaviRawModule> rawModules) {
        this.rawModules = rawModules;
    }

    @Override
    public void addDebugger(INaviProject project, DebuggerTemplate debugger) throws CouldntSaveDataException {
        PostgreSQLProjectFunctions.addDebugger(this, project, debugger);
    }

    @Override
    public void addModule(INaviAddressSpace addressSpace, INaviModule module) throws CouldntSaveDataException {
        PostgreSQLAddressSpaceFunctions.addModule(this, addressSpace, module);
    }

    @Override
    public void addReference(INaviOperandTreeNode node, IAddress address, ReferenceType type) throws CouldntSaveDataException {
        PostgreSQLInstructionFunctions.addReference(this, node, address, type);
    }

    @Override
    public Integer appendFunctionNodeComment(INaviFunctionNode functionNode, String commentText, Integer userId) throws CouldntSaveDataException {
        return PostgreSQLNodeFunctions.appendLocalFunctionNodeComment(this, functionNode, commentText, userId);
    }

    @Override
    public Integer appendGlobalCodeNodeComment(INaviCodeNode codeNode, String commentText, Integer userId) throws CouldntSaveDataException {
        return PostgreSQLNodeFunctions.appendGlobalCodeNodeComment(this, codeNode, commentText, userId);
    }

    @Override
    public Integer appendGlobalEdgeComment(INaviEdge edge, String commentText, Integer userId) throws CouldntSaveDataException {
        return PostgreSQLEdgeFunctions.appendGlobalEdgeComment(this, edge, commentText, userId);
    }

    @Override
    public Integer appendGlobalInstructionComment(INaviInstruction instruction, String commentText, Integer userId) throws CouldntSaveDataException {
        return PostgreSQLInstructionFunctions.appendGlobalInstructionComment(this, instruction, commentText, userId);
    }

    @Override
    public Integer appendLocalCodeNodeComment(INaviCodeNode codeNode, String commentText, Integer userId) throws CouldntSaveDataException {
        return PostgreSQLNodeFunctions.appendLocalCodeNodeComment(this, codeNode, commentText, userId);
    }

    @Override
    public Integer appendLocalEdgeComment(INaviEdge edge, String commentText, Integer userId) throws CouldntSaveDataException {
        return PostgreSQLEdgeFunctions.appendLocalEdgeComment(this, edge, commentText, userId);
    }

    @Override
    public Integer appendLocalInstructionComment(INaviCodeNode codeNode, INaviInstruction instruction, String commentText, Integer userId) throws CouldntSaveDataException {
        return PostgreSQLInstructionFunctions.appendLocalInstructionComment(this, codeNode, instruction, commentText, userId);
    }

    @Override
    public void assignDebugger(CAddressSpace addressSpace, DebuggerTemplate debugger) throws CouldntSaveDataException {
        PostgreSQLAddressSpaceFunctions.assignDebugger(this, addressSpace, debugger);
    }

    @Override
    public void assignDebugger(INaviModule module, DebuggerTemplate debugger) throws CouldntSaveDataException {
        PostgreSQLModuleFunctions.assignDebugger(this, module, debugger);
    }

    @Override
    public DebuggerTemplate createDebuggerTemplate(String name, String host, int port) throws CouldntSaveDataException {
        return PostgresSQLDebuggerFunctions.createDebuggerTemplate(this, name, host, port);
    }

    public void createEmptyTables() throws IOException, CouldntLoadDataException {
        String tablesFile = this.getTablesFile();
        Preconditions.checkNotNull(tablesFile, "IE01225: E00037: Tables file can not be null");
        NaviLogger.info("Reading BinNavi tables definition file %s", tablesFile);
        String string2 = String.valueOf(tablesFile);
        String sqlStatements = AbstractSQLProvider.parseSystemResourceAsSQLFile(string2.length() != 0 ? "com/google/security/zynamics/binnavi/data/".concat(string2) : new String("com/google/security/zynamics/binnavi/data/"));
        boolean hasModulesTable = this.hasTable("modules");
        try {
            if (!hasModulesTable) {
                this.createModulesTable();
            }
            this.executeUpdate(sqlStatements);
        }
        catch (SQLException e2) {
            CUtilityFunctions.logException(e2);
        }
    }

    @Override
    public int createSection(int moduleId, String name, Integer commentId, BigInteger startAddress, BigInteger endAddress, SectionPermission permission, byte[] data) throws CouldntSaveDataException {
        return PostgreSQLSectionFunctions.createSection(this.getConnection().getConnection(), moduleId, name, commentId, startAddress, endAddress, permission, data);
    }

    @Override
    public int createType(int moduleId, String name, int size, Integer childPointerTypeId, boolean signed, BaseTypeCategory category) throws CouldntSaveDataException {
        return PostgreSQLTypeFunctions.createType(this.getConnection().getConnection(), moduleId, name, size, childPointerTypeId, signed, category);
    }

    @Override
    public int createTypeInstance(int moduleId, String name, Integer commentId, int typeId, int sectionId, long sectionOffset) throws CouldntSaveDataException {
        return PostgreSQLTypeFunctions.createTypeInstance(this.getConnection().getConnection(), moduleId, name, commentId, typeId, sectionId, sectionOffset);
    }

    @Override
    public void createTypeInstanceReference(int moduleId, long address, int position, int expressionId, int typeInstanceId) throws CouldntSaveDataException {
        PostgreSQLTypeFunctions.createTypeInstanceReference(this.getConnection().getConnection(), moduleId, address, position, expressionId, typeInstanceId);
    }

    @Override
    public int createTypeMember(INaviModule module, int containingTypeId, int baseTypeId, String name, Optional<Integer> offset, Optional<Integer> numberOfElements, Optional<Integer> argumentIndex) throws CouldntSaveDataException {
        return PostgreSQLTypeFunctions.createTypeMember(this.getConnection().getConnection(), containingTypeId, offset, name, baseTypeId, numberOfElements, module);
    }

    @Override
    public void createTypeSubstitution(int treeNodeId, int baseTypeId, List<Integer> memberPath, int position, int offset, IAddress address, INaviModule module) throws CouldntSaveDataException {
        PostgreSQLTypeFunctions.createTypeSubstitution(this.getConnection().getConnection(), treeNodeId, baseTypeId, memberPath, position, offset, address, module);
    }

    @Override
    public void deleteAddressSpace(INaviAddressSpace addressSpace) throws CouldntDeleteException {
        PostgreSQLAddressSpaceFunctions.deleteAddressSpace(this, addressSpace);
    }

    @Override
    public void deleteDebugger(DebuggerTemplate debugger) throws CouldntDeleteException {
        PostgresSQLDebuggerFunctions.deleteDebugger(this, debugger);
    }

    @Override
    public void deleteMember(TypeMember member, INaviModule module) throws CouldntDeleteException {
        PostgreSQLTypeFunctions.deleteMember(this.getConnection().getConnection(), member, module);
    }

    @Override
    public void deleteProject(INaviProject project) throws CouldntDeleteException {
        PostgreSQLProjectFunctions.deleteProject(this, project);
    }

    @Override
    public void deleteRawModule(INaviRawModule module) throws CouldntDeleteException {
        PostgreSQLRawModuleFunctions.deleteRawModule(this, module);
    }

    @Override
    public void deleteReference(COperandTreeNode operandTreeNode, IAddress target, ReferenceType type) throws CouldntDeleteException {
        PostgreSQLInstructionFunctions.deleteReference(this, operandTreeNode, target, type);
    }

    @Override
    public void deleteTag(ITreeNode<CTag> tag) throws CouldntDeleteException {
        PostgreSQLTagFunctions.deleteTag(this, tag);
    }

    @Override
    public void deleteTagSubtree(ITreeNode<CTag> tag) throws CouldntDeleteException {
        PostgreSQLTagFunctions.deleteTagSubtree(this, tag);
    }

    @Override
    public void deleteTrace(TraceList trace2) throws CouldntDeleteException {
        PostgreSQLTraceFunctions.deleteTrace(this, trace2);
    }

    @Override
    public void deleteType(BaseType baseType, INaviModule module) throws CouldntDeleteException {
        PostgreSQLTypeFunctions.deleteType(this.getConnection().getConnection(), baseType, module);
    }

    @Override
    public void deleteTypeSubstitution(INaviModule module, TypeSubstitution typeSubstitution) throws CouldntDeleteException {
        PostgreSQLTypeFunctions.deleteTypeSubstitution(this.getConnection().getConnection(), module, typeSubstitution);
    }

    @Override
    public void deleteView(INaviView view) throws CouldntDeleteException {
        PostgreSQLViewFunctions.deleteView(this, view);
    }

    @Override
    public ResultSet executeQuery(String query) throws SQLException {
        return this.connection.executeQuery(query, true);
    }

    @Override
    public INaviModule findModule(final int moduleId) {
        return Iterables.find(this.modules, new Predicate<INaviModule>(){

            @Override
            public boolean apply(INaviModule module) {
                return module.getConfiguration().getId() == moduleId;
            }
        });
    }

    @Override
    public INaviProject findProject(final int projectId) {
        return Iterables.find(this.projects, new Predicate<INaviProject>(){

            @Override
            public boolean apply(INaviProject project) {
                return project.getConfiguration().getId() == projectId;
            }
        });
    }

    @Override
    public CConnection getConnection() {
        return this.connection;
    }

    @Override
    public List<INaviView> getDerivedViews(INaviView view) throws CouldntLoadDataException {
        return PostgreSQLViewFunctions.getDerivedViews(this, view);
    }

    @Override
    public Date getModificationDate(CAddressSpace addressSpace) throws CouldntLoadDataException {
        return PostgreSQLAddressSpaceFunctions.getModificationDate(this, addressSpace);
    }

    @Override
    public Date getModificationDate(INaviModule module) throws CouldntLoadDataException {
        return PostgreSQLModuleFunctions.getModificationDate(this, module);
    }

    @Override
    public Date getModificationDate(INaviProject project) throws CouldntLoadDataException {
        return PostgreSQLProjectFunctions.getModificationDate(this, project);
    }

    @Override
    public Date getModificationDate(INaviView view) throws CouldntLoadDataException {
        return PostgreSQLViewFunctions.getModificationDate(this, view);
    }

    @Override
    public List<INaviModule> getModules() {
        return this.modules;
    }

    @Override
    public CTagManager getNodeTagManager() {
        return this.nodeTagManager;
    }

    @Override
    public List<INaviProject> getProjects() {
        return this.projects;
    }

    public List<INaviRawModule> getRawModules() {
        return this.rawModules;
    }

    @Override
    public List<INaviView> getViewsWithAddress(INaviProject project, List<UnrelocatedAddress> addresses, boolean all) throws CouldntLoadDataException {
        return PostgreSQLProjectFunctions.getViewsWithAddresses(this, project, addresses, all);
    }

    @Override
    public List<INaviView> getViewsWithAddresses(INaviModule module, List<UnrelocatedAddress> addresses, boolean all) throws CouldntLoadDataException {
        return PostgreSQLModuleFunctions.getViewsWithAddresses(this, module, addresses, all);
    }

    @Override
    public CTagManager getViewTagManager() {
        return this.viewTagManager;
    }

    @Override
    public List<CAddressSpace> loadAddressSpaces(INaviProject project) throws CouldntLoadDataException {
        return PostgreSQLAddressSpaceLoader.loadAddressSpaces(this, project, this.getDebuggerManager(), this.getModules());
    }

    @Override
    public CCallgraph loadCallgraph(CModule module, int callgraphId, List<INaviFunction> functions) throws CouldntLoadDataException {
        return PostgreSQLCallgraphLoader.loadCallgraph(this, module, callgraphId, functions);
    }

    public IFilledList<ICallgraphView> loadCallgraphViews(CModule module) throws CouldntLoadDataException {
        return PostgreSQLModuleCallgraphsLoader.loadCallgraphViews(this, module, this.getViewTagManager(), this.nodeTagManager);
    }

    @Override
    public List<ICallgraphView> loadCallgraphViews(CProject project) throws CouldntLoadDataException {
        return PostgreSQLProjectCallgraphLoader.loadCallgraphViews(this, project, this.getViewTagManager(), this.nodeTagManager);
    }

    @Override
    public byte[] loadData(CModule module) throws CouldntLoadDataException {
        return PostgreSQLDataFunctions.loadData(this, module);
    }

    @Override
    public DebuggerTemplateManager loadDebuggers() throws CouldntLoadDataException {
        PostgresSQLDebuggerFunctions.loadDebuggers(this, this.getDebuggerManager());
        return this.getDebuggerManager();
    }

    @Override
    public ImmutableNaviViewConfiguration loadFlowGraphInformation(INaviModule module, Integer viewId) throws CouldntLoadDataException {
        return PostgreSQLModuleFlowgraphsLoader.loadFlowGraphInformation(this, module, viewId);
    }

    @Override
    public ImmutableNaviViewConfiguration loadFlowGraphInformation(INaviProject project, Integer viewId) throws CouldntLoadDataException {
        return PostgreSQLProjectFlowgraphsLoader.loadFlowGraphInformation(this, project, viewId);
    }

    @Override
    public ImmutableList<IFlowgraphView> loadFlowgraphs(CModule module) throws CouldntLoadDataException {
        return PostgreSQLModuleFlowgraphsLoader.loadFlowgraphs(this, module, this.getViewTagManager(), this.nodeTagManager);
    }

    @Override
    public List<IFlowgraphView> loadFlowgraphs(CProject project) throws CouldntLoadDataException {
        return PostgreSQLProjectFlowgraphsLoader.loadFlowgraphs(this, project, this.getViewTagManager(), this.nodeTagManager);
    }

    @Override
    public List<INaviFunction> loadFunctions(INaviModule module, List<IFlowgraphView> views) throws CouldntLoadDataException {
        return PostgreSQLFunctionsLoader.loadFunctions(this, module, views);
    }

    public IFilledList<INaviView> loadMixedgraphs(CModule module) throws CouldntLoadDataException {
        return PostgreSQLModuleMixedGraphsLoader.loadMixedgraphs(this, module, this.getViewTagManager(), this.nodeTagManager);
    }

    @Override
    public List<INaviView> loadMixedgraphs(CProject project) throws CouldntLoadDataException {
        return PostgreSQLProjectMixedGraphsLoader.loadMixedgraphs(this, project, this.getViewTagManager(), this.nodeTagManager);
    }

    @Override
    public List<Pair<IAddress, INaviModule>> loadModules(CAddressSpace addressSpace) throws CouldntLoadDataException {
        return PostgreSQLAddressSpaceFunctions.loadModules(this, addressSpace);
    }

    @Override
    public ICallgraphView loadNativeCallgraph(CModule module) throws CouldntLoadDataException {
        return PostgreSQLModuleCallgraphsLoader.loadNativeCallgraph(this, module, this.getViewTagManager(), this.nodeTagManager);
    }

    @Override
    public ImmutableList<IFlowgraphView> loadNativeFlowgraphs(CModule module) throws CouldntLoadDataException {
        return PostgreSQLModuleFlowgraphsLoader.loadNativeFlowgraphs(this, module, this.getViewTagManager(), this.nodeTagManager);
    }

    @Override
    public Map<Section, Integer> loadSections(INaviModule module) throws CouldntLoadDataException {
        return PostgreSQLSectionFunctions.loadSections(this, module);
    }

    @Override
    public Map<String, String> loadSettings(CView view) throws CouldntLoadDataException {
        return PostgreSQLViewFunctions.loadSettings(this, view);
    }

    public IFilledList<TraceList> loadTraces(CModule module) throws CouldntLoadDataException {
        return PostgreSQLTracesLoader.loadTraces(this, "bn_module_traces", "module_id", module.getConfiguration().getId(), this.getModules());
    }

    public IFilledList<TraceList> loadTraces(CProject project) throws CouldntLoadDataException {
        return PostgreSQLTracesLoader.loadTraces(this, "bn_project_traces", "project_id", project.getConfiguration().getId(), this.getModules());
    }

    @Override
    public List<RawTypeInstance> loadTypeInstances(INaviModule module) throws CouldntLoadDataException {
        return PostgreSQLTypeFunctions.loadRawTypeInstances(this.getConnection().getConnection(), module);
    }

    @Override
    public List<RawTypeMember> loadTypeMembers(INaviModule module) throws CouldntLoadDataException {
        return PostgreSQLTypeFunctions.loadRawTypeMembers(this.getConnection().getConnection(), module);
    }

    @Override
    public List<RawBaseType> loadTypes(INaviModule module) throws CouldntLoadDataException {
        return PostgreSQLTypeFunctions.loadRawTypes(this.getConnection().getConnection(), module);
    }

    @Override
    public List<RawTypeSubstitution> loadTypeSubstitutions(INaviModule module) throws CouldntLoadDataException {
        return PostgreSQLTypeFunctions.loadRawTypeSubstitutions(this.getConnection().getConnection(), module);
    }

    @Override
    public MutableDirectedGraph<INaviViewNode, INaviEdge> loadView(INaviView view) throws CouldntLoadDataException, CPartialLoadException {
        return PostgreSQLViewLoader.loadView(this, view, this.getModules(), this.nodeTagManager);
    }

    @Override
    public ImmutableBiMap<INaviView, INaviFunction> loadViewFunctionMapping(List<IFlowgraphView> flowgraphs, List<INaviFunction> functions, CModule module) throws CouldntLoadDataException {
        return PostgreSQLViewsLoader.loadViewFunctionMapping(this, flowgraphs, functions, module);
    }

    @Override
    public void moveTag(ITreeNode<CTag> parent, ITreeNode<CTag> child, TagType type) throws CouldntSaveDataException {
        PostgreSQLTagFunctions.moveTag(this, parent, child, type);
    }

    @Override
    public String readSetting(CModule module, String key) throws CouldntLoadDataException {
        return PostgreSQLSettingsFunctions.readSetting(this, module, key);
    }

    @Override
    public String readSetting(CProject project, String key) throws CouldntLoadDataException {
        return PostgreSQLSettingsFunctions.readSetting(this, project, key);
    }

    @Override
    public void removeDebugger(INaviProject project, DebuggerTemplate debugger) throws CouldntSaveDataException {
        PostgreSQLProjectFunctions.removeDebugger(this, project, debugger);
    }

    @Override
    public void removeModule(INaviAddressSpace addressSpace, INaviModule module) throws CouldntDeleteException, CouldntSaveDataException {
        PostgreSQLAddressSpaceFunctions.removeModule(this, addressSpace, module);
    }

    @Override
    public void removeTag(INaviView view, CTag tag) throws CouldntSaveDataException {
        PostgreSQLViewFunctions.untagView(this, view, tag);
    }

    @Override
    public void removeTagFromNode(INaviViewNode node, int tagId) throws CouldntSaveDataException {
        PostgreSQLNodeFunctions.untagNode(this, node, tagId);
    }

    @Override
    public void forwardFunction(INaviFunction source, INaviFunction target) throws CouldntSaveDataException {
        PostgreSQLFunctionFunctions.resolveFunction(this, source, target);
    }

    @Override
    public void saveSettings(CView view, Map<String, String> settings) throws CouldntSaveDataException {
        PostgreSQLViewFunctions.saveSettings(this, view, settings);
    }

    @Override
    public void saveTagToNode(INaviViewNode node, int tagId) throws CouldntSaveDataException {
        PostgreSQLNodeFunctions.tagNode(this, node, tagId);
    }

    @Override
    public void setDescription(CAddressSpace addressSpace, String description) throws CouldntSaveDataException {
        PostgreSQLAddressSpaceFunctions.setDescription(this, addressSpace, description);
    }

    @Override
    public void setDescription(CTag tag, String description) throws CouldntSaveDataException {
        PostgreSQLTagFunctions.setDescription(this, tag, description);
    }

    @Override
    public void setDescription(TraceList traceList, String description) throws CouldntSaveDataException {
        PostgreSQLTraceFunctions.setDescription(this, traceList, description);
    }

    @Override
    public void setDescription(INaviFunction function, String comment) throws CouldntSaveDataException {
        PostgreSQLFunctionFunctions.setDescription(this, function, comment);
    }

    @Override
    public void setDescription(INaviModule module, String description) throws CouldntSaveDataException {
        PostgreSQLModuleFunctions.setDescription(this, module, description);
    }

    @Override
    public void setDescription(INaviProject project, String description) throws CouldntSaveDataException {
        PostgreSQLProjectFunctions.setDescription(this, project, description);
    }

    @Override
    public void setDescription(INaviView view, String description) throws CouldntSaveDataException {
        PostgreSQLViewFunctions.setDescription(this, view, description);
    }

    @Override
    public void setFileBase(INaviModule module, IAddress addr) throws CouldntSaveDataException {
        PostgreSQLModuleFunctions.setFileBase(this, module, addr);
    }

    @Override
    public void setGlobalReplacement(INaviOperandTreeNode operandTreeNode, String replacement) throws CouldntSaveDataException {
        PostgreSQLInstructionFunctions.setGlobalReplacement(this, operandTreeNode, replacement);
    }

    @Override
    public void setHost(DebuggerTemplate debugger, String host) throws CouldntSaveDataException {
        PostgresSQLDebuggerFunctions.setHost(this, debugger, host);
    }

    @Override
    public void setImageBase(INaviAddressSpace addressSpace, INaviModule module, IAddress addr) throws CouldntSaveDataException {
        PostgreSQLAddressSpaceFunctions.setImageBase(this, addressSpace, module, addr);
    }

    @Override
    public void setImageBase(INaviModule module, IAddress addr) throws CouldntSaveDataException {
        PostgreSQLModuleFunctions.setImageBase(this, module, addr);
    }

    @Override
    public void setModules(List<INaviModule> modules) {
        this.modules = modules;
    }

    @Override
    public void setName(CAddressSpace addressSpace, String name) throws CouldntSaveDataException {
        PostgreSQLAddressSpaceFunctions.setName(this, addressSpace, name);
    }

    @Override
    public void setName(DebuggerTemplate debugger, String name) throws CouldntSaveDataException {
        PostgresSQLDebuggerFunctions.setName(this, debugger, name);
    }

    @Override
    public void setName(CTag tag, String name) throws CouldntSaveDataException {
        PostgreSQLTagFunctions.setName(this, tag, name);
    }

    @Override
    public void setName(TraceList traceList, String name) throws CouldntSaveDataException {
        PostgreSQLTraceFunctions.setName(this, traceList, name);
    }

    @Override
    public void setName(INaviFunction function, String name) throws CouldntSaveDataException {
        PostgreSQLFunctionFunctions.setName(this, function, name);
    }

    @Override
    public void setName(INaviModule module, String name) throws CouldntSaveDataException {
        PostgreSQLModuleFunctions.setName(this, module, name);
    }

    @Override
    public void setName(INaviProject project, String name) throws CouldntSaveDataException {
        PostgreSQLProjectFunctions.setName(this, project, name);
    }

    @Override
    public void setName(INaviView view, String name) throws CouldntSaveDataException {
        PostgreSQLViewFunctions.setName(this, view, name);
    }

    @Override
    public void setPort(DebuggerTemplate debugger, int port) throws CouldntSaveDataException {
        PostgresSQLDebuggerFunctions.setPort(this, debugger, port);
    }

    @Override
    public void setReplacement(COperandTreeNode operandTreeNode, String replacement) throws CouldntSaveDataException {
        PostgreSQLInstructionFunctions.setReplacement(this, operandTreeNode, replacement);
    }

    @Override
    public void setSectionName(int moduleId, int sectionId, String name) throws CouldntSaveDataException {
        PostgreSQLSectionFunctions.setSectionName(this.getConnection().getConnection(), moduleId, sectionId, name);
    }

    @Override
    public void setStared(INaviModule module, boolean isStared) throws CouldntSaveDataException {
        PostgreSQLModuleFunctions.starModule(this, module, isStared);
    }

    @Override
    public void setStared(INaviView view, boolean isStared) throws CouldntSaveDataException {
        PostgreSQLViewFunctions.starView(this, view, isStared);
    }

    public void setViewTagManager(CTagManager viewTagManager) {
        this.viewTagManager = viewTagManager;
    }

    public void setViewTagManaget(CTagManager viewTagManager) {
        this.setViewTagManager(viewTagManager);
    }

    @Override
    public void tagView(INaviView view, CTag tag) throws CouldntSaveDataException {
        PostgreSQLViewFunctions.tagView(this, view, tag);
    }

    @Override
    public void updateMember(TypeMember member, String newName, BaseType newBaseType, Optional<Integer> newoffset, Optional<Integer> newNumberOfElements, Optional<Integer> newArgumentIndex, INaviModule module) throws CouldntSaveDataException {
        PostgreSQLTypeFunctions.updateTypeMember(this.getConnection().getConnection(), member, newName, newBaseType, newoffset, newNumberOfElements, newArgumentIndex, module);
    }

    @Override
    public void updateMemberOffsets(List<Integer> updatedMembers, int delta, List<Integer> implicitlyUpdatedMembers, int implicitDelta, INaviModule module) throws CouldntSaveDataException {
        PostgreSQLTypeFunctions.updateMemberOffsets(this.getConnection().getConnection(), updatedMembers, delta, implicitlyUpdatedMembers, implicitDelta, module);
    }

    @Override
    public void updateType(BaseType baseType, String name, int size, boolean isSigned, INaviModule module) throws CouldntSaveDataException {
        PostgreSQLTypeFunctions.updateType(this.getConnection().getConnection(), baseType, name, size, isSigned, module);
    }

    @Override
    public void updateTypeSubstitution(TypeSubstitution substitution, BaseType baseType, List<Integer> memberPath, int offset, INaviModule module) throws CouldntSaveDataException {
        PostgreSQLTypeFunctions.updateTypeSubstitution(this.getConnection().getConnection(), substitution, baseType, memberPath, substitution.getPosition(), offset, module);
    }

    @Override
    public void writeSetting(CModule module, String key, String value) throws CouldntSaveDataException {
        PostgreSQLSettingsFunctions.writeSetting(this, module, key, value);
    }

    @Override
    public void writeSetting(CProject project, String key, String value) throws CouldntSaveDataException {
        PostgreSQLSettingsFunctions.writeSetting(this, project, key, value);
    }
}

