/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi;

import com.google.security.zynamics.binnavi.API.gui.MainWindow;
import com.google.security.zynamics.binnavi.API.plugins.PluginInterface;
import com.google.security.zynamics.binnavi.Database.CDatabase;
import com.google.security.zynamics.binnavi.Database.CDatabaseManager;
import com.google.security.zynamics.binnavi.Gui.MainWindow.CProjectMainFrame;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.Plugins.PluginRegistry;
import com.google.security.zynamics.binnavi.Resources.BuildVersionInformation;
import com.google.security.zynamics.binnavi.Resources.Constants;
import com.google.security.zynamics.binnavi.Startup.CBatchPluginExecuter;
import com.google.security.zynamics.binnavi.Startup.CConfigurationFileCreator;
import com.google.security.zynamics.binnavi.Startup.CGraphPanelExtender;
import com.google.security.zynamics.binnavi.Startup.CSettingsDirectoryCreator;
import com.google.security.zynamics.binnavi.Startup.CommandlineOptions;
import com.google.security.zynamics.binnavi.Startup.CommandlineParser;
import com.google.security.zynamics.binnavi.Startup.GuiInitializer;
import com.google.security.zynamics.binnavi.config.ConfigManager;
import com.google.security.zynamics.binnavi.config.DatabaseConfigItem;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import com.google.security.zynamics.zylib.io.FileUtils;

public final class CMain {
    private CMain() {
    }

    private static void prepareDatabaseConnections() {
        NaviLogger.info("Initializing database connections", new Object[0]);
        CDatabaseManager manager = CDatabaseManager.instance();
        for (DatabaseConfigItem database : ConfigManager.instance().getDatabases()) {
            manager.addDatabase(new CDatabase(database.getDescription(), database.getDriver(), database.getHost(), database.getName(), database.getUser(), database.getPassword(), database.getIdentity(), database.isSavePassword(), database.isAutoConnect()));
        }
    }

    public static void main(String[] args) {
        String startPath;
        CSettingsDirectoryCreator.createSettingsDirectory();
        boolean firstStart = !CConfigurationFileCreator.setupConfigurationFile();
        BuildVersionInformation.loadBuildVersionInformation();
        System.out.printf("Starting %s%n", Constants.PROJECT_NAME_VERSION_BUILD);
        CGraphPanelExtender.extend();
        GuiInitializer.initialize();
        if (firstStart) {
            CDatabase newDatabase = new CDatabase("Click and configure me", "org.postgresql.Driver", "localhost", "new_database", "user", "password", "identity", false, false);
            CDatabaseManager.instance().addDatabase(newDatabase);
        }
        CMain.prepareDatabaseConnections();
        PluginRegistry pluginRegistry = new PluginRegistry();
        Constants.startPath = startPath = FileUtils.findLocalRootPath(CMain.class);
        NaviLogger.info("Defaulting startup path to %s", startPath);
        CDatabaseManager databaseManager = CDatabaseManager.instance();
        PluginInterface pluginInterface = PluginInterface.instance(startPath, databaseManager, pluginRegistry);
        CProjectMainFrame window = new CProjectMainFrame(databaseManager, ConfigManager.instance(), firstStart);
        pluginInterface.setMainWindow(new MainWindow(window));
        pluginInterface.reloadPlugins();
        CommandlineOptions options = CommandlineParser.parseCommandLine(args);
        if (options.getBatchPlugin() != null) {
            CBatchPluginExecuter.execute(options.getBatchPlugin(), pluginRegistry);
        }
        window.setVisible(true);
        GuiHelper.applyWindowFix(window);
    }

    static {
        try {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        catch (Exception e2) {
            System.setProperty("com.apple.macos.useScreenMenuBar", "true");
        }
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "BinNavi");
    }
}

