/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.reil.mono;

import com.google.security.zynamics.binnavi.API.reil.mono.DefaultStateVector;
import com.google.security.zynamics.binnavi.API.reil.mono.IGraphWalker;
import com.google.security.zynamics.binnavi.API.reil.mono.ILattice;
import com.google.security.zynamics.binnavi.API.reil.mono.ILatticeElement;
import com.google.security.zynamics.binnavi.API.reil.mono.ILatticeGraph;
import com.google.security.zynamics.binnavi.API.reil.mono.IStateVector;
import com.google.security.zynamics.binnavi.API.reil.mono.ITransformationProvider;
import com.google.security.zynamics.binnavi.REIL.mono.apiwrappers.LatticeWrapper;
import java.util.List;

public class MonotoneSolver<GraphNode, LatticeElement extends ILatticeElement<LatticeElement>, ObjectType, Lattice extends ILattice<LatticeElement, ObjectType>> {
    private final ILatticeGraph<GraphNode> graph;
    private final Lattice lattice;
    private final IStateVector<GraphNode, LatticeElement> state;
    private final ITransformationProvider<GraphNode, LatticeElement> transformationList;
    private final IGraphWalker<GraphNode, ObjectType> walker;

    public MonotoneSolver(ILatticeGraph<GraphNode> graph, Lattice lattice, IStateVector<GraphNode, LatticeElement> startVector, ITransformationProvider<GraphNode, LatticeElement> transformationProvider, IGraphWalker<GraphNode, ObjectType> walker) {
        if (graph == null) {
            throw new IllegalArgumentException("Error: Graph argument can not be null");
        }
        if (lattice == null) {
            throw new IllegalArgumentException("Error: Lattice argument can not be null");
        }
        if (startVector == null) {
            throw new IllegalArgumentException("Error: Start vector argument can not be null");
        }
        if (transformationProvider == null) {
            throw new IllegalArgumentException("Error: Transformation list argument can not be null");
        }
        List<GraphNode> nodes = graph.getNodes();
        if (nodes.size() != startVector.size()) {
            throw new IllegalArgumentException(String.format("Error: Invalid start vector (%d states for %d nodes)", startVector.size(), nodes.size()));
        }
        for (GraphNode node : nodes) {
            if (startVector.hasState(node)) continue;
            String string2 = String.valueOf(node);
            throw new IllegalArgumentException(new StringBuilder(62 + String.valueOf(string2).length()).append("Error: Node ").append(string2).append(" does not have a state in the initial state vector").toString());
        }
        this.graph = graph;
        this.lattice = lattice;
        this.state = startVector;
        this.transformationList = transformationProvider;
        this.walker = walker;
    }

    private IStateVector<GraphNode, LatticeElement> convert(com.google.security.zynamics.reil.algorithms.mono.IStateVector<GraphNode, LatticeElement> vector) {
        DefaultStateVector<GraphNode, ILatticeElement> convertedVector = new DefaultStateVector<GraphNode, ILatticeElement>();
        for (GraphNode node : this.graph.getNodes()) {
            convertedVector.setState(node, (ILatticeElement)vector.getState(node));
        }
        return convertedVector;
    }

    public final IStateVector<GraphNode, LatticeElement> solve() {
        return this.convert(new com.google.security.zynamics.reil.algorithms.mono.MonotoneSolver(this.graph, new LatticeWrapper(this.lattice), this.state, this.transformationList, this.walker, null).solve());
    }
}

