/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.reil;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.disassembly.BasicBlock;
import com.google.security.zynamics.binnavi.API.disassembly.Function;
import com.google.security.zynamics.binnavi.API.disassembly.Instruction;
import com.google.security.zynamics.binnavi.API.disassembly.View;
import com.google.security.zynamics.binnavi.API.reil.InternalTranslationException;
import com.google.security.zynamics.binnavi.API.reil.NativeArchitecture;
import com.google.security.zynamics.binnavi.API.reil.ReilFunction;
import com.google.security.zynamics.binnavi.API.reil.ReilGraph;
import com.google.security.zynamics.binnavi.API.reil.ReilInstruction;
import com.google.security.zynamics.binnavi.REIL.InstructionFinders;
import com.google.security.zynamics.binnavi.REIL.ReilGraphConverter;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.ITranslator;
import com.google.security.zynamics.reil.translators.StandardEnvironment;
import com.google.security.zynamics.reil.translators.arm.TranslatorARM;
import com.google.security.zynamics.reil.translators.ppc.TranslatorPPC;
import com.google.security.zynamics.reil.translators.reil.TranslatorREIL;
import com.google.security.zynamics.reil.translators.x86.TranslatorX86;
import java.util.ArrayList;
import java.util.List;

public final class ReilTranslator {
    private static final com.google.security.zynamics.reil.translators.ReilTranslator<INaviInstruction> m_translator = new com.google.security.zynamics.reil.translators.ReilTranslator();

    private ReilTranslator() {
    }

    private static ITranslator<INaviInstruction> getTranslator(NativeArchitecture architecture) {
        switch (architecture) {
            case X86_32: {
                return new TranslatorX86<INaviInstruction>();
            }
            case PPC_32: {
                return new TranslatorPPC<INaviInstruction>();
            }
            case ARM_32: {
                return new TranslatorARM<INaviInstruction>();
            }
            case REIL: {
                return new TranslatorREIL<INaviInstruction>();
            }
        }
        throw new IllegalArgumentException("Error: Unknown REIL architecture");
    }

    public static ReilGraph translate(BasicBlock block) throws InternalTranslationException {
        Preconditions.checkNotNull(block, "Error: Block argument can't be null");
        try {
            return ReilGraphConverter.createReilGraph(m_translator.translate((ITranslationEnvironment)new StandardEnvironment(), (INaviInstruction)((Object)block.getNative())));
        }
        catch (com.google.security.zynamics.reil.translators.InternalTranslationException e2) {
            throw new InternalTranslationException(e2, InstructionFinders.findInstruction(block, e2.getInstruction()));
        }
    }

    public static ReilFunction translate(Function function) throws InternalTranslationException {
        Preconditions.checkNotNull(function, "Error: Function argument can't be null");
        try {
            return new ReilFunction(m_translator.translate((ITranslationEnvironment)new StandardEnvironment(), function.getNative()));
        }
        catch (com.google.security.zynamics.reil.translators.InternalTranslationException e2) {
            throw new InternalTranslationException(e2, InstructionFinders.findInstruction(function, e2.getInstruction()));
        }
    }

    public static ReilFunction translate(View view) throws InternalTranslationException {
        Preconditions.checkNotNull(view, "Error: View argument can't be null");
        try {
            return new ReilFunction(m_translator.translate((ITranslationEnvironment)new StandardEnvironment(), view.getNative()));
        }
        catch (com.google.security.zynamics.reil.translators.InternalTranslationException e2) {
            throw new InternalTranslationException(e2, InstructionFinders.findInstruction(view, e2.getInstruction()));
        }
    }

    public static List<ReilInstruction> translateInstruction(NativeArchitecture architecture, Instruction instruction) throws InternalTranslationException {
        Preconditions.checkNotNull(architecture, "Error: Architecture argument can not be null");
        Preconditions.checkNotNull(instruction, "Error: Instruction argument can't be null");
        ArrayList<ReilInstruction> instructions = new ArrayList<ReilInstruction>();
        StandardEnvironment environment = new StandardEnvironment();
        try {
            for (com.google.security.zynamics.reil.ReilInstruction reilInstruction : ReilTranslator.getTranslator(architecture).translate(environment, instruction.getNative(), new ArrayList())) {
                instructions.add(new ReilInstruction(reilInstruction));
            }
            return instructions;
        }
        catch (com.google.security.zynamics.reil.translators.InternalTranslationException e2) {
            throw new InternalTranslationException(e2, instruction);
        }
    }
}

