/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.reil;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.disassembly.Address;
import com.google.security.zynamics.binnavi.API.reil.OperandType;
import com.google.security.zynamics.binnavi.API.reil.ReilInstruction;
import com.google.security.zynamics.binnavi.API.reil.ReilOperand;
import com.google.security.zynamics.zylib.disassembly.CAddress;

public final class ReilHelpers {
    private ReilHelpers() {
    }

    public static boolean isFunctionCall(ReilInstruction instruction) {
        Preconditions.checkNotNull(instruction, "Error: Instruction argument can not be null");
        return com.google.security.zynamics.reil.ReilHelpers.isFunctionCall(instruction.getNative());
    }

    public static boolean isNativeRegister(ReilOperand operand) {
        Preconditions.checkNotNull(operand, "Operand argument can not be null");
        return com.google.security.zynamics.reil.ReilHelpers.isNativeRegister(operand.getNative());
    }

    public static boolean isRegister(ReilOperand operand) {
        Preconditions.checkNotNull(operand, "Operand argument argument can not be null");
        return operand.getType() == OperandType.REGISTER;
    }

    public static boolean isReilRegister(ReilOperand operand) {
        Preconditions.checkNotNull(operand, "Operand argument can not be null");
        return com.google.security.zynamics.reil.ReilHelpers.isTemporaryRegister(operand.getNative());
    }

    public static boolean isReilRegister(String value) {
        Preconditions.checkNotNull(value, "Value argument can not be null");
        return com.google.security.zynamics.reil.ReilHelpers.isTemporaryRegister(value);
    }

    public static boolean isTernaryInstruction(ReilInstruction instruction) {
        Preconditions.checkNotNull(instruction, "Instruction argument can not be null");
        return instruction.getMnemonic().equalsIgnoreCase("ADD") || instruction.getMnemonic().equalsIgnoreCase("SUB") || instruction.getMnemonic().equalsIgnoreCase("MUL") || instruction.getMnemonic().equalsIgnoreCase("DIV") || instruction.getMnemonic().equalsIgnoreCase("MOD") || instruction.getMnemonic().equalsIgnoreCase("BSH") || instruction.getMnemonic().equalsIgnoreCase("AND") || instruction.getMnemonic().equalsIgnoreCase("OR") || instruction.getMnemonic().equalsIgnoreCase("XOR");
    }

    public static boolean isUnconditionalJump(ReilInstruction instruction) {
        Preconditions.checkNotNull(instruction, "Instruction argument can not be null");
        return com.google.security.zynamics.reil.ReilHelpers.isUnconditionalJump(instruction.getNative());
    }

    public static Address toNativeAddress(Address address) {
        return new Address(com.google.security.zynamics.reil.ReilHelpers.toNativeAddress(new CAddress(address.toLong())).toBigInteger());
    }

    public static Address toReilAddress(Address address) {
        return new Address(com.google.security.zynamics.reil.ReilHelpers.toReilAddress(new CAddress(address.toLong())).toBigInteger());
    }
}

