/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.reil;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.disassembly.Address;
import com.google.security.zynamics.binnavi.API.disassembly.IGraphNode;
import com.google.security.zynamics.binnavi.API.reil.ReilInstruction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class ReilBlock
implements IGraphNode<ReilBlock>,
Iterable<ReilInstruction> {
    private final List<ReilInstruction> m_instructions;
    private final List<ReilBlock> m_parents = new ArrayList<ReilBlock>();
    private final List<ReilBlock> m_children = new ArrayList<ReilBlock>();

    public ReilBlock(com.google.security.zynamics.reil.ReilBlock block) {
        this.m_instructions = ReilBlock.createInstructions(block);
    }

    public ReilBlock(List<ReilInstruction> instructions) {
        Preconditions.checkNotNull(instructions, "Error: Instructions argument can not be null");
        for (ReilInstruction instruction : instructions) {
            Preconditions.checkNotNull(instruction, "Error: Instructions list contains a null-element");
        }
        this.m_instructions = new ArrayList<ReilInstruction>(instructions);
    }

    private static List<ReilInstruction> createInstructions(com.google.security.zynamics.reil.ReilBlock block) {
        ArrayList<ReilInstruction> instructions = new ArrayList<ReilInstruction>();
        for (com.google.security.zynamics.reil.ReilInstruction reilInstruction : block.getInstructions()) {
            instructions.add(new ReilInstruction(reilInstruction));
        }
        return instructions;
    }

    protected static void link(ReilBlock parent, ReilBlock child) {
        parent.m_children.add(child);
        child.m_parents.add(parent);
    }

    public Address getAddress() {
        return this.m_instructions.get(0).getAddress();
    }

    @Override
    public List<ReilBlock> getChildren() {
        return new ArrayList<ReilBlock>(this.m_children);
    }

    public List<ReilInstruction> getInstructions() {
        return new ArrayList<ReilInstruction>(this.m_instructions);
    }

    @Override
    public List<ReilBlock> getParents() {
        return new ArrayList<ReilBlock>(this.m_parents);
    }

    @Override
    public Iterator<ReilInstruction> iterator() {
        return this.m_instructions.iterator();
    }

    public String toString() {
        StringBuilder strinBuilder = new StringBuilder();
        for (ReilInstruction instruction : this.m_instructions) {
            strinBuilder.append(instruction.toString());
            strinBuilder.append('\n');
        }
        return strinBuilder.toString();
    }
}

