/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.helpers;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class TreeNode<ObjectType> {
    private TreeNode<ObjectType> m_parent;
    private final List<TreeNode<ObjectType>> m_children = new ArrayList<TreeNode<ObjectType>>();
    private final ObjectType m_object;

    public TreeNode(ObjectType object) {
        this.m_object = Preconditions.checkNotNull(object, "Error: Node argument can not be null");
    }

    public static <ObjectType> void link(TreeNode<ObjectType> parent, TreeNode<ObjectType> child) {
        parent.m_children.add(child);
        child.m_parent = parent;
    }

    public void addChild(TreeNode<ObjectType> child) {
        this.m_children.add(child);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TreeNode safeNode = (TreeNode)object;
        return Objects.equals(this.m_object, safeNode.m_object);
    }

    public List<TreeNode<ObjectType>> getChildren() {
        return new ArrayList<TreeNode<ObjectType>>(this.m_children);
    }

    public ObjectType getObject() {
        return this.m_object;
    }

    public TreeNode<ObjectType> getParent() {
        return this.m_parent;
    }

    public int hashCode() {
        return Objects.hash(this.getChildren(), this.getObject());
    }

    public void removeChild(TreeNode<ObjectType> child) {
        this.m_children.remove(child);
    }

    public void setParent(TreeNode<ObjectType> parent) {
        this.m_parent = parent;
    }

    public String toString() {
        return this.m_object.toString();
    }
}

